<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useScrollBar="{@useHeaderScroll}">
	<script type="text/javascript">
		var transferSize = 12 * 1024;

		var startTime = parent.QUERY.document.getElementById( "stTime" ).value;
		var endRendTime = null;

		if(document.addEventListener) {
			if(document.getBoxObjectFor) {
				document.addEventListener("DOMContentLoaded", setPageTiming2, null);		//Gecho
			}
			else {
				window.addEventListener("load", setPageTiming2, false);
			}
		}
		else if(document.attachEvent) {
			document.attachEvent("onreadystatechange", setPageTiming2);
		}
		else {
			window.onload = setPageTiming2;
		}

		function setPageTiming2(evt) {
			var bSetIt;
			if( document.attachEvent ) { bSetIt = (document.readyState=="complete" ); }
			else					   { bSetIt = true; }

			if(bSetIt) {
				var queryTime = parent.QUERY.getValue( document.getElementById("queryTime") );
				var viewTime  = parent.QUERY.getValue( document.getElementById("viewTime" ) );
				timecheck2( queryTime, viewTime );
			}
		}

		function timecheck2( queryTime,viewTime ) {
			endRendTime = (new Date()).getTime();
			var pageTime = (endRendTime - startTime - queryTime - viewTime);

			<og:equals val1="{@useHeaderScroll}" val2="true" notEquals="true">
				timeCheck3();
			</og:equals>

			document.getElementById("qTime").innerHTML = queryTime;
			document.getElementById("vTime").innerHTML = viewTime;
			document.getElementById("pTime").innerHTML = pageTime;

			basicInformation();
		}

		<og:equals val1="{@useHeaderScroll}" val2="true">
		;(function ($) {
			$.hgrid.load = function (evt) {
				$("#GantBody").heightReset();
				$("div > div > div > div > table.viewTable").hybsGrid().adjustSB();
				if(focus2) { focus2(); }
				timeCheck3();
			};
			$(window).unbind("load.hgrid").bind("load.hgrid", $.hgrid.load)
		})(jQuery);
		</og:equals>

		function timeCheck3() {
			var endTime = (new Date()).getTime();
			var headerTime = (endTime - endRendTime);
			var totalTime = (endTime - startTime);

			document.getElementById("hTime").innerHTML = headerTime;
			document.getElementById("tTime").innerHTML = totalTime;

			transStartTime = new Date();
			$.ajax({
				url : "test.bmp"
				,async : false
			})
			transEndTime = new Date();

			trnsTime = transEndTime - transStartTime;
			trnsSpeed = Math.round( transferSize / ( trnsTime ) * 1000 );

			document.getElementById("sTime").innerHTML = trnsTime;
			document.getElementById("rTime").innerHTML = trnsSpeed;
		}

		function basicInformation() {
			document.getElementById("platform").innerHTML = navigator.platform;
			document.getElementById("browser").innerHTML = navigator.appName;
			document.getElementById("version").innerHTML = navigator.appVersion;
			document.getElementById("cpu").innerHTML = navigator.cpuClass
		}

	</script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7120"
	title	= "レスポンス調査"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
/>

[Test Results]
<table>
<tr>
<td valign="top">
&amp;nbsp;1.JSP Page Processing (Columns: 20,Rows: <og:text>{@maxRowCount}</og:text>(all) <og:text>{@pageSize}</og:text>(view))
<table style="margin-left:20px" >
	<tr>
		<td width="100px">DB(Query) :</td><td id="qTime" align="right" width="50px"></td><td>(ms)</td>
	</tr>
	<tr>
		<td width="100px">JSP(View) :</td><td id="vTime" align="right" width="50px"></td><td>(ms)</td>
	</tr>
	<tr>
		<td width="100px">IE(Page)  :</td><td id="pTime" align="right" width="50px"></td><td>(ms)</td>
	</tr>
	<tr>
		<td width="100px">HeaderFix :</td><td id="hTime" align="right" width="50px"></td><td>(ms)</td>
	</tr>
	<tr>
		<td width="100px">Total     :</td><td id="tTime" align="right" width="50px"></td><td>(ms)</td>
	</tr>
</table>
</td>
<td valign="top" style="padding-left:20px" >
&amp;nbsp;2.Network Transfer (FileSize: 12MB)
<table style="margin-left:20px" >
	<tr>
		<td width="100px">Time      :</td><td id="sTime" align="right" width="50px"></td><td>(ms)</td>
	</tr>
	<tr>
		<td width="100px">Rate      :</td><td id="rTime" align="right" width="50px"></td><td>(KB/s)</td>
	</tr>
</table>
</td>
</tr>
</table>

<hr width="95%" />

[Server Information]
<br/>
<table style="margin-left:20px" >
	<tr>
		<td width="100px">Engine version :</td><td><og:text>{@SYS.ENGINE_INFO}</og:text></td>
	</tr>
</table>

[Client Information]
<br/>
<table style="margin-left:20px" >
	<tr>
		<td width="100px">Test User :</td><td width="200px"><og:text>{@USER.ID}</og:text></td>
		<td width="100px">Test Date :</td><td width="200px"><og:text>{@SYS.DATE}</og:text></td>
	</tr>
	<tr>
		<td width="100px">IP Address :</td><td><og:text>{@USER.IPADDRESS}</og:text></td>
		<td width="100px">Remote Host :</td><td><og:text><jsp:scriptlet>out.println( request.getRemoteHost() );</jsp:scriptlet></og:text></td>
	</tr>
</table>
[Client Platform Information]
<br/>
<table style="margin-left:20px" >
	<tr>
		<td width="100px">CPU Info :</td><td id="cpu" ></td>
	</tr>
	<tr>
		<td width="100px">Platform :</td><td id="platform" ></td>
	</tr>
	<tr>
		<td width="100px">Browser :</td><td colspan="3" id="browser" ></td>
	</tr>
	<tr>
		<td width="100px">&amp;nbsp;(version) :</td><td colspan="3" id="version" ></td>
	</tr>
</table>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	select *
	from GF41
	where rownum &lt;= {@maxRowCount}
	order by SYSTEM_ID,CLM,LANG
</og:query>

<og:view
	command = "{@command}"
	pageSize = "{@pageSize}"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
