<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"><!-- --></script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7201"
	title	= "横棒／縦棒グラフ"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="NEW">
	SELECT 	 ENAME							<!-- 営業担当者 -->
			,SAL									<!-- 売上( 1月) -->
			FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
</og:query>

<div onClick="updatechart(myChart)">update</div>


<canvas id="mycanvas" height="400" width="400"></canvas>



<script>

// jsonで取得
var querydata =
<og:view
	viewFormType = "JSON"
	command    = "NEW"
	useHilightRow = "false"
	useAfterHtmlTag = "false"
	useConsistency = "false"
	pageSize   = "1000" />
;

//var datadata =  [12, 19, 3, 5, 2, 3];
var datadata = [];
var datalabels = [];
for(var i=0; i&lt; querydata.DATA.length; i++){
	datadata[i] = querydata.DATA[i].SAL;
	datalabels[i] = querydata.DATA[i].ENAME;
}

var chartdata = {
        labels: datalabels,
        datasets: [{
            label: 'SAL',
            data: datadata,
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            borderColor:'rgba(255,99,132,1)',
            borderWidth: 1
        }]
    };



var myChart = new Chart( mycanvas,{
				type: 'bar',
				data: chartdata,
				options: {
				     responsive: false
				}
			});

var updatechart = function(mc){
	
	$.ajax({
			url:'ajax.jsp',
			async:true, // 非同期通信
			type: 'GET',
			dataType: 'json',
			success: function(jsn){
				var _datadata = [];
				var _datalabels = [];
				for(var i=0; i&lt; jsn.DATA.length; i++){
					_datadata[i] = jsn.DATA[i].SAL;
					_datalabels[i] = jsn.DATA[i].ENAME;
				}
				mc.data.datasets[0].data = _datadata;
				// ラベル変更がある場合はmc.destroy()で破棄して作り直し
				//mc.label = _datalabels;
				mc.update();
			}
		});
	
	

}

</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
