<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />


<jsp:directive.include file="/jsp/custom/result_info.jsp" />
左のチャートをクリックする事で、右のチャートのデータをajax経由で持ってきて更新します。

	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query>
		SELECT DEPTNO
				,DNAME LABELS
				,(select sum(SAL) from emp where emp.deptno = dept.deptno) SAL
		FROM DEPT
		order by 1
	</og:query>

<!--
	<script type="text/javascript">
		// Chart.plugins.register で、登録すると、すべてのチャートに適用されます。
		Chart.plugins.register( chartLabelPin );
	</script>
-->
<div style="float:left;">
	<og:jsChart
		id					= "MainChart"
		chartType			= "pie"
		height				= "{@height}"
		width				= "{@width}"
		max					= "{@max}"
		min					= "{@min}"
		labelColumn			= "LABELS"
		title				= "{@chartTitle}"
		titlePosition		= "{@titlePosition}"
		legendDisplay		= "{@legendDisplay}"
		legendPosition		= "{@legendPosition}"
		xscaleType			= "{@xscaleType}"
		yscaleType			= "{@yscaleType}"
		ycategoryList		= "{@ycategoryList}"
		optionAttributes	= ""
		plugins				= "chartLabelPlugin"
		onClick				= "updatechart(obj,'SubChart')"
		debug				= "{@debug}"
	>
	<og:jsChartData
			chartColumn			= "SAL"
			borderColor			= "{@borderColor}"
			borderWidth			= "{@borderWidth}"
			backgroundColor		= "{@backgroundColor}"
			optionAttributes	= ""
			 />
	</og:jsChart>
</div>
	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query scope="request" tableId="tbl2">
		SELECT JOB    as LABELS
			,sum(SAL) as SAL , max(EMPNO) as EMPNO , max(ENAME) as ENAME
		FROM emp
		group by job
		order by 1
	</og:query>
<div>

<!-- oota tmp modify onClick属性から、
 qb_hybscanvastbl2で選択したグラフの情報が取得可能です。
 (id設定時はqb+id。idが未設定の場合は自動設定。)
 ※データ以外をクリック時も呼ばれるため、if文で制御しています。
 ※ver6ではラベル名とデータのみが保持されており、利用可能です。
  -->
 <!-- console.log(qd_hybscanvastbl2.DATA);console.log(obj[0]._index);if(obj[0]){clickLink(qd_hybscanvastbl2.DATA[obj[0]._index]);} -->

	<og:jsChart
		id					= "SubChart"
		chartType			= "bar"
		height				= "{@height}"
		width				= "{@width}"
		max					= "10000"
		min					= "{@min}"
		labelColumn			= "LABELS"
		legendDisplay		= "false"
		optionAttributes	= ""
		onClick				= "clickLink( event, obj,'index.jsp?chartTitle={LBL}&amp;markValues={CLM}' , parent );"
		plugins				= "chartLabelPlugin"
		scope				= "request"
		tableId				= "tbl2"
		debug				= "{@debug}"
	>
		<og:jsChartData
			chartColumn			= "SAL"
			borderColor			= "{@borderColor}"
			borderWidth			= "{@borderWidth}"
			backgroundColor		= "{@backgroundColor}"
			optionAttributes	= ""
		 />
		<og:jsChartData
			chartColumn			= "EMPNO"
			borderColor			= "{@borderColor}"
			borderWidth			= "{@borderWidth}"
			backgroundColor		= "{@backgroundColor}"
			optionAttributes	= ""
		 />
	</og:jsChart>
</div>

<!-- エラー確認用 -->
エラー時の情報:
<div id="err"></div>

<script type="text/javascript">
	// 左の円形を選択時に、右の棒グラフを更新します。
	// ※ラベル名を利用しているため、重複したラベル名が存在する場合、正しく動作しません。
	var updatechart = function(obj,tgtId){
		// チャートの空白箇所クリック時の処理
		if( obj[0] ) {
			// ver6ではラベル名と値のみ保持しており、利用可能です。
			var labelNm = obj[0]._chart.data.labels[obj[0]._index];
			var chTgt   = eval("chart_" + tgtId);		// アクセス先のオブジェクトを取得

			$.ajax({
				url:'sample5_ajax.jsp',
				async:true, // 非同期通信
				type: 'GET',
				data: {'LABELNM': labelNm},
				dataType: 'json',
				success: function(jsn){
					for(var i=0; i&lt; jsn.DATA.length; i++){
						chTgt.data.datasets[0].data[i]	= jsn.DATA[i].SAL;
						chTgt.data.datasets[1].data[i]	= jsn.DATA[i].EMPNO;
						chTgt.data.labels[i]			= jsn.DATA[i].LABELS;
					}
					// ラベル変更は難しいが、データセットの変更だけなら簡単
					// 新たなラベルが増えるような場合が面倒になる？
					chTgt.update();
				},
				error: function(err){
					$('#err').html(err.responseText);
				}
			});
		}
	}

//		// 棒グラフクリック時に呼び出されて、画面を遷移するための処理です。
//		// URLは適当です。
//		// リンクは、{LBL} と、{CLM} が、ラベルとグラフのデータに置き換えられます。
//		//	var link = "query.jsp?chartTitle={LBL}&amp;markValues={CLM}"
//		var clickLink = function( event,obj,link,frame ){
//			var trg = obj[0]._chart.getElementAtEvent(event);
//			if( !frame ) { frame = this; }
//
//			if( trg[0] ) {
//				var idx = trg[0]._index;
//				var sel = trg[0]._datasetIndex;							// グラフの番号
//
//				var lbl = trg[0]._chart.data.labels[idx];				// 0:ﾗﾍﾞﾙ
//				var val = trg[0]._chart.data.datasets[sel].data[idx];	// グラフのデータ
//
//				var html = link.replace(/\{LBL\}/g,lbl ).replace(/\{CLM\}/g,val );
//
//				alert(html + ' に遷移します。');
//				frame.location.href = html;
//			}
//		}
</script>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
