/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HttpConnect;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.xml.XML2TableParser;
import org.opengion.fukurou.xml.XSLT;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class URLConnectTag
extends CommonTagSupport {
    private static final String VERSION = "6.9.0.1 (2018/02/05)";
    private static final long serialVersionUID = 690120180205L;
    private static final String DEFAULT_USER = "admin:admin";
    private transient DBTableModel table;
    private String urlStr;
    private String[] keys;
    private String[] vals;
    private String xslFile;
    private String saveFile;
    private String postKey;
    private String postData;
    private int timeout = HybsSystem.sysInt("URL_CONNECT_TIMEOUT");
    private boolean useSystemUser = true;
    private String authUserPass;
    private boolean display;
    private String proxyHost;
    private int proxyPort = -1;
    private String method = "GET";
    private boolean errNglctFlag;
    private String tableId = "h_tblmdl";
    private String rowKey;
    private String[] colKeys;
    private String[] rtnKeys;
    private String encode = "UTF-8";
    private boolean isTableOut;
    private boolean isOutParse;
    private boolean isMainTrans = true;

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        if (this.rowKey != null || this.colKeys != null || this.rtnKeys != null) {
            this.isOutParse = true;
            if (this.rowKey != null || this.colKeys != null) {
                this.isTableOut = true;
                this.useMainTrans(this.isMainTrans);
                this.startQueryTransaction(this.tableId);
            }
        }
        return this.postData == null ? 2 : 0;
    }

    @Override
    public int doAfterBody() {
        this.postData = this.getBodyString();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        String string;
        Object object;
        PrintWriter printWriter;
        ByteArrayOutputStream byteArrayOutputStream;
        block21: {
            this.debugPrint();
            if (!this.useTag()) {
                return 6;
            }
            HttpConnect httpConnect = null;
            byteArrayOutputStream = null;
            printWriter = null;
            try {
                httpConnect = this.connect();
                if (this.isOutParse) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    printWriter = FileUtil.getPrintWriter((OutputStream)byteArrayOutputStream, (String)"UTF-8");
                } else if (this.display) {
                    printWriter = FileUtil.getNonFlushPrintWriter((Writer)this.pageContext.getOut());
                } else if (this.saveFile != null) {
                    printWriter = FileUtil.getPrintWriter((File)new File(this.saveFile), (String)"UTF-8");
                }
                object = httpConnect.readData();
                if (printWriter == null) break block21;
                if (this.xslFile == null) {
                    ((Writer)printWriter).write((String)object);
                    break block21;
                }
                string = new XSLT();
                string.setXslFile(this.xslFile);
                string.setOutFile((Writer)printWriter);
                string.transform((Reader)new StringReader((String)object));
                string.close();
            }
            catch (Throwable throwable) {
                try {
                    string = "\u30c7\u30fc\u30bf\u53d6\u5f97\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + " url=[" + this.urlStr + "]" + CR + " message=[" + (httpConnect == null ? "NO_CONNECTION" : httpConnect.getMessage()) + "]" + CR + " Exception=[" + throwable.getMessage() + "]";
                    if (!this.errNglctFlag) {
                        throw new HybsSystemException(string, throwable);
                    }
                    LogWriter.log((String)string);
                }
                catch (Throwable throwable2) {
                    Closer.ioClose(printWriter);
                    throw throwable2;
                }
                Closer.ioClose((Closeable)printWriter);
            }
        }
        Closer.ioClose((Closeable)printWriter);
        if (this.isOutParse) {
            try {
                object = new BufferedInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                try {
                    this.parse((InputStream)object);
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            catch (IOException iOException) {
                string = "parse \u51e6\u7406\u4e2d\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + "\t close() \u30a8\u30e9\u30fc\u3067\u3059\u3002" + CR + "\t " + iOException.getMessage() + CR;
                System.err.println(string);
            }
            if (this.isTableOut && this.table != null && !this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("URLConnectTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        return 6;
    }

    private HttpConnect connect() throws IOException {
        if (this.useSystemUser) {
            this.authUserPass = DEFAULT_USER;
        }
        HttpConnect httpConnect = null;
        httpConnect = new HttpConnect(this.urlStr, this.authUserPass);
        httpConnect.setDebug(this.isDebug());
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                httpConnect.addRequestProperty(this.keys[i], this.vals[i]);
            }
        }
        if ("POST".equalsIgnoreCase(this.method)) {
            httpConnect.usePost(true);
        }
        if (this.postKey != null) {
            httpConnect.usePost(true);
            httpConnect.addRequestProperty(this.postKey, this.postData);
        }
        if (this.proxyHost != null) {
            httpConnect.setProxy(this.proxyHost, this.proxyPort);
        }
        if (this.encode != null && this.encode.length() > 0) {
            httpConnect.setCharset(this.encode);
        }
        if (this.timeout >= 0) {
            httpConnect.setTimeout(this.timeout);
        }
        return httpConnect;
    }

    private void parse(InputStream inputStream) {
        XML2TableParser xML2TableParser = new XML2TableParser(inputStream);
        xML2TableParser.setTableCols(this.rowKey, this.colKeys);
        xML2TableParser.setReturnCols(this.rtnKeys);
        xML2TableParser.parse();
        if (this.isTableOut) {
            this.table = DBTableModelUtil.makeDBTable(xML2TableParser.getCols(), xML2TableParser.getData(), this.getResource());
        }
        if (this.rtnKeys != null) {
            ConcurrentMap concurrentMap = xML2TableParser.getRtn();
            concurrentMap.forEach((string, string2) -> this.setRequestAttribute((String)string, string2));
        }
    }

    @Override
    protected void release2() {
        super.release2();
        this.urlStr = null;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.keys = null;
        this.vals = null;
        this.xslFile = null;
        this.saveFile = null;
        this.postKey = null;
        this.postData = null;
        this.timeout = HybsSystem.sysInt("URL_CONNECT_TIMEOUT");
        this.useSystemUser = true;
        this.authUserPass = null;
        this.display = false;
        this.method = "GET";
        this.errNglctFlag = false;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.rowKey = null;
        this.colKeys = null;
        this.rtnKeys = null;
        this.isTableOut = false;
        this.isOutParse = false;
        this.encode = "UTF-8";
        this.isMainTrans = true;
    }

    public void setUrl(String string) {
        this.urlStr = StringUtil.nval((String)this.getRequestParameter(string), (String)this.urlStr);
    }

    public void setProxyHost(String string) {
        this.proxyHost = StringUtil.nval((String)this.getRequestParameter(string), (String)this.proxyHost);
        this.useSystemUser = false;
    }

    public void setProxyPort(String string) {
        this.proxyPort = StringUtil.nval((String)this.getRequestParameter(string), (int)this.proxyPort);
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(string);
    }

    public void setVals(String string) {
        this.vals = this.getCSVParameter(string);
    }

    public void setMethod(String string) {
        this.method = StringUtil.nval((String)this.getRequestParameter(string), (String)this.method);
    }

    public void setUseSystemUser(String string) {
        this.useSystemUser = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useSystemUser);
    }

    public void setAuthUserPass(String string) {
        this.authUserPass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.authUserPass);
    }

    public void setXslFile(String string) {
        this.xslFile = HybsSystem.url2dir(StringUtil.nval((String)this.getRequestParameter(string), (String)this.xslFile));
    }

    public void setDisplay(String string) {
        this.display = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.display);
        if (this.display && this.saveFile != null) {
            throw new HybsSystemException("display=\"true\" \u3068\u3001saveFile \u3092\u4f75\u7528\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
    }

    public void setSaveFile(String string) {
        this.saveFile = HybsSystem.url2dir(StringUtil.nval((String)this.getRequestParameter(string), (String)this.saveFile));
        if (this.display) {
            throw new HybsSystemException("display=\"true\" \u3068\u3001saveFile \u3092\u4f75\u7528\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
    }

    public void setPostKey(String string) {
        this.postKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.postKey);
    }

    public void setTimeout(String string) {
        this.timeout = StringUtil.nval((String)this.getRequestParameter(string), (int)this.timeout);
    }

    public void setPostFile(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.postData = FileUtil.getValue((String)HybsSystem.url2dir(string2), (String)"UTF-8");
        }
    }

    public void setErrNeglect(String string) {
        this.errNglctFlag = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.errNglctFlag);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setRowKey(String string) {
        this.rowKey = StringUtil.nval((String)this.getRequestParameter(string), (String)this.rowKey);
    }

    public void setColKeys(String string) {
        this.colKeys = StringUtil.csv2Array((String)this.getRequestParameter(string));
    }

    public void setRtnKeys(String string) {
        this.rtnKeys = StringUtil.csv2Array((String)this.getRequestParameter(string));
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    @Override
    protected String getTagName() {
        return "urlConnect";
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("method", (Object)this.method).println("urlStr", (Object)this.urlStr).println("keys", (Object)StringUtil.array2csv((String[])this.keys)).println("vals", (Object)StringUtil.array2csv((String[])this.vals)).println("proxyHost", (Object)this.proxyHost).println("proxyPort", (Object)this.proxyPort).println("timeout", (Object)this.timeout).println("useSystemUser", (Object)this.useSystemUser).println("authUserPass", (Object)this.authUserPass).println("display", (Object)this.display).println("postKey", (Object)this.postKey).println("postData", (Object)this.postData).println("xslFile", (Object)this.xslFile).println("saveFile", (Object)this.saveFile).println("errNglctFlag", (Object)this.errNglctFlag).println("tableId", (Object)this.tableId).println("rowKey", (Object)this.rowKey).println("colKeys", (Object)StringUtil.array2csv((String[])this.colKeys)).println("rtnKeys", (Object)StringUtil.array2csv((String[])this.rtnKeys)).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

