/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.TableFilter;
import org.opengion.hayabusa.resource.ResourceManager;

public abstract class AbstractTableFilter
implements TableFilter {
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;
    private DBTableModel table;
    private String modifyType;
    private int[] rowNo;
    private boolean useDebug;
    private Transaction tran;
    private String sql;
    private String dbid;
    private ResourceManager resource;
    private int errCode = 0;
    private ErrorMessage errMessage;
    private final ConcurrentMap<String, String> keyValMap = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> rtnValMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> keysMap = Collections.synchronizedMap(new LinkedHashMap());
    protected static final String XML_START_TAG = "<?xml version='1.0' encoding='UTF-8'?>" + CR + "<ROWSET tableName='xxx'>";
    protected static final String XML_END_TAG = "</ROWSET>";
    protected static final String EXEC_START_TAG = "<EXEC_SQL>";
    protected static final String EXEC_END_TAG = "</EXEC_SQL>";
    protected boolean isXml;
    protected String execEndTag;

    protected AbstractTableFilter() {
    }

    protected void initSet(String string, String string2) {
        if (string != null && string2 != null) {
            this.keysMap.put(string, string2);
        }
    }

    @Override
    public void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public void setModifyType(String string) {
        this.modifyType = string;
    }

    @Override
    public String getModifyType() {
        return this.modifyType;
    }

    @Override
    public void setKeysVals(String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setKeyVal(stringArray[i], stringArray2[i]);
            }
        }
    }

    private void setKeyVal(String string, String string4) {
        if (string == null || string4 == null) {
            return;
        }
        String string5 = string.toUpperCase(Locale.JAPAN);
        if (!this.keysMap.isEmpty() && !this.keysMap.containsKey(string5)) {
            String string6 = "<br>" + CR;
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(string6).append("\u6307\u5b9a\u306e\u30ad\u30fc\u306f\u3001\u3053\u306e tableFilter \u3067\u306f\u3001\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002").append(string6).append("  class=[").append(this.getClass().getName()).append(']').append(string6).append("  key  =[").append(string).append(']').append(string6).append("  ======== usage keys ======== ").append(string6);
            this.keysMap.forEach((string2, string3) -> stringBuilder.append(' ').append((String)string2).append(':').append((String)string3).append(string6));
            stringBuilder.append("  ============================ ").append(string6);
            throw new HybsSystemException(stringBuilder.toString());
        }
        this.keyValMap.put(string5, string4);
    }

    @Override
    public void setParameterRows(int ... nArray) {
        if (nArray != null && nArray.length > 0) {
            int n = nArray.length;
            this.rowNo = new int[n];
            System.arraycopy(nArray, 0, this.rowNo, 0, n);
        }
    }

    @Override
    public int[] getParameterRows() {
        return this.rowNo == null ? new int[]{} : (int[])this.rowNo.clone();
    }

    @Override
    public void setTransaction(Transaction transaction) {
        this.tran = transaction;
    }

    @Override
    public Transaction getTransaction() {
        return this.tran;
    }

    @Override
    public void setDbid(String string) {
        this.dbid = string;
    }

    @Override
    public String getDbid() {
        return this.dbid;
    }

    @Override
    public void setSql(String string) {
        this.sql = string;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public void setParamMap(ConcurrentMap<String, String> concurrentMap) {
        if (concurrentMap != null) {
            concurrentMap.forEach((string, string2) -> this.setKeyVal((String)string, (String)string2));
        }
    }

    @Override
    public void setResource(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    @Override
    public ResourceManager getResource() {
        return this.resource;
    }

    @Override
    public Map<String, String> getReturnMap() {
        return this.rtnValMap;
    }

    @Override
    public void setDebug(boolean bl) {
        this.useDebug = bl;
    }

    @Override
    public boolean isDebug() {
        return this.useDebug;
    }

    @Override
    public int getErrorCode() {
        return this.errCode;
    }

    @Override
    public ErrorMessage getErrorMessage() {
        return this.errMessage;
    }

    protected ErrorMessage makeErrorMessage(String string, int n) {
        if (this.errMessage == null) {
            this.errMessage = new ErrorMessage(string);
        }
        if (this.errCode < n) {
            this.errCode = n;
        }
        return this.errMessage;
    }

    protected int[] getTableColumnNo(String ... stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.table.getColumnNo(stringArray[i]);
        }
        return nArray;
    }

    protected String getValue(String string) {
        return string == null ? null : (String)this.keyValMap.get(string);
    }

    protected void setValue(String string, String string2) {
        if (string != null && string2 != null) {
            this.rtnValMap.put(string, string2);
        }
    }

    protected String[] getKeys() {
        return this.keyValMap.keySet().toArray(new String[this.keyValMap.size()]);
    }
}

