/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.ColumnData;

final class ColumnDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String SEL_CLM = "select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU";
    private static final String QUERY = "select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU,0 as SNO from GEA03 where SYSTEM_ID='**' and FGJ='1' union all select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU,1 as SNO from GEA03 where SYSTEM_ID=? and FGJ='1' union all select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU,2 as SNO from GEA03 where SYSTEM_ID=? and FGJ='1' order by SNO,KBSAKU,CLM";
    private static final String QUERY2 = "select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU,0 as SNO from GEA03 where SYSTEM_ID='**' and CLM=? and FGJ='1' union all select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU,1 as SNO from GEA03 where SYSTEM_ID=? and CLM=? and FGJ='1' union all select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,'' AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU,2 as SNO from GEA03 where SYSTEM_ID=? and CLM=? and FGJ='1' order by SNO,KBSAKU,CLM";
    private static final boolean IS_FGLOAD_AUTOSET = HybsSystem.sysBool("USE_FGLOAD_AUTOSET");
    private static final String UPDATE2 = "update GEA03 set FGLOAD='2' where UNIQ=? and CLM=?";
    private final Map<String, ColumnData> columnMap = Collections.synchronizedMap(new WeakHashMap());
    private final String SYSTEM_ID;
    private final String BASE_SYS_ID;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    ColumnDataLoader(String string, String string2, boolean bl) {
        this.SYSTEM_ID = string;
        this.BASE_SYS_ID = string2;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ColumnDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        if (bl) {
            this.loadDBResource();
        }
    }

    private void loadDBResource() {
        String[] stringArray = new String[]{this.BASE_SYS_ID, this.SYSTEM_ID};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        int[] nArray = new int[3];
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i][0];
            int n2 = Integer.parseInt(stringArray2[i][20]);
            if ("1".equals(stringArray2[i][16])) {
                this.columnMap.put(string, new ColumnData(stringArray2[i]));
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
                continue;
            }
            if (this.columnMap.get(string) == null) continue;
            this.columnMap.remove(string);
        }
        System.out.println("  ColumnDataLoader [" + n + "] select [" + this.columnMap.size() + "]  ** [" + nArray[0] + "] " + this.BASE_SYS_ID + " [" + nArray[1] + "] " + this.SYSTEM_ID + " [" + nArray[2] + "] loaded");
    }

    public ColumnData getColumnData(String string) {
        String[] stringArray;
        String[][] stringArray2;
        ColumnData columnData = this.columnMap.get(string);
        if (columnData == null && (stringArray2 = DBUtil.dbExecute((String)QUERY2, (String[])(stringArray = new String[]{string, this.BASE_SYS_ID, string, this.SYSTEM_ID, string}), (ApplicationInfo)this.appInfo, (String)this.DBID)).length > 0) {
            int n = stringArray2.length - 1;
            columnData = new ColumnData(stringArray2[n]);
            this.columnMap.put(string, columnData);
            if (IS_FGLOAD_AUTOSET) {
                String string2 = stringArray2[n][16];
                String string3 = stringArray2[n][18];
                if (!("1".equals(string2) || "2".equals(string2) || "**".equals(string3))) {
                    String[] stringArray3 = new String[]{stringArray2[n][17], string};
                    DBUtil.dbExecute((String)UPDATE2, (String[])stringArray3, (ApplicationInfo)this.appInfo, (String)this.DBID);
                }
            }
        }
        return columnData;
    }

    public void clear(String string) {
        System.out.println("SYSTEM_ID=[" + this.SYSTEM_ID + "] , Key=[" + string + "] \u306e\u90e8\u5206\u30ea\u30bd\u30fc\u30b9\u30af\u30ea\u30a2\u3092\u5b9f\u65bd\u3057\u307e\u3057\u305f\u3002");
        this.columnMap.remove(string);
    }

    public void clear() {
        System.out.println("SYSTEM_ID=[" + this.SYSTEM_ID + "] \u306e\u5168\u30ea\u30bd\u30fc\u30b9\u3092\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f\u3002");
        this.columnMap.clear();
    }
}

