/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

public class InstrumentationFilter
implements Cloneable {
    public static final int INSTR_FILTER_NONE = 0;
    public static final int INSTR_FILTER_EXCLUSIVE = 10;
    public static final int INSTR_FILTER_INCLUSIVE = 20;
    private static InstrumentationFilter defaultInstance;
    private String[] instrFilterStrings;
    private int instrFilterType;

    public InstrumentationFilter() {
        this.clearFilter();
    }

    public static InstrumentationFilter getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new InstrumentationFilter();
        }
        return defaultInstance;
    }

    public void setFilterStrings(String string) {
        string = string.replace(',', ' ');
        string = string.replace('.', '/');
        this.setSlashedFilterStrings(string.trim().split(" +"));
    }

    public String[] getFilterStrings() {
        return this.instrFilterStrings;
    }

    public void setFilterType(int n) {
        this.instrFilterType = n;
    }

    public int getFilterType() {
        return this.instrFilterType;
    }

    public void setSlashedFilterStrings(String[] stringArray) {
        this.instrFilterStrings = stringArray;
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            String string = this.instrFilterStrings[i];
            if (!string.endsWith("*")) continue;
            this.instrFilterStrings[i] = string.substring(0, string.length() - 1);
        }
    }

    public void clearFilter() {
        this.instrFilterType = 0;
        this.instrFilterStrings = new String[0];
    }

    public Object clone() throws CloneNotSupportedException {
        InstrumentationFilter instrumentationFilter = (InstrumentationFilter)super.clone();
        instrumentationFilter.instrFilterStrings = new String[this.instrFilterStrings.length];
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            instrumentationFilter.instrFilterStrings[i] = this.instrFilterStrings[i];
        }
        return instrumentationFilter;
    }

    public String debug() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.instrFilterType) {
            case 0: {
                stringBuffer.append("  Filter type: None\n");
                break;
            }
            case 10: {
                stringBuffer.append("  Filter type: Exclusive\n");
                break;
            }
            case 20: {
                stringBuffer.append("  Filter type: Inclusive\n");
            }
        }
        stringBuffer.append("  Filter value: ");
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            stringBuffer.append(this.instrFilterStrings[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void debugDump() {
        System.err.println("----------------------------------");
        System.err.println("Instrumentation filter debug dump:");
        switch (this.instrFilterType) {
            case 0: {
                System.err.println("  Filter type: None");
                break;
            }
            case 10: {
                System.err.println("  Filter type: Exclusive");
                break;
            }
            case 20: {
                System.err.println("  Filter type: Inclusive");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.instrFilterStrings.length; ++i) {
            stringBuffer.append(this.instrFilterStrings[i]);
            stringBuffer.append(" ");
        }
        System.err.println("  Filter strings: " + stringBuffer.toString());
    }

    public boolean passesFilter(String string) {
        boolean bl;
        if (this.instrFilterType == 0) {
            return true;
        }
        if (this.instrFilterStrings.length == 0) {
            return true;
        }
        boolean bl2 = bl = this.instrFilterType == 20;
        if (bl) {
            for (int i = 0; i < this.instrFilterStrings.length; ++i) {
                if (!InstrumentationFilter.matches(string, this.instrFilterStrings[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.instrFilterStrings.length; ++i) {
                if (!InstrumentationFilter.matches(string, this.instrFilterStrings[i])) continue;
                return false;
            }
        }
        return !bl;
    }

    private static boolean matches(String string, String string2) {
        return string.startsWith(string2);
    }
}

