/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.modules.startup;

import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;

public class VisualVMStartup
extends ModuleInstall {
    private static final boolean DISABLE_STARTUP_CHECK = Boolean.getBoolean("com.sun.tools.visualvm.modules.startup.DisableStartupCheck");
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)VisualVMStartup.class);
    private static final String ERROR_STARTUP_CAPTION = bundle.getString("VisualVMStartup_ErrorStartupCaption");
    private static final String INCORRECT_VERSION_MSG = bundle.getString("VisualVMStartup_IncorrectVersionMsg");
    private static final String JRE_MSG = bundle.getString("VisualVMStartup_JreMsg");

    public void validate() {
        if (DISABLE_STARTUP_CHECK) {
            System.err.println("Starting with com.sun.tools.visualvm.modules.startup.DisableStartupCheck=true");
        } else if (!VisualVMStartup.isJava6or7()) {
            VisualVMStartup.displayError6or7();
            LifecycleManager.getDefault().exit();
        } else if (!VisualVMStartup.isJDK()) {
            VisualVMStartup.displayErrorJRE();
            LifecycleManager.getDefault().exit();
        }
    }

    private static void setSystemLaF() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void displayError6or7() {
        VisualVMStartup.setSystemLaF();
        JOptionPane.showMessageDialog(null, MessageFormat.format(INCORRECT_VERSION_MSG, System.getProperty("java.specification.version"), VisualVMStartup.getJavaInfo(), VisualVMStartup.getJvmInfo(), System.getProperties().getProperty("java.home", "unknown location")), ERROR_STARTUP_CAPTION, 0);
    }

    private static void displayErrorJRE() {
        VisualVMStartup.setSystemLaF();
        JOptionPane.showMessageDialog(null, MessageFormat.format(JRE_MSG, VisualVMStartup.getJavaInfo(), VisualVMStartup.getJvmInfo(), System.getProperties().getProperty("java.home", "unknown location")), ERROR_STARTUP_CAPTION, 0);
    }

    private static boolean isJava6or7() {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion == null) {
            return false;
        }
        return javaVersion.startsWith("1.6") || javaVersion.startsWith("1.7");
    }

    private static boolean isJDK() {
        Class<?> vmClass = null;
        try {
            vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return vmClass != null;
    }

    private static String getJavaInfo() {
        Properties systemProperties = System.getProperties();
        String javaVersion = systemProperties.getProperty("java.version", "unknown version");
        String vendorInfo = systemProperties.getProperty("java.vendor", "unknown vendor");
        return javaVersion + "; " + vendorInfo;
    }

    private static String getJvmInfo() {
        Properties systemProperties = System.getProperties();
        String vmName = systemProperties.getProperty("java.vm.name", "unknown name");
        String vmVerison = systemProperties.getProperty("java.vm.version", "");
        String vmInfo = systemProperties.getProperty("java.vm.info", "");
        return vmName + " (" + vmVerison + ", " + vmInfo + ")";
    }
}

