/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.scheduler;

import com.sun.tools.visualvm.core.scheduler.Quantum;
import com.sun.tools.visualvm.core.scheduler.ScheduledTask;
import com.sun.tools.visualvm.core.scheduler.SchedulerTask;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class DefaultScheduledTask
implements ScheduledTask,
SchedulerTask {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final ReadWriteLock intervalLock = new ReentrantReadWriteLock();
    private Quantum interval;
    private SchedulerTask delegateTask;
    private Quantum suspendedFrom = Quantum.SUSPENDED;

    public DefaultScheduledTask(Quantum interval, SchedulerTask task) {
        this.delegateTask = task;
        this.setInterval(interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(Quantum interval) {
        this.intervalLock.writeLock().lock();
        Quantum oldInterval = interval;
        try {
            oldInterval = this.interval;
            this.interval = interval;
        }
        finally {
            this.intervalLock.writeLock().unlock();
        }
        this.pcs.firePropertyChange("Task.Interval", oldInterval, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quantum getInterval() {
        this.intervalLock.readLock().lock();
        try {
            Quantum quantum = this.interval;
            return quantum;
        }
        finally {
            this.intervalLock.readLock().unlock();
        }
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void suspend() {
        if (this.suspendedFrom.equals(Quantum.SUSPENDED)) {
            this.suspendedFrom = this.getInterval();
        }
        this.setInterval(Quantum.SUSPENDED);
    }

    public void resume() {
        this.setInterval(this.suspendedFrom);
        this.suspendedFrom = Quantum.SUSPENDED;
    }

    public boolean isSuspended() {
        return this.interval.equals(Quantum.SUSPENDED);
    }

    public void onSchedule(long timeStamp) {
        this.delegateTask.onSchedule(timeStamp);
    }
}

