/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.options.OptionsPanel;
import org.netbeans.modules.options.classic.OptionsAction;
import org.netbeans.modules.options.export.OptionsChooserPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public class OptionsDisplayerImpl {
    private static Dialog dialog;
    private static WeakReference<DialogDescriptor> descriptorRef;
    private static String title;
    private static Logger log;
    private boolean modal;
    static final LookupListener lookupListener;
    private JButton bOK;
    private JButton bClassic;
    private JButton btnExport;
    private JButton btnImport;

    public OptionsDisplayerImpl(boolean bl) {
        this.modal = bl;
        try {
            FileUtil.getConfigRoot().getFileSystem().addFileChangeListener((FileChangeListener)new DefaultFSListener());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
    }

    public boolean isOpen() {
        return dialog != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void selectCategory(String string) {
        DialogDescriptor dialogDescriptor = null;
        Object object = lookupListener;
        synchronized (object) {
            dialogDescriptor = (DialogDescriptor)descriptorRef.get();
        }
        if (dialogDescriptor != null) {
            object = (OptionsPanel)dialogDescriptor.getMessage();
            String string2 = string.indexOf(47) == -1 ? string : string.substring(0, string.indexOf(47));
            String string3 = string.indexOf(47) == -1 ? null : string.substring(string.indexOf(47) + 1);
            ((OptionsPanel)object).initCurrentCategory(string2, string3);
        }
        dialog.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showOptionsDialog(String string, String string2) {
        if (this.isOpen()) {
            dialog.setVisible(true);
            dialog.toFront();
            log.fine("Front Options Dialog");
            return;
        }
        DialogDescriptor dialogDescriptor = null;
        Object object = lookupListener;
        synchronized (object) {
            dialogDescriptor = (DialogDescriptor)descriptorRef.get();
        }
        object = null;
        if (dialogDescriptor == null) {
            object = string == null ? new OptionsPanel() : new OptionsPanel(string);
            this.bOK = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_OK");
            this.bOK.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_OKButton"));
            this.bClassic = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Classic");
            this.bClassic.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_ClassicButton"));
            this.btnExport = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Export");
            this.btnExport.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_Export"));
            this.btnImport = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Import");
            this.btnImport.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_Import"));
            this.updateButtons();
            boolean bl = Utilities.isMac();
            Object[] objectArray = new Object[]{bl ? DialogDescriptor.CANCEL_OPTION : this.bOK, bl ? this.bOK : DialogDescriptor.CANCEL_OPTION};
            dialogDescriptor = new DialogDescriptor(object, title, this.modal, objectArray, DialogDescriptor.OK_OPTION, 0, null, null, false);
            dialogDescriptor.setAdditionalOptions(new Object[]{this.bClassic, this.btnExport, this.btnImport});
            dialogDescriptor.setHelpCtx(((OptionsPanel)object).getHelpCtx());
            OptionsPanelListener optionsPanelListener = new OptionsPanelListener(dialogDescriptor, (OptionsPanel)object, this.bOK, this.bClassic, this.btnExport, this.btnImport);
            dialogDescriptor.setButtonListener((ActionListener)optionsPanelListener);
            ((Container)object).addPropertyChangeListener(optionsPanelListener);
            LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
            synchronized (lookupListener) {
                descriptorRef = new WeakReference<DialogDescriptor>(dialogDescriptor);
            }
            log.fine("Create new Options Dialog");
        } else {
            object = (OptionsPanel)dialogDescriptor.getMessage();
            ((OptionsPanel)object).update();
            log.fine("Reopen Options Dialog");
        }
        dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        ((OptionsPanel)object).initCurrentCategory(string, string2);
        dialog.addWindowListener(new MyWindowListener((OptionsPanel)object));
        Point point = this.getUserLocation();
        if (point != null) {
            dialog.setLocation(point);
        }
        dialog.setVisible(true);
    }

    private void updateButtons() {
        if (this.bClassic != null) {
            this.bClassic.setVisible(this.advancedOptionsNotEmpty());
        }
        boolean bl = this.optionsExportNotEmpty();
        if (this.btnExport != null) {
            this.btnExport.setVisible(bl);
        }
        if (this.btnImport != null) {
            this.btnImport.setVisible(bl);
        }
    }

    private boolean advancedOptionsNotEmpty() {
        FileObject fileObject = FileUtil.getConfigFile((String)"UI/Services");
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                Object object = fileObject2.getAttribute("hidden");
                if (object != null && ((Boolean)object).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean optionsExportNotEmpty() {
        FileObject fileObject = FileUtil.getConfigFile((String)"OptionsExport");
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                FileObject[] fileObjectArray2;
                Object object = fileObject2.getAttribute("hidden");
                if (object != null && ((Boolean)object).booleanValue()) continue;
                for (FileObject fileObject3 : fileObjectArray2 = fileObject2.getChildren()) {
                    Object object2 = fileObject3.getAttribute("hidden");
                    if (object2 != null && ((Boolean)object2).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Point getUserLocation() {
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        int n = NbPreferences.forModule(OptionsDisplayerImpl.class).getInt("OptionsX", Integer.MAX_VALUE);
        int n2 = NbPreferences.forModule(OptionsDisplayerImpl.class).getInt("OptionsY", Integer.MAX_VALUE);
        if ((double)n > rectangle.getWidth() || (double)n2 > rectangle.getHeight()) {
            return null;
        }
        return new Point(n, n2);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(OptionsDisplayerImpl.class, (String)string);
    }

    private static Component loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)OptionsDisplayerImpl.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)OptionsDisplayerImpl.loc(string));
        }
        return component;
    }

    static {
        descriptorRef = new WeakReference<Object>(null);
        title = OptionsDisplayerImpl.loc("CTL_Options_Dialog_Title");
        log = Logger.getLogger(OptionsDisplayerImpl.class.getName());
        lookupListener = new LookupListenerImpl();
    }

    private class DefaultFSListener
    implements FileChangeListener {
        private DefaultFSListener() {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileChanged(FileEvent fileEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileDeleted(FileEvent fileEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }
    }

    private static class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
            synchronized (lookupListener) {
                descriptorRef = new WeakReference<Object>(null);
                if (dialog != null) {
                    dialog.setVisible(false);
                    OptionsDisplayerImpl.dialog = null;
                }
            }
        }
    }

    class OpenOptionsListener
    implements ActionListener {
        OpenOptionsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            log.fine("Options Dialog - Back to modern.");
                            OptionsDisplayer.getDefault().open();
                        }
                    });
                }
            });
        }
    }

    private class MyWindowListener
    implements WindowListener {
        private OptionsPanel optionsPanel;
        private Dialog originalDialog;

        MyWindowListener(OptionsPanel optionsPanel) {
            this.optionsPanel = optionsPanel;
            this.originalDialog = dialog;
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (dialog == null) {
                return;
            }
            log.fine("Options Dialog - windowClosing ");
            this.optionsPanel.cancel();
            OptionsDisplayerImpl.this.bOK.setEnabled(true);
            if (this.originalDialog == dialog) {
                OptionsDisplayerImpl.dialog = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosed(WindowEvent windowEvent) {
            this.optionsPanel.storeUserSize();
            NbPreferences.forModule(OptionsDisplayerImpl.class).putInt("OptionsX", this.originalDialog.getX());
            NbPreferences.forModule(OptionsDisplayerImpl.class).putInt("OptionsY", this.originalDialog.getY());
            if (this.optionsPanel.needsReinit()) {
                LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
                synchronized (lookupListener) {
                    descriptorRef = new WeakReference<Object>(null);
                }
            }
            if (this.originalDialog == dialog) {
                OptionsDisplayerImpl.dialog = null;
            }
            log.fine("Options Dialog - windowClosed");
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }
    }

    private class OptionsPanelListener
    implements PropertyChangeListener,
    ActionListener {
        private DialogDescriptor descriptor;
        private OptionsPanel optionsPanel;
        private JButton bOK;
        private JButton bClassic;
        private JButton btnExport;
        private JButton btnImport;

        OptionsPanelListener(DialogDescriptor dialogDescriptor, OptionsPanel optionsPanel, JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4) {
            this.descriptor = dialogDescriptor;
            this.optionsPanel = optionsPanel;
            this.bOK = jButton;
            this.bClassic = jButton2;
            this.btnExport = jButton3;
            this.btnImport = jButton4;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("buranhelpCtx")) {
                this.descriptor.setHelpCtx(this.optionsPanel.getHelpCtx());
            } else if (propertyChangeEvent.getPropertyName().equals("buranvalid")) {
                this.bOK.setEnabled(this.optionsPanel.dataValid());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (!OptionsDisplayerImpl.this.isOpen()) {
                return;
            }
            if (actionEvent.getSource() == this.bOK) {
                log.fine("Options Dialog - Ok pressed.");
                Dialog dialog = dialog;
                OptionsDisplayerImpl.dialog = null;
                this.optionsPanel.save();
                dialog.dispose();
                return;
            }
            if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION || actionEvent.getSource() == DialogDescriptor.CLOSED_OPTION) {
                log.fine("Options Dialog - Cancel pressed.");
                Dialog dialog = dialog;
                OptionsDisplayerImpl.dialog = null;
                this.optionsPanel.cancel();
                this.bOK.setEnabled(true);
                dialog.dispose();
                return;
            }
            if (actionEvent.getSource() == this.bClassic) {
                NotifyDescriptor.Confirmation confirmation;
                log.fine("Options Dialog - Classic pressed.");
                Dialog dialog = dialog;
                OptionsDisplayerImpl.dialog = null;
                if (this.optionsPanel.isChanged()) {
                    confirmation = new NotifyDescriptor.Confirmation((Object)OptionsDisplayerImpl.loc("CTL_Some_values_changed"), 1, 3);
                    Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object == NotifyDescriptor.YES_OPTION) {
                        this.optionsPanel.save();
                        dialog.dispose();
                    } else {
                        if (object != NotifyDescriptor.NO_OPTION) {
                            OptionsDisplayerImpl.dialog = dialog;
                            return;
                        }
                        this.optionsPanel.cancel();
                        dialog.dispose();
                    }
                } else {
                    dialog.dispose();
                    this.optionsPanel.cancel();
                }
                try {
                    confirmation = (CallableSystemAction)SystemAction.get(OptionsAction.class);
                    confirmation.putValue("additionalActionName", (Object)OptionsDisplayerImpl.loc("CTL_Modern"));
                    confirmation.putValue("optionsDialogTitle", (Object)OptionsDisplayerImpl.loc("CTL_Classic_Title"));
                    confirmation.putValue("additionalActionListener", (Object)new OpenOptionsListener());
                    confirmation.performAction();
                    return;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                    return;
                }
            }
            if (actionEvent.getSource() == this.btnExport) {
                OptionsChooserPanel.showExportDialog();
                return;
            }
            if (actionEvent.getSource() != this.btnImport) return;
            OptionsChooserPanel.showImportDialog();
        }
    }
}

