/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Response {
    public static final int NO_TYPE = 0;
    public static final int CODE_REGION_CPU_RESULTS = 1;
    public static final int INSTRUMENT_METHOD_GROUP = 2;
    public static final int INTERNAL_STATS = 3;
    public static final int VM_PROPERTIES = 4;
    public static final int DUMP_RESULTS = 5;
    public static final int OBJECT_ALLOCATION_RESULTS = 6;
    public static final int METHOD_NAMES = 7;
    public static final int THREAD_LIVENESS_STATUS = 8;
    public static final int MONITORED_NUMBERS = 9;
    public static final int DEFINING_LOADER = 10;
    public static final int CALIBRATION_DATA = 11;
    public static final int CLASSID_RESPONSE = 12;
    protected String errorMessage;
    protected boolean yes;
    private int type;

    public Response(boolean bl) {
        this.type = 0;
        this.yes = bl;
    }

    public Response(String string) {
        this.type = 0;
        this.errorMessage = string;
    }

    protected Response(boolean bl, int n) {
        this.yes = bl;
        this.type = n;
    }

    Response() {
        this.type = 0;
    }

    Response(int n) {
        this.type = n;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isOK() {
        return this.errorMessage == null;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        String string = Response.respTypeToString(this.type);
        return string + (this.isOK() ? "Ok, " + (this.yes() ? "yes" : "no") : "Error, " + this.errorMessage);
    }

    public boolean yes() {
        return this.yes;
    }

    void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    void setType(int n) {
        this.type = n;
    }

    void setYes(boolean bl) {
        this.yes = bl;
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException {
    }

    static String respTypeToString(int n) {
        if (n != 0) {
            switch (n) {
                case 1: {
                    return "CODE_REGION_CPU_RESULTS ";
                }
                case 2: {
                    return "INSTRUMENT_METHOD_GROUP ";
                }
                case 3: {
                    return "INTERNAL_STATS";
                }
                case 4: {
                    return "VM_PROPERTIES";
                }
                case 5: {
                    return "DUMP_RESULTS";
                }
                case 6: {
                    return "OBJECT_ALLOCATION_RESULTS";
                }
                case 7: {
                    return "METHOD_NAMES";
                }
                case 8: {
                    return "THREAD_LIVENESS_STATUS";
                }
                case 9: {
                    return "MONITORED_NUMBERS";
                }
                case 10: {
                    return "DEFINING_LOADER";
                }
                case 11: {
                    return "CALIBRATION_DATA";
                }
                case 12: {
                    return "CLASSID_RESPONSE";
                }
            }
            return "Unknown response";
        }
        return "NO TYPE";
    }

    void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

