/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx.impl;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.jmx.EnvironmentProvider;
import com.sun.tools.visualvm.jmx.impl.CredentialsConfigurator;
import com.sun.tools.visualvm.jmx.impl.JmxApplication;
import com.sun.tools.visualvm.tools.attach.AttachModelFactory;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import com.sun.tools.visualvm.tools.jvmstat.JvmstatModel;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.openide.util.RequestProcessor;

class JmxModelImpl
extends JmxModel {
    private static final Logger LOGGER = Logger.getLogger(JmxModelImpl.class.getName());
    private ProxyClient client;
    private ApplicationRemovedListener removedListener;
    private ApplicationAvailabilityListener availabilityListener;

    public JmxModelImpl(Application application, JvmstatModel jvmstat) {
        try {
            JvmJvmstatModel jvmstatModel = JvmJvmstatModelFactory.getJvmstatModelFor((Application)application);
            ProxyClient proxyClient = null;
            if (Application.CURRENT_APPLICATION.equals((Object)application)) {
                proxyClient = new ProxyClient(this);
            } else if (application.isLocalApplication()) {
                String connectorAddress = jvmstat.findByName("sun.management.JMXConnectorServer.address");
                String javaHome = jvmstat.findByName("java.property.java.home");
                LocalVirtualMachine lvm = new LocalVirtualMachine(application.getPid(), AttachModelFactory.getAttachFor((Application)application) != null, connectorAddress, javaHome);
                if (!lvm.isManageable()) {
                    if (lvm.isAttachable()) {
                        proxyClient = new ProxyClient(this, lvm);
                    } else if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("The JMX management agent cannot be enabled in this application (pid " + application.getPid() + ")");
                    }
                } else {
                    proxyClient = new ProxyClient(this, lvm);
                }
            } else {
                List urls = jvmstat.findByPattern("sun.management.JMXConnectorServer.[0-9]+.address");
                if (urls.size() != 0) {
                    List auths = jvmstat.findByPattern("sun.management.JMXConnectorServer.[0-9]+.authenticate");
                    proxyClient = new ProxyClient(this, (String)urls.get(0));
                    if ("true".equals(auths.get(0))) {
                        this.supplyCredentials(application, proxyClient);
                    }
                } else {
                    String jvmArgs = jvmstatModel.getJvmArgs();
                    StringTokenizer st = new StringTokenizer(jvmArgs);
                    int port = -1;
                    boolean authenticate = false;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (token.startsWith("-Dcom.sun.management.jmxremote.port=")) {
                            port = Integer.parseInt(token.substring(token.indexOf("=") + 1));
                            continue;
                        }
                        if (!token.equals("-Dcom.sun.management.jmxremote.authenticate=true")) continue;
                        authenticate = true;
                    }
                    if (port != -1) {
                        proxyClient = new ProxyClient(this, application.getHost(), port);
                        if (authenticate) {
                            this.supplyCredentials(application, proxyClient);
                        }
                    }
                }
            }
            if (proxyClient != null) {
                this.client = proxyClient;
                this.removedListener = new ApplicationRemovedListener();
                this.availabilityListener = new ApplicationAvailabilityListener();
                this.connect(application, proxyClient, this.removedListener, this.availabilityListener);
            }
        }
        catch (Exception e) {
            LOGGER.throwing(JmxModelImpl.class.getName(), "<init>", e);
            this.client = null;
        }
    }

    public JmxModelImpl(JmxApplication application) {
        try {
            ProxyClient proxyClient;
            this.client = proxyClient = new ProxyClient(this, application);
            this.removedListener = new ApplicationRemovedListener();
            this.availabilityListener = new ApplicationAvailabilityListener();
            this.connect(application, proxyClient, this.removedListener, this.availabilityListener);
        }
        catch (Exception e) {
            LOGGER.throwing(JmxModelImpl.class.getName(), "<init>", e);
            this.client = null;
        }
    }

    private void connect(Application application, ProxyClient proxyClient, ApplicationRemovedListener listener, ApplicationAvailabilityListener aListener) {
        while (true) {
            try {
                proxyClient.connect();
                application.notifyWhenRemoved((DataRemovedListener)listener);
                application.addPropertyChangeListener("prop_state", (PropertyChangeListener)aListener);
            }
            catch (SecurityException e) {
                if (this.supplyCredentials(application, proxyClient) != null) continue;
            }
            break;
        }
    }

    private CredentialsConfigurator supplyCredentials(Application application, ProxyClient proxyClient) {
        CredentialsConfigurator jsc;
        String displayName = application.getStorage().getCustomProperty("prop_name");
        if (displayName == null) {
            displayName = proxyClient.getUrl().toString();
        }
        if ((jsc = CredentialsConfigurator.supplyCredentials(displayName)) != null) {
            proxyClient.setCredentials(jsc.getUsername(), jsc.getPassword());
        }
        return jsc;
    }

    public JmxModel.ConnectionState getConnectionState() {
        if (this.client != null) {
            return this.client.getConnectionState();
        }
        return JmxModel.ConnectionState.DISCONNECTED;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        if (this.client != null) {
            return this.client.getMBeanServerConnection();
        }
        return null;
    }

    public JMXServiceURL getJMXServiceURL() {
        if (this.client != null) {
            return this.client.getUrl();
        }
        return null;
    }

    private static class LocalVirtualMachine {
        private int vmid;
        private boolean isAttachSupported;
        private String javaHome;
        private volatile String address;
        private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

        public LocalVirtualMachine(int vmid, boolean canAttach, String connectorAddress, String home) {
            this.vmid = vmid;
            this.address = connectorAddress;
            this.isAttachSupported = canAttach;
            this.javaHome = home;
        }

        public int vmid() {
            return this.vmid;
        }

        public synchronized boolean isManageable() {
            return this.address != null;
        }

        public boolean isAttachable() {
            return this.isAttachSupported;
        }

        public synchronized void startManagementAgent() throws IOException {
            if (this.address != null) {
                return;
            }
            if (!this.isAttachable()) {
                throw new IOException("This virtual machine \"" + this.vmid + "\" does not support dynamic attach.");
            }
            this.loadManagementAgent();
            if (this.address == null) {
                throw new IOException("Fails to find connector address");
            }
        }

        public synchronized String connectorAddress() {
            return this.address;
        }

        private synchronized void loadManagementAgent() throws IOException {
            VirtualMachine vm = null;
            String name = String.valueOf(this.vmid);
            try {
                vm = VirtualMachine.attach(name);
            }
            catch (AttachNotSupportedException x) {
                IOException ioe = new IOException(x.getMessage());
                ioe.initCause(x);
                throw ioe;
            }
            String agent = this.javaHome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
            File f = new File(agent);
            if (!f.exists() && !(f = new File(agent = this.javaHome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                throw new IOException("Management agent not found");
            }
            agent = f.getCanonicalPath();
            try {
                vm.loadAgent(agent, "com.sun.management.jmxremote");
            }
            catch (AgentLoadException x) {
                IOException ioe = new IOException(x.getMessage());
                ioe.initCause(x);
                throw ioe;
            }
            catch (AgentInitializationException x) {
                IOException ioe = new IOException(x.getMessage());
                ioe.initCause(x);
                throw ioe;
            }
            Properties agentProps = vm.getAgentProperties();
            this.address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
            vm.detach();
        }
    }

    private static class CheckerInvocationHandler
    implements InvocationHandler {
        private final MBeanServerConnection conn;

        CheckerInvocationHandler(MBeanServerConnection conn) {
            this.conn = conn;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LOGGER.isLoggable(Level.FINE) && EventQueue.isDispatchThread()) {
                Throwable thrwbl = new Throwable();
                LOGGER.log(Level.FINE, this.createTracedMessage("MBeanServerConnection call performed on Event Dispatch Thread!", thrwbl));
            }
            try {
                return method.invoke((Object)this.conn, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private String createTracedMessage(String message, Throwable thrwbl) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.println(message);
            thrwbl.printStackTrace(pw);
            pw.flush();
            return baos.toString();
        }
    }

    private static class Checker {
        private Checker() {
        }

        public static MBeanServerConnection newChecker(ProxyClient client, MBeanServerConnection mbsc) {
            CheckerInvocationHandler ih = new CheckerInvocationHandler(mbsc);
            return (MBeanServerConnection)Proxy.newProxyInstance(Checker.class.getClassLoader(), new Class[]{MBeanServerConnection.class}, (InvocationHandler)ih);
        }
    }

    private static class ProxyClient
    implements NotificationListener {
        private static final int MODE_SELF = 0;
        private static final int MODE_LOCAL = 1;
        private static final int MODE_GENERIC = 2;
        private final int mode;
        private JmxModel.ConnectionState connectionState = JmxModel.ConnectionState.DISCONNECTED;
        private volatile boolean isDead = true;
        private String userName = null;
        private String password = null;
        private LocalVirtualMachine lvm;
        private JMXServiceURL jmxUrl = null;
        private Application app;
        private EnvironmentProvider envProvider = null;
        private MBeanServerConnection conn = null;
        private JMXConnector jmxc = null;
        private static final SslRMIClientSocketFactory sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
        private final JmxModelImpl model;

        public ProxyClient(JmxModelImpl model) throws IOException {
            this.mode = 0;
            this.model = model;
        }

        public ProxyClient(JmxModelImpl model, LocalVirtualMachine lvm) throws IOException {
            this.mode = 1;
            this.model = model;
            this.lvm = lvm;
        }

        public ProxyClient(JmxModelImpl model, Host host, int port) throws IOException {
            this(model, new JMXServiceURL("rmi", "", 0, ProxyClient.createUrl(host.getHostName(), port)), null, null);
        }

        public ProxyClient(JmxModelImpl model, String url) throws IOException {
            this(model, new JMXServiceURL(url), null, null);
        }

        public ProxyClient(JmxModelImpl model, JmxApplication jmxApp) throws IOException {
            this(model, jmxApp.getJMXServiceURL(), jmxApp, jmxApp.getEnvironmentProvider());
        }

        private ProxyClient(JmxModelImpl model, JMXServiceURL url, Application app, EnvironmentProvider envProvider) throws IOException {
            this.mode = 2;
            this.model = model;
            this.jmxUrl = url;
            this.app = app;
            this.envProvider = envProvider;
        }

        public void setCredentials(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        private static String createUrl(String hostName, int port) {
            return "/jndi/rmi://" + hostName + ":" + port + "/jmxrmi";
        }

        private void setConnectionState(JmxModel.ConnectionState state) {
            JmxModel.ConnectionState oldState = this.connectionState;
            this.connectionState = state;
            this.model.propertyChangeSupport.firePropertyChange("connectionState", oldState, state);
        }

        public JmxModel.ConnectionState getConnectionState() {
            return this.connectionState;
        }

        void connect() {
            block4: {
                this.setConnectionState(JmxModel.ConnectionState.CONNECTING);
                try {
                    this.tryConnect();
                    this.setConnectionState(JmxModel.ConnectionState.CONNECTED);
                }
                catch (SecurityException e) {
                    this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
                    throw e;
                }
                catch (Exception e) {
                    this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
                    if (e.toString().contains("com.sun.enterprise.security.LoginException")) {
                        throw new SecurityException("Authentication failed! Invalid username or password");
                    }
                    if (!LOGGER.isLoggable(Level.INFO)) break block4;
                    String param = this.lvm != null ? String.valueOf(this.lvm.vmid()) : (this.jmxUrl != null ? this.jmxUrl.toString() : "");
                    LOGGER.log(Level.INFO, "connect(" + param + ")", e);
                }
            }
        }

        private void tryConnect() throws IOException {
            if (this.mode == 0) {
                this.jmxc = null;
                this.conn = ManagementFactory.getPlatformMBeanServer();
            } else {
                if (this.mode == 1) {
                    if (!this.lvm.isManageable()) {
                        this.lvm.startManagementAgent();
                        if (!this.lvm.isManageable()) {
                            throw new IOException(this.lvm + " not manageable");
                        }
                    }
                    if (this.jmxUrl == null) {
                        this.jmxUrl = new JMXServiceURL(this.lvm.connectorAddress());
                    }
                }
                HashMap<String, Object> env = new HashMap<String, Object>();
                if (this.envProvider != null) {
                    env.putAll(this.envProvider.getEnvironment(this.app, this.app.getStorage()));
                }
                if (this.userName != null || this.password != null) {
                    env.put("jmx.remote.credentials", new String[]{this.userName, this.password});
                }
                this.jmxc = JMXConnectorFactory.newJMXConnector(this.jmxUrl, env);
                this.jmxc.addConnectionNotificationListener(this, null, null);
                try {
                    this.jmxc.connect(env);
                }
                catch (IOException e) {
                    if ("rmi".equals(this.jmxUrl.getProtocol())) {
                        env.put("com.sun.jndi.rmi.factory.socket", sslRMIClientSocketFactory);
                        this.jmxc.connect(env);
                    }
                    throw e;
                }
                MBeanServerConnection mbsc = this.jmxc.getMBeanServerConnection();
                this.conn = Checker.newChecker(this, mbsc);
            }
            this.isDead = false;
        }

        public MBeanServerConnection getMBeanServerConnection() {
            return this.conn;
        }

        public JMXServiceURL getUrl() {
            return this.jmxUrl;
        }

        public void disconnect() {
            this.disconnectImpl(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void disconnectImpl(boolean sendClose) {
            if (this.jmxc != null) {
                try {
                    if (sendClose) {
                        this.jmxc.close();
                    }
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        this.jmxc.removeConnectionNotificationListener(this);
                    }
                    catch (Exception e) {}
                }
            }
            if (!this.isDead) {
                this.isDead = true;
                this.setConnectionState(JmxModel.ConnectionState.DISCONNECTED);
            }
        }

        public synchronized void markAsDead() {
            this.disconnect();
        }

        public boolean isDead() {
            return this.isDead;
        }

        boolean isConnected() {
            return !this.isDead();
        }

        public void handleNotification(Notification n, Object hb) {
            if (n instanceof JMXConnectionNotification && ("jmx.remote.connection.failed".equals(n.getType()) || "jmx.remote.connection.closed".equals(n.getType()))) {
                this.markAsDead();
            }
        }
    }

    private class ApplicationAvailabilityListener
    implements PropertyChangeListener {
        private ApplicationAvailabilityListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getNewValue().equals(1)) {
                ((Application)evt.getSource()).removePropertyChangeListener("prop_state", (PropertyChangeListener)this);
                JmxModelImpl.this.client.disconnectImpl(false);
                JmxModelImpl.this.availabilityListener = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationRemovedListener
    implements DataRemovedListener<Application> {
        private ApplicationRemovedListener() {
        }

        public void dataRemoved(Application application) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    JmxModelImpl.this.client.markAsDead();
                    JmxModelImpl.this.removedListener = null;
                }
            });
        }
    }
}

