/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.profiler.ApplicationProfilerView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class CPUSettingsSupport {
    private static final String PROP_PREFIX = "ProfilerCPUSettings_";
    private static final String JAR_SUFFIX = ".jar";
    private static final Logger LOGGER = Logger.getLogger(CPUSettingsSupport.class.getName());
    static final String SNAPSHOT_VERSION = "ProfilerCPUSettings_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    public static final String PROP_ROOT_CLASSES = "ProfilerCPUSettings_root_classes";
    public static final String PROP_PROFILE_RUNNABLES = "ProfilerCPUSettings_profile_runnables";
    public static final String PROP_FILTER_TYPE = "ProfilerCPUSettings_filter_type";
    public static final String PROP_FILTER_VALUE = "ProfilerCPUSettings_filter_value";
    private JPanel panel;
    private JLabel rootClassesLabel;
    private TextAreaComponent rootsArea;
    private JCheckBox runnablesCheckBox;
    private JRadioButton inclFilterRadioButton;
    private JRadioButton exclFilterRadioButton;
    private TextAreaComponent filtersArea;
    private JButton resetDefaultsButton;
    private Application application;
    private String defaultRootClasses;
    private String defaultInstrFilter;

    public CPUSettingsSupport(Application application) {
        this.application = application;
        this.initDefaults();
    }

    public DataViewComponent.DetailsView getDetailsView() {
        return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Cpu_settings"), null, 10, (JComponent)new ScrollableContainer((JComponent)this.getPanel()), null);
    }

    public void setUIEnabled(boolean enabled) {
        if (this.panel == null) {
            return;
        }
        this.panel.setEnabled(enabled);
        this.rootClassesLabel.setEnabled(enabled);
        this.rootsArea.setEnabled(enabled);
        this.rootsArea.getTextArea().setEnabled(enabled);
        this.runnablesCheckBox.setEnabled(enabled);
        this.inclFilterRadioButton.setEnabled(enabled);
        this.exclFilterRadioButton.setEnabled(enabled);
        this.filtersArea.getTextArea().setEnabled(enabled);
        this.resetDefaultsButton.setEnabled(enabled);
    }

    public ProfilingSettings getSettings() {
        if (this.panel == null) {
            return null;
        }
        ProfilingSettings settings = ProfilingSettingsPresets.createCPUPreset();
        settings.setInstrScheme(1);
        String instrFilterString = this.getFilterValue();
        SimpleFilter instrFilter = instrFilterString.isEmpty() || "*".equals(instrFilterString) ? SimpleFilter.NO_FILTER : new SimpleFilter(instrFilterString, this.inclFilterRadioButton.isSelected() ? 2 : 1, instrFilterString);
        settings.setSelectedInstrumentationFilter((Object)instrFilter);
        String[] rootValues = this.getRootValue().split(",");
        ClientUtils.SourceCodeSelection[] roots = rootValues.length == 1 && rootValues[0].isEmpty() ? new ClientUtils.SourceCodeSelection[]{} : new ClientUtils.SourceCodeSelection[rootValues.length];
        for (int i = 0; i < roots.length; ++i) {
            roots[i] = new ClientUtils.SourceCodeSelection(rootValues[i], "*", null);
        }
        settings.setInstrumentationRootMethods(roots);
        settings.setInstrumentSpawnedThreads(this.runnablesCheckBox.isSelected());
        return settings;
    }

    public void saveSettings() {
        if (this.application == null) {
            return;
        }
        Storage storage = this.application.getStorage();
        storage.setCustomProperty(SNAPSHOT_VERSION, CURRENT_SNAPSHOT_VERSION);
        storage.setCustomProperty(PROP_ROOT_CLASSES, this.rootsArea.getTextArea().getText());
        storage.setCustomProperty(PROP_PROFILE_RUNNABLES, Boolean.toString(this.runnablesCheckBox.isSelected()));
        storage.setCustomProperty(PROP_FILTER_TYPE, Integer.toString(this.inclFilterRadioButton.isSelected() ? 2 : 1));
        storage.setCustomProperty(PROP_FILTER_VALUE, this.filtersArea.getTextArea().getText());
    }

    private void loadSettings() {
        String filterValue;
        String filterType;
        String profileRunnables;
        if (this.application == null) {
            return;
        }
        Storage storage = this.application.getStorage();
        String rootClasses = storage.getCustomProperty(PROP_ROOT_CLASSES);
        if (rootClasses != null) {
            this.rootsArea.getTextArea().setText(rootClasses);
        }
        if ((profileRunnables = storage.getCustomProperty(PROP_PROFILE_RUNNABLES)) != null) {
            try {
                boolean profileRunnablesBool = Boolean.parseBoolean(profileRunnables);
                this.runnablesCheckBox.setSelected(profileRunnablesBool);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((filterType = storage.getCustomProperty(PROP_FILTER_TYPE)) != null) {
            try {
                int filterTypeInt = Integer.parseInt(filterType);
                if (filterTypeInt == 2) {
                    this.inclFilterRadioButton.setSelected(true);
                } else if (filterTypeInt == 1) {
                    this.exclFilterRadioButton.setSelected(true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((filterValue = storage.getCustomProperty(PROP_FILTER_VALUE)) != null) {
            this.filtersArea.getTextArea().setText(filterValue);
        }
    }

    private void initDefaults() {
        this.defaultRootClasses = "";
        Jvm jvm = JvmFactory.getJVMFor((Application)this.application);
        String mainClass = jvm.getMainClass();
        if (mainClass == null || mainClass.trim().length() == 0) {
            mainClass = "";
        } else if (mainClass.endsWith(JAR_SUFFIX)) {
            File jarFile;
            String args;
            int index;
            String userdir;
            mainClass = "";
            Properties sysProp = jvm.getSystemProperties();
            if (sysProp != null && (userdir = sysProp.getProperty("user.dir")) != null && (index = (args = jvm.getCommandLine()).indexOf(JAR_SUFFIX)) != -1 && (jarFile = new File(userdir, args.substring(0, index + JAR_SUFFIX.length()))).exists()) {
                try {
                    JarFile jf = new JarFile(jarFile);
                    String mainClassName = jf.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                    assert (mainClassName != null);
                    mainClass = mainClassName.replace('\\', '/').replace('/', '.');
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "getMainClass", ex);
                }
            }
        }
        int dotIndex = mainClass.lastIndexOf(SNAPSHOT_VERSION_DIVIDER);
        if (dotIndex != -1) {
            this.defaultRootClasses = mainClass.substring(0, dotIndex + 1) + "**";
        }
        this.defaultInstrFilter = this.defaultRootClasses.isEmpty() ? (Utilities.isMac() ? "sun.*, sunw.*, com.sun.*,\ncom.apple.*, apple.awt.*, apple.laf.*" : "sun.*, sunw.*, com.sun.*") : (Utilities.isMac() ? "java.*, javax.*,\nsun.*, sunw.*, com.sun.*,\ncom.apple.*, apple.awt.*, apple.laf.*" : "java.*, javax.*,\nsun.*, sunw.*, com.sun.*");
    }

    private void setDefaults() {
        this.rootsArea.getTextArea().setText(this.defaultRootClasses);
        this.runnablesCheckBox.setSelected(true);
        this.exclFilterRadioButton.setSelected(true);
        this.filtersArea.getTextArea().setText(this.defaultInstrFilter);
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.createPanel();
            this.setDefaults();
            this.loadSettings();
        }
        return this.panel;
    }

    private void checkRootValidity() {
        this.rootsArea.getTextArea().setForeground(this.isRootValueValid() ? UIManager.getColor("TextArea.foreground") : Color.RED);
    }

    public boolean isRootValueValid() {
        String[] rootParts = FilterUtils.getSeparateFilters((String)this.getRootValue());
        for (int i = 0; i < rootParts.length; ++i) {
            if (FilterUtils.isValidProfilerFilter((String)rootParts[i])) continue;
            if (rootParts[i].endsWith("**")) {
                if (FilterUtils.isValidProfilerFilter((String)rootParts[i].substring(0, rootParts[i].length() - 1))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private String getRootValue() {
        StringBuffer convertedValue = new StringBuffer();
        String[] rootValues = this.getRootsValues();
        for (int i = 0; i < rootValues.length; ++i) {
            String filterValue = rootValues[i].trim();
            if (i != rootValues.length - 1 && !filterValue.endsWith(",")) {
                filterValue = filterValue + ",";
            }
            convertedValue.append(filterValue);
        }
        return convertedValue.toString();
    }

    private String[] getRootsValues() {
        return this.rootsArea.getTextArea().getText().split("\\n");
    }

    private void checkFilterValidity() {
        this.filtersArea.getTextArea().setForeground(this.isFilterValueValid() ? UIManager.getColor("TextArea.foreground") : Color.RED);
    }

    public boolean isFilterValueValid() {
        String[] filterParts = FilterUtils.getSeparateFilters((String)this.getFilterValue());
        for (int i = 0; i < filterParts.length; ++i) {
            if (FilterUtils.isValidProfilerFilter((String)filterParts[i])) continue;
            return false;
        }
        return true;
    }

    private String getFilterValue() {
        StringBuffer convertedValue = new StringBuffer();
        String[] filterValues = this.getFilterValues();
        for (int i = 0; i < filterValues.length; ++i) {
            String filterValue = filterValues[i].trim();
            if (i != filterValues.length - 1 && !filterValue.endsWith(",")) {
                filterValue = filterValue + ", ";
            }
            convertedValue.append(filterValue);
        }
        return convertedValue.toString();
    }

    private String[] getFilterValues() {
        return this.filtersArea.getTextArea().getText().split("\\n");
    }

    private JPanel createPanel() {
        JPanel panelImpl = new JPanel();
        panelImpl.setLayout(new GridBagLayout());
        panelImpl.setOpaque(false);
        ButtonGroup filterRadiosGroup = new ButtonGroup();
        this.rootClassesLabel = new JLabel(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Root_Classes"));
        this.rootClassesLabel.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Root_Classes"));
        this.rootClassesLabel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        panelImpl.add((Component)this.rootClassesLabel, constraints);
        this.rootsArea = CPUSettingsSupport.createTextArea(3);
        this.rootsArea.getTextArea().setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Root_Classes"));
        this.rootsArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CPUSettingsSupport.this.checkRootValidity();
            }

            public void removeUpdate(DocumentEvent e) {
                CPUSettingsSupport.this.checkRootValidity();
            }

            public void changedUpdate(DocumentEvent e) {
                CPUSettingsSupport.this.checkRootValidity();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.65;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 7, 10);
        panelImpl.add((Component)this.rootsArea, constraints);
        this.runnablesCheckBox = new JCheckBox(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profile_Runnables"));
        this.runnablesCheckBox.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_New_Runnables"));
        this.runnablesCheckBox.setOpaque(false);
        this.runnablesCheckBox.setBorder(this.rootClassesLabel.getBorder());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 10, 10, 10);
        panelImpl.add((Component)this.runnablesCheckBox, constraints);
        this.inclFilterRadioButton = new JRadioButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profile_Incl"));
        this.inclFilterRadioButton.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Inclusive_Filter"));
        this.inclFilterRadioButton.setOpaque(false);
        this.inclFilterRadioButton.setBorder(this.rootClassesLabel.getBorder());
        filterRadiosGroup.add(this.inclFilterRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 5, 5);
        panelImpl.add((Component)this.inclFilterRadioButton, constraints);
        this.exclFilterRadioButton = new JRadioButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profile_Excl"));
        this.exclFilterRadioButton.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Exclusive_Filter"));
        this.exclFilterRadioButton.setOpaque(false);
        this.exclFilterRadioButton.setBorder(this.rootClassesLabel.getBorder());
        filterRadiosGroup.add(this.exclFilterRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 10);
        panelImpl.add((Component)this.exclFilterRadioButton, constraints);
        this.filtersArea = CPUSettingsSupport.createTextArea(2);
        this.filtersArea.getTextArea().setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Instrumentation_Filter"));
        this.filtersArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CPUSettingsSupport.this.checkFilterValidity();
            }

            public void removeUpdate(DocumentEvent e) {
                CPUSettingsSupport.this.checkFilterValidity();
            }

            public void changedUpdate(DocumentEvent e) {
                CPUSettingsSupport.this.checkFilterValidity();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weighty = 0.35;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 10, 10);
        panelImpl.add((Component)this.filtersArea, constraints);
        this.resetDefaultsButton = new JButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Restore_Defaults")){

            protected void fireActionPerformed(ActionEvent event) {
                CPUSettingsSupport.this.setDefaults();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 10);
        panelImpl.add((Component)this.resetDefaultsButton, constraints);
        return panelImpl;
    }

    private static TextAreaComponent createTextArea(int rows) {
        JTextArea rootsArea = new JTextArea();
        rootsArea.setFont(new Font("Monospaced", 0, UIManager.getFont("Label.font").getSize()));
        TextAreaComponent rootsAreaScrollPane = new TextAreaComponent(rootsArea, 20, 30){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        rootsAreaScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JTextArea referenceArea = new JTextArea("X");
        referenceArea.setFont(rootsArea.getFont());
        referenceArea.setRows(rows);
        Insets insets = rootsAreaScrollPane.getInsets();
        rootsAreaScrollPane.setPreferredSize(new Dimension(1, referenceArea.getPreferredSize().height + (insets != null ? insets.top + insets.bottom : 0)));
        return rootsAreaScrollPane;
    }

    private static class TextAreaComponent
    extends JScrollPane {
        public TextAreaComponent(JTextArea textArea, int vPolicy, int hPolicy) {
            super(textArea, vPolicy, hPolicy);
        }

        public JTextArea getTextArea() {
            return (JTextArea)this.getViewport().getView();
        }
    }
}

