/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.ui.actions.ActionUtils;
import com.sun.tools.visualvm.core.ui.actions.SingleDataSourceAction;
import com.sun.tools.visualvm.profiler.ProfilerSupport;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProfileApplicationAction
extends SingleDataSourceAction<Application> {
    private Application lastSelectedApplication;
    private final PropertyChangeListener stateListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            ProfileApplicationAction.this.updateState(ActionUtils.getSelectedDataSources(Application.class));
        }
    };
    private static ProfileApplicationAction instance;

    public static synchronized ProfileApplicationAction instance() {
        if (instance == null) {
            instance = new ProfileApplicationAction();
        }
        return instance;
    }

    protected void actionPerformed(Application application, ActionEvent actionEvent) {
        ProfilerSupport.getInstance().selectProfilerView(application);
    }

    protected boolean isEnabled(Application application) {
        this.lastSelectedApplication = application;
        this.lastSelectedApplication.addPropertyChangeListener("prop_state", this.stateListener);
        if (application.getState() != 1) {
            return false;
        }
        return ProfilerSupport.getInstance().supportsProfiling(application);
    }

    protected void updateState(Set<Application> applications) {
        if (this.lastSelectedApplication != null) {
            this.lastSelectedApplication.removePropertyChangeListener("prop_state", this.stateListener);
            this.lastSelectedApplication = null;
        }
        super.updateState(applications);
    }

    protected void initialize() {
        if (ProfilerSupport.getInstance().isInitialized()) {
            super.initialize();
        } else {
            this.setEnabled(false);
        }
    }

    private ProfileApplicationAction() {
        super(Application.class);
        this.putValue("Name", NbBundle.getMessage(ProfileApplicationAction.class, (String)"MSG_Profile"));
        this.putValue("ShortDescription", NbBundle.getMessage(ProfileApplicationAction.class, (String)"DESCR_Profile"));
    }
}

