/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public abstract class CallingFormat {
    protected static CallingFormat pathCallingFormat = new PathCallingFormat();
    protected static CallingFormat subdomainCallingFormat = new SubdomainCallingFormat();
    protected static CallingFormat vanityCallingFormat = new VanityCallingFormat();

    public abstract boolean supportsLocatedBuckets();

    public abstract String getEndpoint(String var1, int var2, String var3);

    public abstract String getPathBase(String var1, String var2);

    public abstract URL getURL(boolean var1, String var2, int var3, String var4, String var5, Map var6) throws MalformedURLException;

    public static CallingFormat getPathCallingFormat() {
        return pathCallingFormat;
    }

    public static CallingFormat getSubdomainCallingFormat() {
        return subdomainCallingFormat;
    }

    public static CallingFormat getVanityCallingFormat() {
        return vanityCallingFormat;
    }

    private static class VanityCallingFormat
    extends SubdomainCallingFormat {
        private VanityCallingFormat() {
        }

        public String getServer(String server, String bucket) {
            return bucket;
        }
    }

    private static class SubdomainCallingFormat
    extends CallingFormat {
        private SubdomainCallingFormat() {
        }

        public boolean supportsLocatedBuckets() {
            return true;
        }

        public String getServer(String server, String bucket) {
            return bucket + "." + server;
        }

        public String getEndpoint(String server, int port, String bucket) {
            return this.getServer(server, bucket) + ":" + port;
        }

        public String getPathBase(String bucket, String key) {
            return "/" + key;
        }

        public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map pathArgs) throws MalformedURLException {
            if (bucket == null || bucket.length() == 0) {
                String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
                return new URL(isSecure ? "https" : "http", server, port, "/" + pathArguments);
            }
            String serverToUse = this.getServer(server, bucket);
            String pathBase = this.getPathBase(bucket, key);
            String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
            return new URL(isSecure ? "https" : "http", serverToUse, port, pathBase + pathArguments);
        }
    }

    private static class PathCallingFormat
    extends CallingFormat {
        private PathCallingFormat() {
        }

        public boolean supportsLocatedBuckets() {
            return false;
        }

        public String getPathBase(String bucket, String key) {
            return this.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
        }

        public String getEndpoint(String server, int port, String bucket) {
            return server + ":" + port;
        }

        public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map pathArgs) throws MalformedURLException {
            String pathBase = this.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
            String pathArguments = Utils.convertPathArgsHashToString(pathArgs);
            return new URL(isSecure ? "https" : "http", server, port, pathBase + pathArguments);
        }

        private boolean isBucketSpecified(String bucket) {
            if (bucket == null) {
                return false;
            }
            return bucket.length() != 0;
        }
    }
}

