/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ant;

import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.util.AntUtils;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class CompilerTask
extends Task {
    private File projectRoot;
    private Project agProject;
    private String classpath;
    private boolean projectRootRequired = false;
    private boolean verbose = false;
    private DesignServiceManager designServiceManager = null;

    protected CompilerTask() {
        this(false);
    }

    protected CompilerTask(boolean init) {
        if (init) {
            AntUtils.bootstrap(this.getClass().getClassLoader());
        }
    }

    public void setClassPath(String s) {
        this.classpath = s;
    }

    public File getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(File projectRoot) {
        this.projectRoot = projectRoot;
        this.agProject = new Project(projectRoot);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public Project getAGProject() {
        return this.agProject;
    }

    protected synchronized DesignServiceManager getDesignServiceManager() {
        if (this.designServiceManager == null && this.projectRoot != null) {
            this.designServiceManager = DesignTimeUtils.getDSMForProjectRoot(this.projectRoot);
        }
        return this.designServiceManager;
    }

    protected void setProjectRootRequired(boolean projectRootRequired) {
        this.projectRootRequired = projectRootRequired;
    }

    public final void execute() {
        this.validate();
        ClassLoaderUtils.TaskNoRtn task = new ClassLoaderUtils.TaskNoRtn(){

            public void run() {
                CompilerTask.this.doExecute();
            }
        };
        ClassLoaderUtils.runInClassLoaderContext((ClassLoaderUtils.TaskType)task, (ClassLoader)this.getClassLoader());
    }

    protected abstract void doExecute();

    protected void validate() {
        if (this.projectRootRequired) {
            if (this.projectRoot == null) {
                throw new BuildException("projectRoot must be set");
            }
            if (!this.projectRoot.exists()) {
                throw new BuildException("projectRoot: " + this.projectRoot + "doesn't exist");
            }
            if (!this.projectRoot.isDirectory()) {
                throw new BuildException("projectRoot: " + this.projectRoot + "is not a directory");
            }
        }
    }

    protected void debug(String s) {
        this.log(s, 4);
    }

    private ClassLoader getClassLoader() {
        if (this.classpath == null) {
            return this.getClass().getClassLoader();
        }
        ClassLoader parent = ClassLoaderUtils.getClassLoader();
        if (this.getClass().getClassLoader().getClass().getName().endsWith("AntClassLoader")) {
            parent = this.getClass().getClassLoader();
        }
        return ClassLoaderUtils.getClassLoaderForFile((ClassLoader)parent, (File[])new File[]{new File(this.classpath)});
    }
}

