/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ant;

import com.wavemaker.tools.ant.AbstractServiceCompilerTask;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.service.ConfigurationCompiler;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.service.definitions.ServiceComparator;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;

public class ConfigurationCompilerTask
extends AbstractServiceCompilerTask {
    private File destWebAppRoot;
    private File destServicesDir;

    public ConfigurationCompilerTask() {
        super(true);
    }

    public File getDestWebAppRoot() {
        return this.destWebAppRoot;
    }

    public void setDestWebAppRoot(File destWebAppRoot) {
        this.destWebAppRoot = destWebAppRoot;
    }

    public File getDestServicesDir() {
        return this.destServicesDir;
    }

    public void setDestServicesDir(File destServicesDir) {
        this.destServicesDir = destServicesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() throws BuildException {
        File destination;
        Project fileService = null;
        if (null != this.getDestWebAppRoot()) {
            destination = this.getDestWebAppRoot();
        } else if (null != this.getAGProject()) {
            Project p = this.getAGProject();
            destination = p.getWebAppRoot();
            fileService = p;
        } else {
            throw new BuildException("one of destWebAppRoot or projectRoot must be set");
        }
        if (null == fileService) {
            System.out.println("using " + destination + " as a default project directory; please set projectRoot");
            fileService = new Project(destination);
        }
        boolean doXmlBuild = false;
        TreeSet<Service> doBuildServices = new TreeSet<Service>(new ServiceComparator());
        TreeSet<Service> allServices = new TreeSet<Service>(new ServiceComparator());
        HashMap<Service, Long> serviceToMtime = new HashMap<Service, Long>();
        Iterator it = this.getUnion().iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            try {
                Service service;
                InputStream is = resource.getInputStream();
                try {
                    service = DesignServiceManager.loadServiceDefinition(is);
                }
                finally {
                    is.close();
                }
                if (this.getVerbose()) {
                    System.out.println("checking service " + service.getId());
                }
                serviceToMtime.put(service, resource.getLastModified());
                allServices.add(service);
            }
            catch (JAXBException e) {
                throw new BuildException(e);
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
        }
        File webInf = new File(destination, "WEB-INF");
        File servicesXml = new File(webInf, "project-services.xml");
        File managersXml = new File(webInf, "project-managers.xml");
        File typesJs = new File(destination, "types.js");
        File servicesDir = null != this.getDestServicesDir() ? this.getDestServicesDir() : new File(destination, "services");
        if (!(servicesXml.exists() && managersXml.exists() && typesJs.exists())) {
            doXmlBuild = true;
        }
        for (Map.Entry entry : serviceToMtime.entrySet()) {
            Service service = (Service)entry.getKey();
            long mtime = (Long)entry.getValue();
            File smdFile = ConfigurationCompiler.getSmdFile(servicesDir, service.getId());
            if (smdFile.exists() && smdFile.lastModified() >= mtime) continue;
            doBuildServices.add(service);
            doXmlBuild = true;
        }
        try {
            if (doXmlBuild) {
                ConfigurationCompiler.generateServices(fileService, servicesXml, allServices);
                ConfigurationCompiler.generateManagers(fileService, managersXml, allServices);
                System.out.println("Regenerated spring configuration for " + allServices.size() + " services");
            }
            if (0 < doBuildServices.size()) {
                ConfigurationCompiler.generateSMDs(fileService, servicesDir, doBuildServices);
                System.out.println("Configured " + doBuildServices.size() + " services");
            }
            if (doXmlBuild || 0 < doBuildServices.size()) {
                DesignServiceManager dsm = DesignTimeUtils.getDSMForProjectRoot(fileService.getFileServiceRoot());
                ConfigurationCompiler.generateTypes(fileService, typesJs, allServices, dsm.getPrimitiveDataObjects());
                System.out.println("Regenerated types & services information");
            }
        }
        catch (JAXBException ex) {
            throw new BuildException(ex);
        }
        catch (IOException ex) {
            throw new BuildException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new BuildException(ex);
        }
    }
}

