/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ant;

import com.wavemaker.common.util.IOUtils;
import com.wavemaker.tools.project.Project;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.ClasspathUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyRuntimeJarsTask
extends Task {
    public static final String RUNTIME_JAR_NAME = "wmruntime.jar";
    public static final String CLASSPATH_ATTR_NAME = "Class-Path";
    public static final String TASK_NAME = "copyRuntimeJarsTask";
    private File todir = null;
    private File from = null;
    private boolean preserveLastModified = false;
    private boolean overwrite = false;
    private boolean verbose = false;
    private ClasspathUtils.Delegate cpDelegate;
    private Project wmProject;

    protected List<File> getModuleLocations(ClassLoader cl) throws IOException {
        Resource[] resources;
        ArrayList<File> ret = new ArrayList<File>();
        PathMatchingResourcePatternResolver searcher = new PathMatchingResourcePatternResolver(cl);
        for (Resource resource : resources = searcher.getResources("classpath*:/module-configuration.xml")) {
            URL url = resource.getURL();
            if (ResourceUtils.isJarURL((URL)url)) {
                URL jarURL = ResourceUtils.extractJarFileURL((URL)url);
                ret.add(ResourceUtils.getFile((URL)jarURL));
                continue;
            }
            ret.add(ResourceUtils.getFile((URL)url).getParentFile());
        }
        return ret;
    }

    protected List<String> getReferencedClassPathJars(File jarFile, boolean failOnError) {
        try {
            JarFile runtimeJar = new JarFile(jarFile);
            Manifest manifest = runtimeJar.getManifest();
            String jarClassPath = manifest.getMainAttributes().getValue(CLASSPATH_ATTR_NAME);
            if (failOnError && null == jarClassPath) {
                throw new IllegalStateException("Class-Path attribute is missing from " + jarFile);
            }
            if (null == jarClassPath) {
                return new ArrayList<String>();
            }
            String[] tokens = jarClassPath.split("\\s");
            ArrayList<String> jarNames = new ArrayList<String>(tokens.length + 1);
            jarNames.add(RUNTIME_JAR_NAME);
            for (String jarName : jarClassPath.split("\\s")) {
                jarNames.add(jarName);
            }
            return jarNames;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected FileSet getProjectJarFileSet() {
        FileSet projectJarSet = new FileSet();
        projectJarSet.setProject(this.getProject());
        projectJarSet.setDir(this.wmProject.getProjectRoot());
        projectJarSet.createInclude().setName("lib/**/*.jar");
        File includeList = new File(this.wmProject.getWebAppRoot(), "resources/.includeJars");
        if (includeList.exists()) {
            try {
                String s = IOUtils.read((File)includeList);
                String[] filePaths = s.split("\n");
                for (int i = 0; i < filePaths.length; ++i) {
                    projectJarSet.createInclude().setName("webapproot/resources/" + filePaths[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return projectJarSet;
    }

    protected List<String> copyModules() throws IOException {
        ArrayList<String> moduleJarNames = new ArrayList<String>();
        List<File> mm = this.getModuleLocations(this.getClassLoader());
        Copy copyJars = new Copy();
        copyJars.setProject(this.getProject());
        copyJars.setPreserveLastModified(false);
        copyJars.setTaskName(TASK_NAME);
        copyJars.setFlatten(true);
        copyJars.setVerbose(this.verbose);
        copyJars.setTodir(this.wmProject.getWebInfLib());
        FileList jarsFileList = new FileList();
        for (File file : mm) {
            if (file.isDirectory()) {
                Copy copyDirs = new Copy();
                copyDirs.setProject(this.getProject());
                copyDirs.setTaskName("copymodules-dir");
                copyDirs.setFlatten(false);
                copyDirs.setTodir(new File(this.wmProject.getWebInfClasses(), file.getName()));
                FileSet dirsFileSet = new FileSet();
                dirsFileSet.setDir(file);
                copyDirs.add(dirsFileSet);
                copyDirs.execute();
                continue;
            }
            FileList.FileName fileName = new FileList.FileName();
            fileName.setName(file.getAbsolutePath());
            jarsFileList.addConfiguredFile(fileName);
            moduleJarNames.add(file.getName());
            List<String> referencedJars = this.getReferencedClassPathJars(file, false);
            for (String ref : referencedJars) {
                File refFile = new File(file.getParentFile(), ref);
                FileList.FileName refFileName = new FileList.FileName();
                refFileName.setName(refFile.getAbsolutePath());
                jarsFileList.addConfiguredFile(refFileName);
                moduleJarNames.add(ref);
            }
        }
        copyJars.add(jarsFileList);
        copyJars.perform();
        return moduleJarNames;
    }

    @Override
    public void execute() {
        List<String> moduleJars;
        if (null == this.todir) {
            throw new IllegalArgumentException("todir is not set");
        }
        if (null == this.from) {
            throw new IllegalArgumentException("from is not set");
        }
        if (!this.todir.exists()) {
            throw new IllegalArgumentException(this.todir + " does not exist");
        }
        if (!this.from.exists()) {
            throw new IllegalArgumentException(this.from + " does not exist");
        }
        File runtimeJarFile = new File(this.from, RUNTIME_JAR_NAME);
        if (!runtimeJarFile.exists()) {
            throw new IllegalStateException(runtimeJarFile + " does not exist");
        }
        List<String> runtimeJarNames = this.getReferencedClassPathJars(runtimeJarFile, true);
        FileSet projectJars = this.getProjectJarFileSet();
        try {
            moduleJars = this.copyModules();
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        Delete deleteTask = new Delete();
        deleteTask.setProject(this.getProject());
        deleteTask.setTaskName(TASK_NAME);
        deleteTask.setVerbose(this.isVerbose());
        FileSet deleteFileSet = new FileSet();
        deleteFileSet.setProject(this.getProject());
        deleteFileSet.setDir(this.todir);
        deleteFileSet.createInclude().setName("*.jar");
        for (String runtimeJarName : runtimeJarNames) {
            deleteFileSet.createExclude().setName(runtimeJarName);
        }
        for (String projectJarName : projectJars.getDirectoryScanner().getIncludedFiles()) {
            String trimmedJarName = projectJarName.substring("lib".length() + 1);
            deleteFileSet.createExclude().setName(trimmedJarName);
        }
        for (String moduleJarName : moduleJars) {
            deleteFileSet.createExclude().setName(moduleJarName);
        }
        deleteTask.add(deleteFileSet);
        deleteTask.perform();
        Copy copyTask = new Copy();
        copyTask.setProject(this.getProject());
        copyTask.setPreserveLastModified(this.isPreserveLastModified());
        copyTask.setTaskName(TASK_NAME);
        copyTask.setOverwrite(this.isOverwrite());
        copyTask.setVerbose(this.isVerbose());
        copyTask.setFlatten(true);
        copyTask.setTodir(this.todir);
        if (!this.todir.equals(this.from)) {
            FileSet sourceRuntimeFileSet = new FileSet();
            sourceRuntimeFileSet.setDir(this.from);
            for (String runtimeJarName : runtimeJarNames) {
                sourceRuntimeFileSet.createInclude().setName(runtimeJarName);
            }
            copyTask.add(sourceRuntimeFileSet);
        }
        copyTask.add(projectJars);
        copyTask.perform();
    }

    protected ClasspathUtils.Delegate getDelegate() {
        if (null == this.cpDelegate) {
            this.cpDelegate = ClasspathUtils.getDelegate(this);
        }
        return this.cpDelegate;
    }

    protected ClassLoader getClassLoader() {
        return this.cpDelegate.getClassLoader();
    }

    public void setClasspathRef(Reference r) {
        this.getDelegate().setClasspathref(r);
    }

    public void setProjectRoot(File projectRoot) {
        this.wmProject = new Project(projectRoot);
    }

    public File getTodir() {
        return this.todir;
    }

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public File getFrom() {
        return this.from;
    }

    public void setFrom(File from) {
        this.from = from;
    }

    public boolean isPreserveLastModified() {
        return this.preserveLastModified;
    }

    public void setPreserveLastModified(boolean preserveLastModified) {
        this.preserveLastModified = preserveLastModified;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

