/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ant;

import com.wavemaker.tools.ant.CompilerTask;
import com.wavemaker.tools.service.ServiceClassGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceCompilerTask
extends CompilerTask {
    private File destDir = null;

    public ServiceCompilerTask() {
        super(true);
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    private List<File> getServiceFiles(File srcDir) {
        ArrayList<File> rtn = new ArrayList<File>();
        if (srcDir != null && srcDir.exists()) {
            for (String s : srcDir.list()) {
                File f = new File(srcDir, s);
                if (f.isDirectory() || f.getName().endsWith(".properties")) continue;
                rtn.add(f);
            }
        }
        return rtn;
    }

    @Override
    protected void doExecute() {
        for (String serviceId : this.getDesignServiceManager().getServiceIds()) {
            File srcDir = this.getDesignServiceManager().getServiceRuntimeDirectory(serviceId);
            if (srcDir == null) {
                throw new BuildException("Could not locate service home for " + serviceId);
            }
            ServiceClassGenerator generator = new ServiceClassGenerator();
            generator.addService(this.getServiceFiles(srcDir), serviceId);
            if (this.destDir == null) {
                generator.setOutputDirectory(srcDir);
            } else {
                generator.setOutputDirectory(this.destDir);
            }
            generator.setDesignServiceManager(this.getDesignServiceManager());
            generator.run();
        }
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.destDir != null) {
            if (this.destDir.exists()) {
                if (!this.destDir.isDirectory()) {
                    throw new BuildException("destdir must be a directory");
                }
            } else {
                this.destDir.mkdirs();
            }
        }
    }
}

