/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.ant;

import com.wavemaker.tools.ant.CompilerTask;
import com.wavemaker.tools.javaservice.JavaServiceDefinition;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.util.DesignTimeUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;

public class ServiceDefCompilerTask
extends CompilerTask {
    private final List<NestedService> nestedServices;
    private File classesDir = null;

    public ServiceDefCompilerTask() {
        this(true);
    }

    public ServiceDefCompilerTask(boolean init) {
        super(init);
        this.setProjectRootRequired(true);
        this.nestedServices = new ArrayList<NestedService>();
    }

    public void addService(NestedService service) {
        this.nestedServices.add(service);
    }

    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }

    protected void doExecute() {
        DesignServiceManager dsm = DesignTimeUtils.getDSMForProjectRoot(this.getProjectRoot());
        for (NestedService ns : this.nestedServices) {
            JavaServiceDefinition serviceDef;
            String serviceId = ns.getServiceId();
            String fqClassName = ns.getServiceClass(dsm);
            File serviceDefXml = dsm.getServiceDefXml(serviceId);
            boolean reGen = true;
            File serviceSrc = dsm.getServiceRuntimeDirectory(serviceId);
            File serviceSrcFile = new File(serviceSrc, fqClassName.replace('.', '/') + ".java");
            if (serviceSrcFile.exists() && serviceDefXml.exists() && serviceSrcFile.lastModified() <= serviceDefXml.lastModified()) {
                reGen = false;
            }
            if (!reGen) continue;
            System.out.println("creating servicedef for service " + serviceId);
            try {
                if (null == this.classesDir) {
                    this.classesDir = dsm.getProjectManager().getCurrentProject().getWebInfClasses();
                }
                serviceDef = new JavaServiceDefinition(fqClassName, serviceId, this.classesDir, dsm.getProjectManager().getCurrentProject().getWebInfLib(), dsm.getExcludeTypeNames(serviceId));
            }
            catch (ClassNotFoundException e) {
                throw new BuildException(e);
            }
            catch (LinkageError e) {
                throw new BuildException(e);
            }
            dsm.defineService(serviceDef);
        }
    }

    public static class NestedService {
        private String serviceId;
        private String serviceClass = null;

        public NestedService() {
        }

        public NestedService(String serviceId) {
            this();
            this.serviceId = serviceId;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public void setServiceClass(String serviceClass) {
            this.serviceClass = serviceClass;
        }

        public String getServiceClass(DesignServiceManager dsm) {
            String ret = null;
            File serviceDefXml = dsm.getServiceDefXml(this.serviceId);
            File serviceSrc = dsm.getServiceRuntimeDirectory(this.serviceId);
            if (null != this.serviceClass) {
                ret = this.serviceClass;
            } else if (serviceDefXml.exists()) {
                Service sTemp = dsm.getService(this.serviceId);
                ret = sTemp.getClazz();
            } else {
                Collection files = FileUtils.listFiles((File)serviceSrc, (String[])new String[]{"java"}, (boolean)true);
                if (1 != files.size()) {
                    throw new BuildException("Couldn't determine class for service; create a servicedef: " + files);
                }
                for (Object o : files) {
                    File cF = (File)o;
                    ret = JavaServiceDefinition.getFQClassFromFile(cF, dsm.getServiceRuntimeDirectory(this.serviceId));
                }
            }
            return ret;
        }
    }
}

