/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.amazon;

import com.amazonaws.ec2.AmazonEC2;
import com.amazonaws.ec2.AmazonEC2Client;
import com.amazonaws.ec2.AmazonEC2Config;
import com.amazonaws.ec2.AmazonEC2Exception;
import com.amazonaws.ec2.model.DescribeImagesRequest;
import com.amazonaws.ec2.model.DescribeImagesResponse;
import com.amazonaws.ec2.model.DescribeImagesResult;
import com.amazonaws.ec2.model.DescribeInstancesRequest;
import com.amazonaws.ec2.model.DescribeInstancesResponse;
import com.amazonaws.ec2.model.DescribeInstancesResult;
import com.amazonaws.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.ec2.model.DescribeKeyPairsResponse;
import com.amazonaws.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.ec2.model.DescribeSecurityGroupsResponse;
import com.amazonaws.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.ec2.model.Image;
import com.amazonaws.ec2.model.InstanceState;
import com.amazonaws.ec2.model.KeyPair;
import com.amazonaws.ec2.model.Placement;
import com.amazonaws.ec2.model.Reservation;
import com.amazonaws.ec2.model.RunInstancesRequest;
import com.amazonaws.ec2.model.RunInstancesResponse;
import com.amazonaws.ec2.model.RunInstancesResult;
import com.amazonaws.ec2.model.RunningInstance;
import com.amazonaws.ec2.model.SecurityGroup;
import com.amazonaws.ec2.model.TerminateInstancesRequest;
import com.amazonaws.ec2.model.TerminateInstancesResponse;
import com.amazonaws.ec2.model.TerminateInstancesResult;
import com.amazonaws.ec2.model.TerminatingInstance;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.cloudmgr.CloudAuth;
import com.wavemaker.tools.cloudmgr.CloudFlavor;
import com.wavemaker.tools.cloudmgr.CloudImage;
import com.wavemaker.tools.cloudmgr.CloudKeyPair;
import com.wavemaker.tools.cloudmgr.CloudNetwork;
import com.wavemaker.tools.cloudmgr.CloudSecurityGroup;
import com.wavemaker.tools.cloudmgr.CloudServer;
import com.wavemaker.tools.cloudmgr.CloudServerMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonEC2ServerMgr
implements CloudServerMgr {
    private AmazonEC2 service = null;
    private String accessKeyId = null;
    private String secretAccessKey = null;
    private String serviceURL = null;
    private String signatureVersion = null;

    @Override
    public Collection<CloudServer> getServerList(String ec2AMI, CloudAuth auth) {
        TreeMap<String, CloudServer> tm = new TreeMap<String, CloudServer>();
        String instId = "";
        String ami = "";
        String host = "";
        String sTime = "";
        String key = "";
        int stateCode = 0;
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getSeceretAccessKey();
        String ec2SignatureVersion = auth.getEC2SignatureVersion();
        String ec2ServiceURL = auth.getEC2ServiceURL();
        try {
            if (!this.loggedIn(auth)) {
                AmazonEC2Config config = new AmazonEC2Config();
                config.setSignatureVersion(ec2SignatureVersion);
                config.setServiceURL(ec2ServiceURL);
                this.service = new AmazonEC2Client(awsAccessKeyId, awsSecretAccessKey, config);
                this.accessKeyId = awsAccessKeyId;
                this.secretAccessKey = awsSecretAccessKey;
                this.serviceURL = ec2ServiceURL;
                this.signatureVersion = ec2SignatureVersion;
            }
            DescribeInstancesRequest request = new DescribeInstancesRequest();
            DescribeInstancesResponse response = this.service.describeInstances(request);
            DescribeInstancesResult describeInstancesResult = response.getDescribeInstancesResult();
            List reservationList = describeInstancesResult.getReservation();
            for (Reservation reservation : reservationList) {
                List runningInstanceList = reservation.getRunningInstance();
                for (RunningInstance runningInstance : runningInstanceList) {
                    InstanceState instanceState;
                    if (runningInstance.isSetInstanceId()) {
                        instId = runningInstance.getInstanceId();
                    }
                    if (runningInstance.isSetImageId()) {
                        ami = runningInstance.getImageId();
                        if (ec2AMI != null && !ami.equals(ec2AMI)) continue;
                    }
                    if (runningInstance.isSetInstanceState() && (instanceState = runningInstance.getInstanceState()).isSetCode() && (stateCode = instanceState.getCode()) != 16) continue;
                    if (runningInstance.isSetPublicDnsName()) {
                        host = runningInstance.getPublicDnsName();
                    }
                    if (runningInstance.isSetLaunchTime()) {
                        sTime = runningInstance.getLaunchTime();
                    }
                    key = sTime + " | " + instId;
                    CloudServer cs = new CloudServer(null, null, instId, ami, null, null, host, null, null, sTime);
                    tm.put(key, cs);
                }
            }
        }
        catch (AmazonEC2Exception ex) {
            throw new WMRuntimeException(ex.getMessage());
        }
        return new ArrayList<CloudServer>(tm.values());
    }

    @Override
    public Collection<CloudServer> deleteServer(String ec2InstanceId, CloudAuth auth) {
        ArrayList<String> id = new ArrayList<String>();
        id.add(ec2InstanceId);
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getSeceretAccessKey();
        String ec2SignatureVersion = auth.getEC2SignatureVersion();
        String ec2ServiceURL = auth.getEC2ServiceURL();
        try {
            TerminateInstancesRequest request;
            TerminateInstancesResponse response;
            if (!this.loggedIn(auth)) {
                AmazonEC2Config config = new AmazonEC2Config();
                config.setSignatureVersion(ec2SignatureVersion);
                config.setServiceURL(ec2ServiceURL);
                this.service = new AmazonEC2Client(awsAccessKeyId, awsSecretAccessKey, config);
                this.accessKeyId = awsAccessKeyId;
                this.secretAccessKey = awsSecretAccessKey;
                this.serviceURL = ec2ServiceURL;
                this.signatureVersion = ec2SignatureVersion;
            }
            if ((response = this.service.terminateInstances(request = new TerminateInstancesRequest(id))).isSetTerminateInstancesResult()) {
                TerminateInstancesResult terminateInstancesResult = response.getTerminateInstancesResult();
                List terminatingInstanceList = terminateInstancesResult.getTerminatingInstance();
                for (TerminatingInstance terminatingInstance : terminatingInstanceList) {
                    InstanceState shutdownState;
                    if (!terminatingInstance.isSetShutdownState() || !(shutdownState = terminatingInstance.getShutdownState()).isSetCode()) continue;
                    int n = shutdownState.getCode();
                }
            }
        }
        catch (AmazonEC2Exception ex) {
            throw new WMRuntimeException(ex.getMessage());
        }
        return this.getServerList(null, auth);
    }

    @Override
    public Collection<CloudServer> createServer(String serverName, String desc, String ec2AMI, String flavorId, String network, String adminPassword, String keyPair, String vmType, List<String> securityGroup, CloudAuth auth) {
        ArrayList<String> instanceId = new ArrayList<String>();
        String instId = "";
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getSeceretAccessKey();
        String ec2SignatureVersion = auth.getEC2SignatureVersion();
        String ec2ServiceURL = auth.getEC2ServiceURL();
        try {
            RunInstancesResult runInstancesResult;
            Boolean monitoring;
            List blockDeviceMapping;
            String ramdiskId;
            String kernelId;
            Placement placement;
            String userData;
            int maxCount;
            int minCount;
            RunInstancesRequest request;
            RunInstancesResponse response;
            if (!this.loggedIn(auth)) {
                AmazonEC2Config config = new AmazonEC2Config();
                config.setSignatureVersion(ec2SignatureVersion);
                config.setServiceURL(ec2ServiceURL);
                this.service = new AmazonEC2Client(awsAccessKeyId, awsSecretAccessKey, config);
                this.accessKeyId = awsAccessKeyId;
                this.secretAccessKey = awsSecretAccessKey;
                this.serviceURL = ec2ServiceURL;
                this.signatureVersion = ec2SignatureVersion;
            }
            if ((response = this.service.runInstances(request = new RunInstancesRequest(ec2AMI, minCount = 1, maxCount = 1, keyPair, securityGroup, userData = null, vmType, placement = null, kernelId = null, ramdiskId = null, blockDeviceMapping = null, monitoring = null))).isSetRunInstancesResult() && (runInstancesResult = response.getRunInstancesResult()).isSetReservation()) {
                Reservation reservation = runInstancesResult.getReservation();
                List runningInstanceList = reservation.getRunningInstance();
                for (RunningInstance runningInstance : runningInstanceList) {
                    if (!runningInstance.isSetInstanceId()) continue;
                    instanceId.add(runningInstance.getInstanceId());
                }
            }
            boolean hostReturned = false;
            int n = 0;
            while (!hostReturned && n < 600) {
                DescribeInstancesRequest request1 = new DescribeInstancesRequest(instanceId);
                DescribeInstancesResponse response1 = this.service.describeInstances(request1);
                if (!response1.isSetDescribeInstancesResult()) continue;
                DescribeInstancesResult describeInstancesResult = response1.getDescribeInstancesResult();
                List reservationList = describeInstancesResult.getReservation();
                block5: for (Reservation reservation : reservationList) {
                    if (!reservation.isSetReservationId()) continue;
                    List runningInstanceList = reservation.getRunningInstance();
                    for (RunningInstance runningInstance : runningInstanceList) {
                        InstanceState instanceState;
                        if (!runningInstance.isSetInstanceState() || !(instanceState = runningInstance.getInstanceState()).isSetCode()) continue;
                        int stateCode = instanceState.getCode();
                        if (stateCode == 16) {
                            hostReturned = true;
                            instId = runningInstance.getInstanceId();
                            continue block5;
                        }
                        Thread.sleep(2000L);
                        ++n;
                    }
                }
            }
            if (!hostReturned) {
                throw new AssertionError((Object)"Timed out - Please check the result later");
            }
        }
        catch (AmazonEC2Exception ex) {
            throw new WMRuntimeException(ex.getMessage());
        }
        catch (InterruptedException ie) {
            throw new WMRuntimeException(ie.getMessage());
        }
        return this.getServerList(null, auth);
    }

    @Override
    public Collection<CloudImage> getImageList(CloudAuth auth) {
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getSeceretAccessKey();
        String ec2SignatureVersion = auth.getEC2SignatureVersion();
        String ec2ServiceURL = auth.getEC2ServiceURL();
        ArrayList<CloudImage> rtn = null;
        try {
            DescribeImagesResponse response;
            if (!this.loggedIn(auth)) {
                AmazonEC2Config config = new AmazonEC2Config();
                config.setSignatureVersion(ec2SignatureVersion);
                config.setServiceURL(ec2ServiceURL);
                this.service = new AmazonEC2Client(awsAccessKeyId, awsSecretAccessKey, config);
                this.accessKeyId = awsAccessKeyId;
                this.secretAccessKey = awsSecretAccessKey;
                this.serviceURL = ec2ServiceURL;
                this.signatureVersion = ec2SignatureVersion;
            }
            DescribeImagesRequest request = new DescribeImagesRequest();
            ArrayList<String> ownerList = new ArrayList<String>();
            if (!ec2ServiceURL.contains("Eucalyptus")) {
                ownerList.add("093867875159");
                request.setOwner(ownerList);
            }
            if ((response = this.service.describeImages(request)).isSetDescribeImagesResult()) {
                DescribeImagesResult describeImagesResult = response.getDescribeImagesResult();
                List imageList = describeImagesResult.getImage();
                rtn = new ArrayList<CloudImage>();
                for (Image image : imageList) {
                    CloudImage cloudImage = new CloudImage();
                    if (ec2ServiceURL.contains("Eucalyptus") && !image.getImageType().equals("machine")) continue;
                    if (image.isSetImageId()) {
                        cloudImage.setId(image.getImageId());
                    }
                    if (image.isSetArchitecture()) {
                        cloudImage.setDescription(image.getVisibility());
                    }
                    if (image.isSetPlatform()) {
                        cloudImage.setOS("architecture: " + image.getArchitecture());
                    }
                    rtn.add(cloudImage);
                }
            }
        }
        catch (AmazonEC2Exception ex) {
            throw new WMRuntimeException(ex.getMessage());
        }
        return rtn;
    }

    @Override
    public Collection<CloudSecurityGroup> getSecurityGroupList(CloudAuth auth) {
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getSeceretAccessKey();
        String ec2SignatureVersion = auth.getEC2SignatureVersion();
        String ec2ServiceURL = auth.getEC2ServiceURL();
        ArrayList<CloudSecurityGroup> rtn = null;
        try {
            DescribeSecurityGroupsRequest request;
            DescribeSecurityGroupsResponse response;
            if (!this.loggedIn(auth)) {
                AmazonEC2Config config = new AmazonEC2Config();
                config.setSignatureVersion(ec2SignatureVersion);
                config.setServiceURL(ec2ServiceURL);
                this.service = new AmazonEC2Client(awsAccessKeyId, awsSecretAccessKey, config);
                this.accessKeyId = awsAccessKeyId;
                this.secretAccessKey = awsSecretAccessKey;
                this.serviceURL = ec2ServiceURL;
                this.signatureVersion = ec2SignatureVersion;
            }
            if ((response = this.service.describeSecurityGroups(request = new DescribeSecurityGroupsRequest())).isSetDescribeSecurityGroupsResult()) {
                DescribeSecurityGroupsResult describeSecurityGroupsResult = response.getDescribeSecurityGroupsResult();
                List groupList = describeSecurityGroupsResult.getSecurityGroup();
                rtn = new ArrayList<CloudSecurityGroup>();
                for (SecurityGroup group : groupList) {
                    CloudSecurityGroup cloudSecGroup = new CloudSecurityGroup();
                    if (group.isSetOwnerId()) {
                        cloudSecGroup.setOwner(group.getOwnerId());
                    }
                    if (group.isSetGroupName()) {
                        cloudSecGroup.setName(group.getGroupName());
                    }
                    if (group.isSetGroupDescription()) {
                        cloudSecGroup.setDescription(group.getGroupDescription());
                    }
                    rtn.add(cloudSecGroup);
                }
            }
        }
        catch (AmazonEC2Exception ex) {
            throw new WMRuntimeException(ex.getMessage());
        }
        return rtn;
    }

    @Override
    public Collection<CloudKeyPair> getKeyPairList(CloudAuth auth) {
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getSeceretAccessKey();
        String ec2SignatureVersion = auth.getEC2SignatureVersion();
        String ec2ServiceURL = auth.getEC2ServiceURL();
        ArrayList<CloudKeyPair> rtn = null;
        try {
            DescribeKeyPairsRequest request;
            DescribeKeyPairsResponse response;
            if (!this.loggedIn(auth)) {
                AmazonEC2Config config = new AmazonEC2Config();
                config.setSignatureVersion(ec2SignatureVersion);
                config.setServiceURL(ec2ServiceURL);
                this.service = new AmazonEC2Client(awsAccessKeyId, awsSecretAccessKey, config);
                this.accessKeyId = awsAccessKeyId;
                this.secretAccessKey = awsSecretAccessKey;
                this.serviceURL = ec2ServiceURL;
                this.signatureVersion = ec2SignatureVersion;
            }
            if ((response = this.service.describeKeyPairs(request = new DescribeKeyPairsRequest())).isSetDescribeKeyPairsResult()) {
                DescribeKeyPairsResult describeKeyPairsResult = response.getDescribeKeyPairsResult();
                List keyPairList = describeKeyPairsResult.getKeyPair();
                rtn = new ArrayList<CloudKeyPair>();
                for (KeyPair keyPair : keyPairList) {
                    CloudKeyPair cloudKeyPair = new CloudKeyPair();
                    if (keyPair.isSetKeyName()) {
                        cloudKeyPair.setKeyname(keyPair.getKeyName());
                    }
                    if (keyPair.isSetKeyFingerprint()) {
                        cloudKeyPair.setFingerprint(keyPair.getKeyFingerprint());
                    }
                    if (keyPair.isSetKeyMaterial()) {
                        cloudKeyPair.setMaterial(keyPair.getKeyMaterial());
                    }
                    rtn.add(cloudKeyPair);
                }
            }
        }
        catch (AmazonEC2Exception ex) {
            throw new WMRuntimeException(ex.getMessage());
        }
        return rtn;
    }

    @Override
    public Collection<CloudFlavor> getFlavorList(CloudAuth authObj) {
        return null;
    }

    @Override
    public Collection<CloudNetwork> getNetworkList(CloudAuth authObj) {
        return null;
    }

    private boolean loggedIn(CloudAuth auth) {
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getSeceretAccessKey();
        String ec2SignatureVersion = auth.getEC2SignatureVersion();
        String ec2ServiceURL = auth.getEC2ServiceURL();
        return this.service != null && this.accessKeyId != null && this.secretAccessKey != null && this.serviceURL != null && this.signatureVersion != null && this.accessKeyId.equals(awsAccessKeyId) && this.secretAccessKey.equals(awsSecretAccessKey) && this.signatureVersion.equals(ec2SignatureVersion) && this.serviceURL.equals(ec2ServiceURL);
    }
}

