/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.amazon;

import com.amazon.s3.AWSAuthConnection;
import com.amazon.s3.Bucket;
import com.amazon.s3.CallingFormat;
import com.amazon.s3.ListAllMyBucketsResponse;
import com.amazon.s3.ListBucketResponse;
import com.amazon.s3.ListEntry;
import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.cloudmgr.CloudAuth;
import com.wavemaker.tools.cloudmgr.CloudContainer;
import com.wavemaker.tools.cloudmgr.CloudFile;
import com.wavemaker.tools.cloudmgr.CloudStorageMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonS3StorageMgr
implements CloudStorageMgr {
    private AWSAuthConnection conn = null;
    private final String S3_ERROR_CONNETION_FAILURE = "Server refused to connect you, Error code = ";
    private final String S3_ERROR_BUCKET_NOT_EMPTY = "Bucket may not be empty";
    private boolean isSecured = true;

    @Override
    public Collection<CloudContainer> getContainerList(CloudAuth auth) {
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getSeceretAccessKey();
        String serviceURL = auth.getEC2ServiceURL();
        return this.getContainerList(awsAccessKeyId, awsSecretAccessKey, serviceURL);
    }

    private Collection<CloudContainer> getContainerList(String awsAccessKeyId, String awsSecretAccessKey, String serviceURL) {
        CallingFormat fmt = CallingFormat.getSubdomainCallingFormat();
        if (serviceURL.contains("Walrus")) {
            this.isSecured = false;
        }
        this.conn = new AWSAuthConnection(awsAccessKeyId, awsSecretAccessKey, this.isSecured, serviceURL, fmt);
        return this.getContainerList(this.conn);
    }

    private Collection<CloudContainer> getContainerList(AWSAuthConnection conn) {
        ArrayList<CloudContainer> containers = null;
        try {
            ListAllMyBucketsResponse bucketList = this.getS3BucketInfo(conn);
            List buckets = bucketList.entries;
            if (buckets != null && buckets.size() > 0) {
                containers = new ArrayList<CloudContainer>();
                for (Bucket bucket : buckets) {
                    String containerName = bucket.name;
                    String sDate = bucket.creationDate.toString();
                    Collection<CloudFile> clist = null;
                    if (!containerName.contains(".")) {
                        ListBucketResponse bobj = conn.listBucket(containerName, null, null, null, null);
                        List entries = bobj.entries;
                        clist = this.convertToCloudFiles(containerName, entries);
                    }
                    CloudContainer container = new CloudContainer(containerName, sDate, clist);
                    containers.add(container);
                }
            }
        }
        catch (MalformedURLException mex) {
            throw new WMRuntimeException(mex.getMessage());
        }
        catch (IOException ex) {
            throw new WMRuntimeException(ex.getMessage());
        }
        return containers;
    }

    @Override
    public CloudContainer getContainer(String containerName, CloudAuth auth) {
        CloudContainer targetContainer = null;
        Collection<CloudContainer> containers = this.getContainerList(auth);
        for (CloudContainer container : containers) {
            if (!container.getContainerName().equals(containerName)) continue;
            targetContainer = container;
            break;
        }
        if (targetContainer == null) {
            throw new WMRuntimeException("Error: Container not found");
        }
        return targetContainer;
    }

    @Override
    public Collection<CloudFile> getCloudFiles(String containerName, CloudAuth auth) {
        return this.getContainer(containerName, auth).getFiles();
    }

    private Collection<CloudFile> convertToCloudFiles(String containerName, List<ListEntry> entries) {
        ArrayList<CloudFile> rtn = new ArrayList<CloudFile>();
        for (ListEntry obj : entries) {
            String sSize = Long.valueOf(obj.size).toString();
            CloudFile cf = new CloudFile(containerName, obj.key, sSize, obj.owner.displayName, obj.lastModified.toString());
            rtn.add(cf);
        }
        return rtn;
    }

    private ListAllMyBucketsResponse getS3BucketInfo(AWSAuthConnection conn) {
        ListAllMyBucketsResponse listAllMyBucketsResponse = null;
        try {
            listAllMyBucketsResponse = conn.listAllMyBuckets(null);
            int code = listAllMyBucketsResponse.connection.getResponseCode();
            if (code > 400) {
                throw new AssertionError((Object)("Server refused to connect you, Error code = " + code));
            }
        }
        catch (MalformedURLException mex) {
            throw new WMRuntimeException(mex.getMessage());
        }
        catch (IOException ex) {
            throw new WMRuntimeException(ex.getMessage());
        }
        return listAllMyBucketsResponse;
    }

    @Override
    public Collection<CloudContainer> createContainer(String containerName, String location, CloudAuth auth) {
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getAccessKeyId();
        String serviceURL = auth.getEC2ServiceURL();
        return this.createS3Bucket(containerName, location, awsAccessKeyId, awsSecretAccessKey, serviceURL);
    }

    private Collection<CloudContainer> createS3Bucket(String bucket, String location, String awsAccessKeyId, String awsSecretAccessKey, String serviceURL) {
        String locName = location.equals("EU") ? "EU" : null;
        try {
            if (this.conn == null) {
                CallingFormat fmt = CallingFormat.getSubdomainCallingFormat();
                if (serviceURL.contains("Walrus")) {
                    this.isSecured = false;
                }
                this.conn = new AWSAuthConnection(awsAccessKeyId, awsSecretAccessKey, this.isSecured, serviceURL, fmt);
            }
            if (this.conn.checkBucketExists(bucket)) {
                throw new AssertionError((Object)"Bucket already exists");
            }
            Response response = this.conn.createBucket(bucket, locName, null);
            int code = response.connection.getResponseCode();
            if (code > 400) {
                throw new AssertionError((Object)("Server refused to connect you, Error code = " + code));
            }
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex.getMessage());
        }
        return this.getContainerList(awsAccessKeyId, awsSecretAccessKey, serviceURL);
    }

    @Override
    public Collection<CloudContainer> deleteContainer(String containerName, CloudAuth auth) {
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getAccessKeyId();
        String serviceURL = auth.getEC2ServiceURL();
        return this.deleteS3Bucket(containerName, awsAccessKeyId, awsSecretAccessKey, serviceURL);
    }

    private Collection<CloudContainer> deleteS3Bucket(String bucket, String awsAccessKeyId, String awsSecretAccessKey, String serviceURL) {
        try {
            if (this.conn == null) {
                CallingFormat fmt = CallingFormat.getSubdomainCallingFormat();
                if (serviceURL.contains("Walrus")) {
                    this.isSecured = false;
                }
                this.conn = new AWSAuthConnection(awsAccessKeyId, awsSecretAccessKey, this.isSecured, serviceURL, fmt);
            }
            Response response = this.conn.deleteBucket(bucket, null);
            int code = response.connection.getResponseCode();
            if (code == 409) {
                throw new AssertionError((Object)"Bucket may not be empty");
            }
            if (code > 400) {
                throw new AssertionError((Object)("Server refused to connect you, Error code = " + code));
            }
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex.getMessage());
        }
        return this.getContainerList(awsAccessKeyId, awsSecretAccessKey, serviceURL);
    }

    @Override
    public Collection<CloudFile> copyFileToCloudStorage(String containerName, File warFile, CloudAuth auth) {
        String fName = warFile.getName();
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getAccessKeyId();
        String serviceURL = auth.getEC2ServiceURL();
        try {
            if (this.conn == null) {
                CallingFormat fmt = CallingFormat.getSubdomainCallingFormat();
                if (serviceURL.contains("Walrus")) {
                    this.isSecured = false;
                }
                this.conn = new AWSAuthConnection(awsAccessKeyId, awsSecretAccessKey, this.isSecured, serviceURL, fmt);
            }
            int len = (int)warFile.length();
            FileInputStream fis = new FileInputStream(warFile);
            byte[] b = new byte[len];
            while (fis.read(b) != -1) {
                Response response = this.conn.put(containerName, fName, new S3Object(b, null), null);
                int code = response.connection.getResponseCode();
                if (code > 400) {
                    throw new AssertionError((Object)("Server refused to connect you, Error code = " + code));
                }
            }
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex.getMessage());
        }
        return this.getContainer(containerName, auth).getFiles();
    }

    @Override
    public Collection<CloudFile> deleteFileInCloudStorage(String containerName, String fileName, CloudAuth auth) {
        String awsAccessKeyId = auth.getAccessKeyId();
        String awsSecretAccessKey = auth.getAccessKeyId();
        String serviceURL = auth.getEC2ServiceURL();
        try {
            if (this.conn == null) {
                CallingFormat fmt = CallingFormat.getSubdomainCallingFormat();
                if (serviceURL.contains("Walrus")) {
                    this.isSecured = false;
                }
                this.conn = new AWSAuthConnection(awsAccessKeyId, awsSecretAccessKey, this.isSecured, serviceURL, fmt);
            }
            Response response = this.conn.delete(containerName, fileName, null);
            int code = response.connection.getResponseCode();
            if (code > 400) {
                throw new AssertionError((Object)("Server refused to connect you, Error code = " + code));
            }
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex.getMessage());
        }
        return this.getContainer(containerName, auth).getFiles();
    }
}

