/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.opsource.deployserver.proc;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.runtime.ws.HTTPBindingSupport;
import com.wavemaker.runtime.ws.WebServiceException;
import com.wavemaker.tools.cloudmgr.opsource.ProcStatus;
import com.wavemaker.tools.cloudmgr.opsource.deployserver.request.Server;
import com.wavemaker.tools.cloudmgr.opsource.deployserver.response.Status;
import com.wavemaker.tools.cloudmgr.opsource.listservers.proc.ListServersProc;
import com.wavemaker.tools.cloudmgr.opsource.listservers.response.Servers;
import com.wavemaker.tools.cloudmgr.opsource.startserver.proc.StartServerProc;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;

public class DeployServerProc {
    public ProcStatus deployServer(String orgId, String name, String desc, String networkId, String image, String adminPasswd, String userName, String passWord) {
        com.wavemaker.tools.cloudmgr.opsource.startserver.response.Status status1;
        String endPointAddress = "https://api.opsourcecloud.net/oec/0.9/" + orgId + "/server";
        QName thisQName = new QName(endPointAddress, "opsourcecloud");
        Service s = Service.create((QName)thisQName);
        Server svrReq = new Server();
        String vlanResourcePath = "/oec/" + orgId + "/network/" + networkId;
        image = "/oec/opsource/image/" + image;
        try {
            URI address = new URI(endPointAddress);
            s.addPort(thisQName, "http://www.w3.org/2004/08/wsdl/http", address.toString());
            Dispatch d = s.createDispatch(thisQName, DataSource.class, Service.Mode.MESSAGE);
            Map requestContext = d.getRequestContext();
            requestContext.put("javax.xml.ws.http.request.method", "POST");
            requestContext.put("javax.xml.ws.security.auth.username", userName);
            requestContext.put("javax.xml.ws.security.auth.password", passWord);
            svrReq.setName(name);
            svrReq.setDescription(desc);
            svrReq.setVlanResourcePath(vlanResourcePath);
            svrReq.setImageResourcePath(image);
            svrReq.setAdministratorPassword(adminPasswd);
            String msg = HTTPBindingSupport.convertToXMLString(svrReq);
            DataSource postSource = HTTPBindingSupport.createDataSource("application/xml", msg);
            DataSource response = (DataSource)d.invoke((Object)postSource);
            InputStream inputStream = response.getInputStream();
            JAXBContext respContext = JAXBContext.newInstance((Class[])new Class[]{Status.class});
            Unmarshaller unmarshaller = respContext.createUnmarshaller();
            Object object = unmarshaller.unmarshal(inputStream);
            Status status = (Status)Status.class.cast(object);
            String resultCode = status.getResultCode();
            if (!resultCode.equals("REASON_0") && !resultCode.equals("REASON_40")) {
                throw new WMRuntimeException(status.getResultDetail());
            }
            boolean serverCreated = false;
            int n = 0;
            StartServerProc startServerProc = new StartServerProc();
            ListServersProc listServersProc = new ListServersProc();
            String serverId = null;
            block6: while (!serverCreated && n < 600) {
                Servers svrs = listServersProc.listServers(orgId, userName, passWord);
                List<Servers.Server> servers = svrs.getServer();
                for (Servers.Server server : servers) {
                    String serverName = server.getName();
                    if (name.equals(serverName)) {
                        serverCreated = true;
                        serverId = server.getId();
                        continue block6;
                    }
                    Thread.sleep(2000L);
                    ++n;
                }
            }
            if (!serverCreated) {
                throw new WMRuntimeException("Timed out - Failure creating a new OpSource server instance");
            }
            Thread.sleep(5000L);
            status1 = startServerProc.startServer(serverId, orgId, userName, passWord);
            resultCode = status1.getResultCode();
            if (!resultCode.equals("REASON_0")) {
                throw new WMRuntimeException(status1.getResultDetail());
            }
        }
        catch (URISyntaxException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        catch (WebServiceException ex) {
            throw new WMRuntimeException((Throwable)((Object)ex));
        }
        catch (InterruptedException ie) {
            throw new WMRuntimeException((Throwable)ie);
        }
        return status1;
    }
}

