/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.rackspace;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.StudioConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.log4j.Logger;

public class CommonUtil {
    private static Logger logger = Logger.getLogger(CommonUtil.class);
    private static final String file = "cloud.properties";
    private static Properties props = null;

    private static void loadPropertiesFromClasspath() throws IOException {
        props = new Properties();
        String name = "com/wavemaker/tools/cloudmgr/rackspace/cloud.properties";
        InputStream inputStream = StudioConfiguration.class.getClassLoader().getResourceAsStream(name);
        if (inputStream == null) {
            throw new FileNotFoundException("Property file 'cloud.properties' not found in the classpath");
        }
        props.load(inputStream);
    }

    public static String getProperty(String key) {
        if (props == null) {
            try {
                CommonUtil.loadPropertiesFromClasspath();
            }
            catch (Exception ioe) {
                logger.warn((Object)"Unable to load properties file.");
                throw new WMRuntimeException((Throwable)ioe);
            }
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        if (props == null) {
            try {
                CommonUtil.loadPropertiesFromClasspath();
            }
            catch (Exception ioe) {
                logger.warn((Object)"Unable to load properties file.");
                throw new WMRuntimeException((Throwable)ioe);
            }
        }
        return props.getProperty(key, defaultValue);
    }

    public static int getIntProperty(String key) {
        String property = CommonUtil.getProperty(key);
        if (property == null) {
            logger.warn((Object)("Could not load integer property " + key));
            throw new WMRuntimeException("Could not load integer property " + key);
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)("Invalid format for a number in properties file: " + property), (Throwable)nfe);
            throw new WMRuntimeException("Invalid format for a number in properties file: " + property, (Throwable)nfe);
        }
    }

    public static String inputStreamToString(InputStream stream, String encoding) throws IOException {
        char[] buffer = new char[4096];
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(stream, "utf-8");
        int nRead = 0;
        while ((nRead = isr.read(buffer)) >= 0) {
            sb.append(buffer, 0, nRead);
        }
        isr.close();
        return sb.toString();
    }

    public static String sanitizeForURI(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(str).replaceAll("\\+", "%20").replaceAll("%2F", "/");
        }
        catch (EncoderException ee) {
            logger.warn((Object)"Error trying to encode string for URI", (Throwable)ee);
            throw new WMRuntimeException("Error trying to encode string for URI", (Throwable)ee);
        }
    }
}

