/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.rackspace;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.cloudmgr.CloudAuth;
import com.wavemaker.tools.cloudmgr.CloudFlavor;
import com.wavemaker.tools.cloudmgr.CloudImage;
import com.wavemaker.tools.cloudmgr.CloudKeyPair;
import com.wavemaker.tools.cloudmgr.CloudNetwork;
import com.wavemaker.tools.cloudmgr.CloudSecurityGroup;
import com.wavemaker.tools.cloudmgr.CloudServer;
import com.wavemaker.tools.cloudmgr.CloudServerMgr;
import com.wavemaker.tools.cloudmgr.rackspace.cloudservers.ServersClient;
import com.wavemaker.tools.cloudmgr.rackspace.cloudservers.ServersServerInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RackSpaceServerMgr
implements CloudServerMgr {
    private boolean logged_in = false;
    private ServersClient client = null;
    private String username = null;
    private String password = null;

    @Override
    public Collection<CloudServer> createServer(String serverName, String desc, String image, String flavorId, String network, String adminPass, String keyPair, String vmType, List<String> securityGroup, CloudAuth auth) {
        if (!StringUtils.isNotBlank((String)serverName) || serverName.indexOf(47) != -1) {
            System.err.println("You must provide a valid value for the Server name !");
            System.exit(-1);
        }
        String un = auth.getUsername();
        String pw = auth.getPassword();
        try {
            if (!this.loggedIn(auth)) {
                this.client = new ServersClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (!this.logged_in) {
                throw new WMRuntimeException("Failed to login to Cloud Servers!");
            }
            this.client.createServer(serverName, image, flavorId);
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return this.getServerList(null, auth);
    }

    @Override
    public Collection<CloudServer> deleteServer(String serverId, CloudAuth auth) {
        String un = auth.getUsername();
        String pw = auth.getPassword();
        try {
            if (!this.loggedIn(auth)) {
                this.client = new ServersClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (!this.logged_in) {
                throw new WMRuntimeException("Failed to login to Cloud Servers!");
            }
            this.client.deleteServer(serverId);
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return this.getServerList(null, auth);
    }

    @Override
    public Collection<CloudServer> getServerList(String image, CloudAuth auth) {
        String un = auth.getUsername();
        String pw = auth.getPassword();
        ArrayList<CloudServer> rtn = null;
        try {
            if (!this.loggedIn(auth)) {
                this.client = new ServersClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (!this.logged_in) {
                throw new WMRuntimeException("Failed to login to Cloud Servers!");
            }
            List<ServersServerInfo> serverList = this.client.listServerDetails();
            if (serverList != null && serverList.size() > 0) {
                rtn = new ArrayList<CloudServer>();
                for (ServersServerInfo info : serverList) {
                    if (image != null && !image.equals(info.getImageId())) continue;
                    CloudServer cloudServer = new CloudServer(info.getName(), null, info.getId(), info.getImageId(), info.getFlavorId(), null, null, info.getPublicIpAddress(), info.getPrivateIpAddress(), info.getCreated());
                    rtn.add(cloudServer);
                }
            }
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return rtn;
    }

    @Override
    public Collection<CloudImage> getImageList(CloudAuth auth) {
        Collection<CloudImage> rtn;
        String un = auth.getUsername();
        String pw = auth.getPassword();
        try {
            if (!this.loggedIn(auth)) {
                this.client = new ServersClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (!this.logged_in) {
                throw new WMRuntimeException("Failed to login to Cloud Servers!");
            }
            rtn = this.client.listImages();
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return rtn;
    }

    @Override
    public Collection<CloudFlavor> getFlavorList(CloudAuth auth) {
        Collection<CloudFlavor> rtn;
        String un = auth.getUsername();
        String pw = auth.getPassword();
        try {
            if (!this.loggedIn(auth)) {
                this.client = new ServersClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (!this.logged_in) {
                throw new WMRuntimeException("Failed to login to Cloud Servers!");
            }
            rtn = this.client.listFlavors();
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return rtn;
    }

    private boolean loggedIn(CloudAuth auth) {
        String un = auth.getUsername();
        String pw = auth.getPassword();
        return this.logged_in && this.username != null && this.password != null && this.username.equals(un) && this.password.equals(pw);
    }

    @Override
    public Collection<CloudNetwork> getNetworkList(CloudAuth authObj) {
        return null;
    }

    @Override
    public Collection<CloudSecurityGroup> getSecurityGroupList(CloudAuth authObj) {
        return null;
    }

    @Override
    public Collection<CloudKeyPair> getKeyPairList(CloudAuth authObj) {
        return null;
    }
}

