/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.rackspace;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.cloudmgr.CloudAuth;
import com.wavemaker.tools.cloudmgr.CloudContainer;
import com.wavemaker.tools.cloudmgr.CloudFile;
import com.wavemaker.tools.cloudmgr.CloudStorageMgr;
import com.wavemaker.tools.cloudmgr.rackspace.Constants;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesClient;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesContainer;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RackSpaceStorageMgr
implements CloudStorageMgr {
    private boolean logged_in = false;
    private FilesClient client = null;
    private String username = null;
    private String password = null;

    @Override
    public Collection<CloudContainer> getContainerList(CloudAuth auth) {
        List<FilesContainer> filescontainers = null;
        ArrayList<CloudContainer> rtn = null;
        try {
            String un = auth.getUsername();
            String pw = auth.getPassword();
            if (!this.loggedIn(auth)) {
                this.client = new FilesClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (!this.logged_in) {
                throw new WMRuntimeException("Failed to login to Cloud Files!");
            }
            filescontainers = this.client.listContainers();
            if (filescontainers != null) {
                rtn = new ArrayList<CloudContainer>();
                for (FilesContainer filescontainer : filescontainers) {
                    CloudContainer container = new CloudContainer();
                    container.setContainerName(filescontainer.getName());
                    List<FilesObject> flist = filescontainer.getObjects();
                    if (flist != null && flist.size() > 0) {
                        ArrayList<CloudFile> fl = new ArrayList<CloudFile>();
                        for (FilesObject fobj : flist) {
                            CloudFile cfile = new CloudFile();
                            cfile.setContainerName(filescontainer.getName());
                            cfile.setFileName(fobj.getName());
                            cfile.setSize(fobj.getSize());
                            cfile.setSizeString(fobj.getSizeString());
                            cfile.setLastModified(fobj.getLastModified());
                            fl.add(cfile);
                        }
                        container.setFiles(fl);
                    }
                    rtn.add(container);
                }
            }
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return rtn;
    }

    @Override
    public CloudContainer getContainer(String containerName, CloudAuth auth) {
        Collection<CloudContainer> cl = this.getContainerList(auth);
        CloudContainer rtn = null;
        if (cl != null && cl.size() > 0) {
            for (CloudContainer c : cl) {
                if (!containerName.equals(c.getContainerName())) continue;
                rtn = c;
                break;
            }
        }
        return rtn;
    }

    @Override
    public Collection<CloudContainer> createContainer(String containerName, String location, CloudAuth auth) {
        if (!StringUtils.isNotBlank((String)containerName) || containerName.indexOf(47) != -1) {
            throw new WMRuntimeException("You must provide a valid value for the Container name !");
        }
        String un = auth.getUsername();
        String pw = auth.getPassword();
        try {
            if (!this.loggedIn(auth)) {
                this.client = new FilesClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (!this.logged_in) {
                throw new WMRuntimeException("Failed to login to Cloud Files!");
            }
            this.client.createContainer(containerName);
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        return this.getContainerList(auth);
    }

    @Override
    public Collection<CloudContainer> deleteContainer(String containerName, CloudAuth auth) {
        block8: {
            boolean recurse = true;
            if (!StringUtils.isNotBlank((String)containerName)) {
                throw new WMRuntimeException("You must provide a valid value for the Container name !");
            }
            String un = auth.getUsername();
            String pw = auth.getPassword();
            try {
                if (!this.loggedIn(auth)) {
                    this.client = new FilesClient(un, pw);
                    this.logged_in = this.client.login();
                    this.username = un;
                    this.password = pw;
                }
                if (this.logged_in) {
                    if (recurse) {
                        List<FilesObject> objects = this.client.listObjects(containerName);
                        for (FilesObject obj : objects) {
                            this.client.deleteObject(containerName, obj.getName());
                        }
                    }
                    if (!this.client.deleteContainer(containerName)) {
                        throw new WMRuntimeException("Failed to delete container!");
                    }
                    break block8;
                }
                throw new WMRuntimeException("Failed to login to Cloud Files!");
            }
            catch (Exception ex) {
                throw new WMRuntimeException((Throwable)ex);
            }
        }
        return this.getContainerList(auth);
    }

    @Override
    public Collection<CloudFile> getCloudFiles(String containerName, CloudAuth auth) {
        CloudContainer container = this.getContainer(containerName, auth);
        return container.getFiles();
    }

    @Override
    public Collection<CloudFile> copyFileToCloudStorage(String containerName, File file, CloudAuth auth) {
        this.storeObject(containerName, file, auth);
        return this.getContainer(containerName, auth).getFiles();
    }

    @Override
    public Collection<CloudFile> deleteFileInCloudStorage(String containerName, String warFileName, CloudAuth auth) {
        this.deleteObject(containerName, warFileName, auth);
        return this.getContainer(containerName, auth).getFiles();
    }

    private void storeObject(String containerName, File file, CloudAuth auth) {
        String fileNamePath = file.getAbsolutePath();
        String fileExt = FilenameUtils.getExtension((String)fileNamePath);
        String mimeType = Constants.getMimetype(fileExt);
        String un = auth.getUsername();
        String pw = auth.getPassword();
        try {
            if (!this.loggedIn(auth)) {
                this.client = new FilesClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (this.logged_in) {
                if (!this.client.containerExists(containerName)) {
                    throw new WMRuntimeException("The container does not exist.  Create it first before placing objects into it.");
                }
            } else {
                throw new WMRuntimeException("Failed to login to Cloud Files!");
            }
            this.client.storeObject(containerName, file, mimeType);
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
    }

    private void deleteObject(String containerName, String warFileName, CloudAuth auth) {
        String un = auth.getUsername();
        String pw = auth.getPassword();
        try {
            if (!this.loggedIn(auth)) {
                this.client = new FilesClient(un, pw);
                this.logged_in = this.client.login();
                this.username = un;
                this.password = pw;
            }
            if (this.logged_in) {
                if (!this.client.containerExists(containerName)) {
                    throw new WMRuntimeException("The container does not exist.  Create it first before placing objects into it.");
                }
            } else {
                throw new WMRuntimeException("Failed to login to Cloud Servers!");
            }
            this.client.deleteObject(containerName, warFileName);
        }
        catch (Exception ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
    }

    private boolean loggedIn(CloudAuth auth) {
        String un = auth.getUsername();
        String pw = auth.getPassword();
        return this.logged_in && this.username != null && this.password != null && this.username.equals(un) && this.password.equals(pw);
    }
}

