/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.rackspace.cloudfiles;

import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesAuthorizationException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesClient;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesContainerInfo;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesObject;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesContainer {
    private String name;
    private List<FilesObject> objects = null;
    private FilesClient client = null;
    private static Logger logger = Logger.getLogger(FilesContainer.class);

    public FilesContainer(String name, List<FilesObject> objs, FilesClient client) {
        this.name = name;
        this.objects = objs;
        this.client = client;
    }

    public FilesContainer(String name, FilesClient client) {
        this.name = name;
        this.client = client;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<FilesObject> getObjects() throws HttpException, IOException, FilesAuthorizationException, FilesException {
        if (this.client != null) {
            if (this.objects == null) {
                this.objects = this.client.listObjects(this.name);
            }
            return this.objects;
        }
        logger.fatal((Object)"This Container has no FilesClient defined !");
        return null;
    }

    public List<FilesObject> getObjects(String path) throws HttpException, IOException, FilesAuthorizationException, FilesException {
        if (this.client != null) {
            if (this.objects == null) {
                this.objects = this.client.listObjects(this.name, path);
            }
            return this.objects;
        }
        logger.fatal((Object)"This Container has no FilesClient defined !");
        return null;
    }

    public FilesContainerInfo getInfo() throws HttpException, IOException, FilesException {
        if (this.client != null) {
            return this.client.getContainerInfo(this.name);
        }
        logger.fatal((Object)"This container does not have a valid client !");
        return null;
    }

    public FilesClient getClient() {
        return this.client;
    }

    public boolean addObject(File f, String mimeType) throws NoSuchAlgorithmException, IOException, FilesAuthorizationException, FilesException {
        FilesObject obj = new FilesObject(f, mimeType, this);
        if (this.objects != null) {
            this.objects.add(obj);
        } else {
            this.objects = this.getObjects();
            if (this.objects != null) {
                return this.objects.add(obj);
            }
        }
        logger.fatal((Object)"Could not add Object, it seems something is wrong with this Container or FilesClient");
        return false;
    }

    public void createContainer() throws HttpException, IOException, FilesAuthorizationException, FilesException {
        if (this.client != null) {
            this.client.createContainer(this.name);
        } else {
            logger.fatal((Object)"This Container has no FilesClient defined !");
        }
    }
}

