/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.rackspace.cloudfiles;

import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesAuthorizationException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesClient;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesContainer;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesInvalidNameException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesNotFoundException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.FilesObjectMetaData;
import com.wavemaker.tools.cloudmgr.rackspace.cloudfiles.IFilesTransferCallback;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;

public class FilesObject {
    private String container;
    private String name;
    private String md5sum = null;
    private long size = -1L;
    private String mimeType = null;
    private String lastModified = null;
    private FilesClient client = null;
    private static Logger logger = Logger.getLogger(FilesObject.class);

    /*
     * Enabled aggressive block sorting
     */
    FilesObject(File obj, String mimeType, FilesContainer container) throws NullPointerException, NoSuchAlgorithmException, IOException {
        if (obj == null) {
            logger.fatal((Object)"Not possible to create a FilesObject from a null File.");
            throw new NullPointerException("File Object passed was null !");
        }
        if (!obj.exists()) {
            logger.fatal((Object)"File object must exist so we can create an MD5SUM for it !");
            throw new NullPointerException("The file object provided does not exist.");
        }
        if (!obj.isDirectory()) {
            this.setName(obj.getName());
            this.setMd5sum(FilesClient.md5Sum(obj));
            this.setSize(obj.length());
            this.setMimeType(mimeType);
            this.setClient(container.getClient());
            this.setContainer(container.getName());
            return;
        }
        logger.fatal((Object)"Can not create Directories as FSObjects create a FilesContainer for this object");
        throw new NullPointerException("File Object was a directory !");
    }

    FilesObject(String name, String container, FilesClient client) {
        this.name = name;
        this.container = container;
        this.client = client;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.length() > 1024) {
            logger.warn((Object)("Object name larger than 1024 characters truncating from: " + name));
            this.name = name.substring(0, 1024);
            logger.warn((Object)("Object name truncated to : " + name));
        }
        this.name = name;
    }

    public String getMimeType() throws HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException {
        if (this.mimeType == null) {
            this.getMetaData();
        }
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMd5sum() throws HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException {
        if (this.md5sum == null) {
            this.getMetaData();
        }
        return this.md5sum;
    }

    public void setMd5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    public long getSize() throws HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException {
        if (this.size == -1L) {
            this.getMetaData();
        }
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long writeObjectToFile(File localFile) throws FileNotFoundException, HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException {
        byte[] data;
        long bytesWritten = 0L;
        FileOutputStream out = new FileOutputStream(localFile);
        InputStream in = this.getObjectAsStream();
        int ret = in.read(data = new byte[1024], 0, data.length);
        if (ret == -1) {
            out.write(data, 0, data.length);
            return data.length;
        }
        while (ret != -1) {
            bytesWritten += (long)ret;
            out.write(data, 0, ret);
            ret = in.read(data, 0, data.length);
        }
        out.flush();
        out.close();
        in.close();
        return bytesWritten;
    }

    public InputStream getObjectAsStream() throws HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException {
        return this.client.getObjectAsStream(this.container, this.name);
    }

    public byte[] getObject() throws HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException, FilesNotFoundException {
        return this.client.getObject(this.container, this.name);
    }

    public FilesObjectMetaData getMetaData() throws HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException {
        FilesObjectMetaData metaData = this.client.getObjectMetaData(this.container, this.name);
        if (metaData != null) {
            this.setMd5sum(metaData.getETag());
            this.setSize(Long.parseLong(metaData.getContentLength()));
            this.setMimeType(metaData.getMimeType());
            this.setLastModified(metaData.getLastModified());
        }
        return metaData;
    }

    void setClient(FilesClient client) {
        this.client = client;
    }

    void setContainer(String container) {
        this.container = container;
    }

    public static FilesObject uploadObject(File obj, String mimeType, FilesContainer container) throws IOException, FilesException {
        return FilesObject.uploadObject(obj, mimeType, container, null);
    }

    public static FilesObject uploadObject(File obj, String mimeType, FilesContainer container, IFilesTransferCallback callback) throws IOException, FilesException {
        FilesObject result = null;
        try {
            result = new FilesObject(obj, mimeType, container);
            FilesClient client = container.getClient();
            client.storeObjectAs(container.getName(), obj, mimeType, obj.getName(), callback);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.fatal((Object)"Install doesn't have MD5, can't upload files", (Throwable)nsae);
        }
        return result;
    }

    public String getSizeString() throws HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        this.getMetaData();
        if (this.size > gb) {
            return this.size / gb + " GB";
        }
        if (this.size > mb) {
            return this.size / mb + " MB";
        }
        if (this.size > kb) {
            return this.size / kb + " KB";
        }
        return this.getSize() + " Bytes";
    }

    public String getLastModified() throws HttpException, IOException, FilesAuthorizationException, FilesInvalidNameException {
        if (this.lastModified == null) {
            this.getMetaData();
        }
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }
}

