/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.cloudmgr.rackspace.cloudservers;

import com.wavemaker.tools.cloudmgr.CloudFlavor;
import com.wavemaker.tools.cloudmgr.CloudImage;
import com.wavemaker.tools.cloudmgr.rackspace.CommonUtil;
import com.wavemaker.tools.cloudmgr.rackspace.Response;
import com.wavemaker.tools.cloudmgr.rackspace.cloudservers.ServersAuthorizationException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudservers.ServersException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudservers.ServersInvalidNameException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudservers.ServersNotFoundException;
import com.wavemaker.tools.cloudmgr.rackspace.cloudservers.ServersServerInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServersClient {
    public static final String VERSION = "v1";
    private String username = null;
    private String password = null;
    private String account = null;
    private String authenticationURL;
    private int connectionTimeOut;
    private String serverMgmntURL = null;
    private String authToken = null;
    private boolean isLoggedin = false;
    private HttpClient client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
    private static Logger logger = Logger.getLogger(ServersClient.class);

    public ServersClient(String username, String password, String account, int connectionTimeOut) {
        this.username = username;
        this.password = password;
        this.account = account;
        this.authenticationURL = account != null && account.length() > 0 ? CommonUtil.getProperty("auth_url") + VERSION + "/" + account + CommonUtil.getProperty("auth_url_post") : CommonUtil.getProperty("auth_url");
        this.connectionTimeOut = connectionTimeOut;
        this.client.getParams().setParameter("http.socket.timeout", (Object)this.connectionTimeOut);
        this.setUserAgent("java-cloudfiles/1.4.2");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UserName: " + this.username));
            logger.debug((Object)("AuthenticationURL: " + this.authenticationURL));
            logger.debug((Object)("ConnectionTimeOut: " + this.connectionTimeOut));
        }
    }

    public ServersClient(String username, String password, String account) {
        this(username, password, account, CommonUtil.getIntProperty("connection_timeout"));
    }

    public ServersClient(String username, String apiAccessKey) {
        this(username, apiAccessKey, null, CommonUtil.getIntProperty("connection_timeout"));
    }

    public ServersClient() {
        this(CommonUtil.getProperty("username"), CommonUtil.getProperty("password"), CommonUtil.getProperty("account"), CommonUtil.getIntProperty("connection_timeout"));
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
        this.authenticationURL = account != null && account.length() > 0 ? CommonUtil.getProperty("auth_url") + VERSION + "/" + account + CommonUtil.getProperty("auth_url_post") : CommonUtil.getProperty("auth_url");
    }

    public boolean login() throws IOException, HttpException {
        GetMethod method = new GetMethod(this.authenticationURL);
        method.getParams().setSoTimeout(this.connectionTimeOut);
        method.setRequestHeader(CommonUtil.getProperty("auth_user_header", "x-auth-user"), this.username);
        method.setRequestHeader(CommonUtil.getProperty("auth_pass_header", "x-auth-key"), this.password);
        logger.debug((Object)("Logging in user: " + this.username + " using URL: " + this.authenticationURL));
        this.client.executeMethod((HttpMethod)method);
        Response response = new Response((HttpMethod)method);
        if (response.loginSuccess()) {
            this.isLoggedin = true;
            this.serverMgmntURL = response.getServerManagementURL();
            this.authToken = response.getAuthToken();
            logger.debug((Object)("authToken: " + this.authToken));
            logger.debug((Object)("ConnectionManager:" + this.client.getHttpConnectionManager()));
        }
        method.releaseConnection();
        return this.isLoggedin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createServer(String serverName, String imageId, String flavorId) throws IOException, HttpException, ServersAuthorizationException, ServersException {
        block11: {
            int status = -1;
            if (this.isLoggedin()) {
                if (this.isValidServerName(serverName)) {
                    PostMethod method = new PostMethod(this.serverMgmntURL + "/servers");
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    String reqBody = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><server xmlns=\"http://docs.rackspacecloud.com/servers/api/v1.0\" name=\"" + serverName + "\" imageId=\"" + imageId + "\" flavorId=\"" + flavorId + "\">" + "</server>";
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(reqBody.getBytes("UTF-8"));
                    method.setRequestHeader("Content-type", "text/xml; charset=utf-8");
                    method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)byteStream));
                    try {
                        status = this.client.executeMethod((HttpMethod)method);
                        Response response = new Response((HttpMethod)method);
                        if (response.getStatusCode() == 401) {
                            method.releaseConnection();
                            if (this.login()) {
                                method = new PostMethod(this.serverMgmntURL + "/servers");
                                method.getParams().setSoTimeout(this.connectionTimeOut);
                                method.setRequestHeader("X-Auth-Token", this.authToken);
                                method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)byteStream));
                                status = this.client.executeMethod((HttpMethod)method);
                                response = new Response((HttpMethod)method);
                            } else {
                                throw new ServersAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                            }
                        }
                        if (response.getStatusCode() == 201) {
                            return;
                        }
                        if (response.getStatusCode() != 202) {
                            throw new ServersException("Unexpected Response", response.getResponseHeaders(), response.getStatusLine());
                        }
                        break block11;
                    }
                    finally {
                        method.releaseConnection();
                    }
                }
                throw new ServersInvalidNameException(serverName);
            }
            throw new ServersAuthorizationException("You must be logged in", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteServer(String serverId) throws IOException, HttpException, ServersAuthorizationException, ServersInvalidNameException, ServersNotFoundException {
        block11: {
            if (this.isLoggedin()) {
                DeleteMethod method = new DeleteMethod(this.serverMgmntURL + "/servers/" + CommonUtil.sanitizeForURI(serverId));
                try {
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    this.client.executeMethod((HttpMethod)method);
                    Response response = new Response((HttpMethod)method);
                    if (response.getStatusCode() == 401) {
                        method.releaseConnection();
                        if (this.login()) {
                            method = new DeleteMethod(this.serverMgmntURL + "/servers/" + serverId);
                            method.getParams().setSoTimeout(this.connectionTimeOut);
                            method.setRequestHeader("X-Auth-Token", this.authToken);
                            this.client.executeMethod((HttpMethod)method);
                            response = new Response((HttpMethod)method);
                        } else {
                            throw new ServersAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                        }
                    }
                    if (response.getStatusCode() == 204 || response.getStatusCode() == 202) {
                        logger.debug((Object)("Server Deleted : " + serverId));
                        boolean bl = true;
                        return bl;
                    }
                    if (response.getStatusCode() == 404) {
                        logger.debug((Object)"Server does not exist !");
                        throw new ServersNotFoundException("Server does not exist", response.getResponseHeaders(), response.getStatusLine());
                    }
                    if (response.getStatusCode() == 409) {
                        String msg = "Server status does not allow deleting.  Please try again a few moments later.";
                        logger.debug((Object)msg);
                        throw new ServersNotFoundException(msg, response.getResponseHeaders(), response.getStatusLine());
                    }
                    break block11;
                }
                finally {
                    method.releaseConnection();
                }
            }
            throw new ServersAuthorizationException("You must be logged in", null, null);
        }
        return false;
    }

    public List<ServersServerInfo> listServerDetails() throws IOException, HttpException, ServersException {
        ArrayList<ServersServerInfo> rtn;
        block25: {
            String serverId = null;
            String serverName = null;
            String publicIpAddr = null;
            String privateIpAddr = null;
            String imageId = null;
            String flavorId = null;
            String status = null;
            String hostId = null;
            rtn = null;
            if (!this.isLoggedin()) {
                throw new ServersAuthorizationException("You must be logged in", null, null);
            }
            GetMethod method = null;
            try {
                method = new GetMethod(this.serverMgmntURL + "/servers/detail.xml");
                method.getParams().setSoTimeout(this.connectionTimeOut);
                method.setRequestHeader("X-Auth-Token", this.authToken);
                this.client.executeMethod((HttpMethod)method);
                Response response = new Response((HttpMethod)method);
                if (response.getStatusCode() == 401) {
                    method.releaseConnection();
                    if (this.login()) {
                        method = new GetMethod(this.serverMgmntURL);
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        this.client.executeMethod((HttpMethod)method);
                        response = new Response((HttpMethod)method);
                    } else {
                        throw new ServersAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                    }
                }
                if (response.getStatusCode() == 200 || response.getStatusCode() == 203) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(response.getResponseBodyAsStream());
                    NodeList nodes = document.getChildNodes();
                    Node serversNode = nodes.item(0);
                    if (!"servers".equals(serversNode.getNodeName())) {
                        logger.error((Object)"Got unexpected type of XML");
                        List<ServersServerInfo> list = null;
                        return list;
                    }
                    nodes = serversNode.getChildNodes();
                    rtn = new ArrayList<ServersServerInfo>();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node serverNode = nodes.item(i);
                        if (!"server".equals(serverNode.getNodeName())) {
                            logger.error((Object)"Got unexpected type of XML");
                            List<ServersServerInfo> list = null;
                            return list;
                        }
                        NamedNodeMap serverMap = serverNode.getAttributes();
                        if (serverMap.getNamedItem("id") != null) {
                            serverId = serverMap.getNamedItem("id").getNodeValue();
                        }
                        if (serverMap.getNamedItem("name") != null) {
                            serverName = serverMap.getNamedItem("name").getNodeValue();
                        }
                        if (serverMap.getNamedItem("imageId") != null) {
                            imageId = serverMap.getNamedItem("imageId").getNodeValue();
                        }
                        if (serverMap.getNamedItem("flavorId") != null) {
                            flavorId = serverMap.getNamedItem("flavorId").getNodeValue();
                        }
                        if (serverMap.getNamedItem("status") != null) {
                            status = serverMap.getNamedItem("status").getNodeValue();
                        }
                        if (serverMap.getNamedItem("hostId") != null) {
                            hostId = serverMap.getNamedItem("hostId").getNodeValue();
                        }
                        NodeList nodeList = serverNode.getChildNodes();
                        Node addrNode = nodeList.item(1);
                        nodeList = addrNode.getChildNodes();
                        Node publicNode = nodeList.item(0);
                        Node privateNode = nodeList.item(1);
                        nodeList = publicNode.getChildNodes();
                        Node publicIpNode = nodeList.item(0);
                        NamedNodeMap publicIpNodeMap = publicIpNode.getAttributes();
                        publicIpAddr = publicIpNodeMap.getNamedItem("addr").getNodeValue();
                        nodeList = privateNode.getChildNodes();
                        Node privateIpNode = nodeList.item(0);
                        NamedNodeMap privateIpNodeMap = privateIpNode.getAttributes();
                        privateIpAddr = privateIpNodeMap.getNamedItem("addr").getNodeValue();
                        ServersServerInfo sinfo = new ServersServerInfo(serverId, serverName, imageId, flavorId, status, hostId, publicIpAddr, privateIpAddr, null);
                        rtn.add(sinfo);
                    }
                    break block25;
                }
                if (response.getStatusCode() == 404) {
                    throw new ServersNotFoundException("Account was not found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new ServersException("Unexpected resposne from server", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (SAXException ex) {
                throw new ServersException("Problem parsing XML", ex);
            }
            catch (ParserConfigurationException ex) {
                throw new ServersException("Problem parsing XML", ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServersException(ex.toString(), ex);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return rtn;
    }

    public Collection<CloudImage> listImages() throws IOException, HttpException, ServersException {
        ArrayList<CloudImage> rtn;
        block22: {
            String id = null;
            String name = null;
            String description = null;
            String cpuCount = null;
            String memory = null;
            String osStorage = null;
            String extraStorage = null;
            String OS = null;
            String created = null;
            rtn = null;
            if (!this.isLoggedin()) {
                throw new ServersAuthorizationException("You must be logged in", null, null);
            }
            GetMethod method = null;
            try {
                method = new GetMethod(this.serverMgmntURL + "/images/detail.xml");
                method.getParams().setSoTimeout(this.connectionTimeOut);
                method.setRequestHeader("X-Auth-Token", this.authToken);
                this.client.executeMethod((HttpMethod)method);
                Response response = new Response((HttpMethod)method);
                if (response.getStatusCode() == 401) {
                    method.releaseConnection();
                    if (this.login()) {
                        method = new GetMethod(this.serverMgmntURL);
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        this.client.executeMethod((HttpMethod)method);
                        response = new Response((HttpMethod)method);
                    } else {
                        throw new ServersAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                    }
                }
                if (response.getStatusCode() == 200 || response.getStatusCode() == 203) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(response.getResponseBodyAsStream());
                    NodeList nodes = document.getChildNodes();
                    Node serversNode = nodes.item(0);
                    if (!"images".equals(serversNode.getNodeName())) {
                        logger.error((Object)"Got unexpected type of XML");
                        Collection<CloudImage> collection = null;
                        return collection;
                    }
                    nodes = serversNode.getChildNodes();
                    rtn = new ArrayList<CloudImage>();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node imageNode = nodes.item(i);
                        if (!"image".equals(imageNode.getNodeName())) {
                            logger.error((Object)"Got unexpected type of XML");
                            Collection<CloudImage> collection = null;
                            return collection;
                        }
                        NamedNodeMap imageMap = imageNode.getAttributes();
                        if (imageMap.getNamedItem("id") != null) {
                            id = imageMap.getNamedItem("id").getNodeValue();
                        }
                        if (imageMap.getNamedItem("name") != null) {
                            name = imageMap.getNamedItem("name").getNodeValue();
                        }
                        if (imageMap.getNamedItem("created") != null) {
                            created = imageMap.getNamedItem("created").getNodeValue();
                        }
                        CloudImage image = new CloudImage(id, name, description, cpuCount, osStorage, memory, extraStorage, OS, created);
                        rtn.add(image);
                    }
                    break block22;
                }
                if (response.getStatusCode() == 404) {
                    throw new ServersNotFoundException("Account was not found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new ServersException("Unexpected resposne from server", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (SAXException ex) {
                throw new ServersException("Problem parsing XML", ex);
            }
            catch (ParserConfigurationException ex) {
                throw new ServersException("Problem parsing XML", ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServersException(ex.toString(), ex);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return rtn;
    }

    public Collection<CloudFlavor> listFlavors() throws IOException, HttpException, ServersException {
        ArrayList<CloudFlavor> rtn;
        block23: {
            String id = null;
            String name = null;
            String description = null;
            String memory = null;
            String osStorage = null;
            String extraStorage = null;
            rtn = null;
            if (!this.isLoggedin()) {
                throw new ServersAuthorizationException("You must be logged in", null, null);
            }
            GetMethod method = null;
            try {
                method = new GetMethod(this.serverMgmntURL + "/flavors/detail.xml");
                method.getParams().setSoTimeout(this.connectionTimeOut);
                method.setRequestHeader("X-Auth-Token", this.authToken);
                this.client.executeMethod((HttpMethod)method);
                Response response = new Response((HttpMethod)method);
                if (response.getStatusCode() == 401) {
                    method.releaseConnection();
                    if (this.login()) {
                        method = new GetMethod(this.serverMgmntURL);
                        method.getParams().setSoTimeout(this.connectionTimeOut);
                        method.setRequestHeader("X-Auth-Token", this.authToken);
                        this.client.executeMethod((HttpMethod)method);
                        response = new Response((HttpMethod)method);
                    } else {
                        throw new ServersAuthorizationException("Re-login failed", response.getResponseHeaders(), response.getStatusLine());
                    }
                }
                if (response.getStatusCode() == 200 || response.getStatusCode() == 203) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(response.getResponseBodyAsStream());
                    NodeList nodes = document.getChildNodes();
                    Node flavorsNode = nodes.item(0);
                    if (!"flavors".equals(flavorsNode.getNodeName())) {
                        logger.error((Object)"Got unexpected type of XML");
                        Collection<CloudFlavor> collection = null;
                        return collection;
                    }
                    nodes = flavorsNode.getChildNodes();
                    rtn = new ArrayList<CloudFlavor>();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node flavorNode = nodes.item(i);
                        if (!"flavor".equals(flavorNode.getNodeName())) {
                            logger.error((Object)"Got unexpected type of XML");
                            Collection<CloudFlavor> collection = null;
                            return collection;
                        }
                        NamedNodeMap flavorMap = flavorNode.getAttributes();
                        if (flavorMap.getNamedItem("id") != null) {
                            id = flavorMap.getNamedItem("id").getNodeValue();
                        }
                        if (flavorMap.getNamedItem("name") != null) {
                            name = flavorMap.getNamedItem("name").getNodeValue();
                        }
                        if (flavorMap.getNamedItem("ram") != null) {
                            memory = flavorMap.getNamedItem("ram").getNodeValue();
                        }
                        if (flavorMap.getNamedItem("disk") != null) {
                            osStorage = flavorMap.getNamedItem("disk").getNodeValue();
                        }
                        extraStorage = null;
                        CloudFlavor flavor = new CloudFlavor(id, name, description, osStorage, memory, extraStorage);
                        rtn.add(flavor);
                    }
                    break block23;
                }
                if (response.getStatusCode() == 404) {
                    throw new ServersNotFoundException("Account was not found", response.getResponseHeaders(), response.getStatusLine());
                }
                throw new ServersException("Unexpected resposne from server", response.getResponseHeaders(), response.getStatusLine());
            }
            catch (SAXException ex) {
                throw new ServersException("Problem parsing XML", ex);
            }
            catch (ParserConfigurationException ex) {
                throw new ServersException("Problem parsing XML", ex);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServersException(ex.toString(), ex);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return rtn;
    }

    public ServersServerInfo getServerInfo(String serverId) throws IOException, HttpException, ServersException {
        ServersServerInfo rtn;
        block17: {
            String serverName = null;
            String publicIpAddr = null;
            String privateIpAddr = null;
            String imageId = null;
            String flavorId = null;
            String status = null;
            String hostId = null;
            rtn = null;
            if (this.isLoggedin()) {
                HeadMethod method = null;
                try {
                    method = new HeadMethod(this.serverMgmntURL + "/" + CommonUtil.sanitizeForURI(serverId) + ".xml");
                    method.getParams().setSoTimeout(this.connectionTimeOut);
                    method.setRequestHeader("X-Auth-Token", this.authToken);
                    this.client.executeMethod((HttpMethod)method);
                    Response response = new Response((HttpMethod)method);
                    if (response.getStatusCode() == 200) {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document document = builder.parse(response.getResponseBodyAsStream());
                        NodeList nodes = document.getChildNodes();
                        Node serverNode = nodes.item(0);
                        if (!"server".equals(serverNode.getNodeName())) {
                            logger.error((Object)"Got unexpected type of XML");
                            ServersServerInfo serversServerInfo = null;
                            return serversServerInfo;
                        }
                        NamedNodeMap serverMap = serverNode.getAttributes();
                        if (serverMap.getNamedItem("name") != null) {
                            serverName = serverMap.getNamedItem("name").getNodeValue();
                        }
                        if (serverMap.getNamedItem("imageId") != null) {
                            imageId = serverMap.getNamedItem("imageId").getNodeValue();
                        }
                        if (serverMap.getNamedItem("flavorId") != null) {
                            flavorId = serverMap.getNamedItem("flavorId").getNodeValue();
                        }
                        if (serverMap.getNamedItem("status") != null) {
                            status = serverMap.getNamedItem("status").getNodeValue();
                        }
                        if (serverMap.getNamedItem("hostId") != null) {
                            hostId = serverMap.getNamedItem("hostId").getNodeValue();
                        }
                        NodeList nodeList = serverNode.getChildNodes();
                        Node addrNode = nodeList.item(1);
                        nodeList = addrNode.getChildNodes();
                        Node publicNode = nodeList.item(0);
                        Node privateNode = nodeList.item(1);
                        nodeList = publicNode.getChildNodes();
                        Node publicIpNode = nodeList.item(0);
                        NamedNodeMap publicIpNodeMap = publicIpNode.getAttributes();
                        publicIpAddr = publicIpNodeMap.getNamedItem("addr").getNodeValue();
                        nodeList = privateNode.getChildNodes();
                        Node privateIpNode = nodeList.item(0);
                        NamedNodeMap privateIpNodeMap = privateIpNode.getAttributes();
                        privateIpAddr = privateIpNodeMap.getNamedItem("addr").getNodeValue();
                        rtn = new ServersServerInfo(serverId, serverName, imageId, flavorId, status, hostId, publicIpAddr, privateIpAddr, null);
                        break block17;
                    }
                    if (response.getStatusCode() == 401) {
                        logger.warn((Object)"Unauthorized access");
                        throw new ServersAuthorizationException("User not Authorized!", response.getResponseHeaders(), response.getStatusLine());
                    }
                    throw new ServersException("Unexpected server response", response.getResponseHeaders(), response.getStatusLine());
                }
                catch (SAXException ex) {
                    throw new ServersException("Problem parsing XML", ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new ServersException("Problem parsing XML", ex);
                }
                finally {
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
            }
            throw new ServersAuthorizationException("You must be logged in", null, null);
        }
        return rtn;
    }

    public String getServerManagementURL() {
        return this.serverMgmntURL;
    }

    public boolean isLoggedin() {
        return this.isLoggedin;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserAgent(String userAgent) {
        this.client.getParams().setParameter("http.useragent", (Object)userAgent);
    }

    private boolean isValidServerName(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        if (length == 0 || length > 256) {
            return false;
        }
        return name.indexOf(47) == -1;
    }
}

