/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.config;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.tools.project.StudioConfiguration;
import com.wavemaker.tools.project.VersionInfo;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationStore {
    protected static final String VERSIONED_KEY = "wm_versioned";

    public static void removePreference(Class<?> klass, String key) {
        Preferences.userNodeForPackage(klass).remove(key);
        try {
            ConfigurationStore.getRootVersionedNode(klass, key).removeNode();
        }
        catch (BackingStoreException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    public static String getPreference(Class<?> klass, String key, String defaultValue) {
        return ConfigurationStore.getLessThanEqualVersionedNode(klass, key).get(key, defaultValue);
    }

    public static boolean getPreferenceBoolean(Class<?> klass, String key, boolean defaultValue) {
        return ConfigurationStore.getLessThanEqualVersionedNode(klass, key).getBoolean(key, defaultValue);
    }

    public static int getPreferenceInt(Class<?> klass, String key, int defaultValue) {
        return ConfigurationStore.getLessThanEqualVersionedNode(klass, key).getInt(key, defaultValue);
    }

    public static void setPreference(Class<?> klass, String key, String value) {
        Preferences.userNodeForPackage(klass).put(key, value);
    }

    public static void setPreferenceBoolean(Class<?> klass, String key, boolean value) {
        Preferences.userNodeForPackage(klass).putBoolean(key, value);
    }

    public static void setPreferenceInt(Class<?> klass, String key, int value) {
        Preferences.userNodeForPackage(klass).putInt(key, value);
    }

    public static void setVersionedPreference(Class<?> klass, String key, String value) {
        ConfigurationStore.getExactVersionedNode(klass, key).put(key, value);
    }

    public static void setVersionedPreferenceBoolean(Class<?> klass, String key, boolean value) {
        ConfigurationStore.getExactVersionedNode(klass, key).putBoolean(key, value);
    }

    public static void setVersionedPreferenceInt(Class<?> klass, String key, int value) {
        ConfigurationStore.getExactVersionedNode(klass, key).putInt(key, value);
    }

    protected static Preferences getRootVersionedNode(Class<?> klass, String key) {
        Preferences p = Preferences.userNodeForPackage(klass);
        return p.node("wm_versioned__" + key);
    }

    protected static Preferences getLessThanEqualVersionedNode(Class<?> klass, String key) {
        try {
            return ConfigurationStore.getLessThanEqualVersionedNode(klass, key, StudioConfiguration.getCurrentVersionInfo());
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    protected static Preferences getLessThanEqualVersionedNode(Class<?> klass, String key, VersionInfo version) {
        try {
            Preferences p = ConfigurationStore.getRootVersionedNode(klass, key);
            VersionInfo currentStudioVersion = version;
            VersionInfo currentPrefVersion = null;
            for (String name : p.childrenNames()) {
                VersionInfo vi;
                try {
                    vi = new VersionInfo(name);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (StringIndexOutOfBoundsException e) {
                    continue;
                }
                if (vi.compareTo(currentStudioVersion) > 0 || null != currentPrefVersion && currentPrefVersion.compareTo(vi) >= 0) continue;
                currentPrefVersion = vi;
            }
            if (null != currentPrefVersion) {
                return p.node(currentPrefVersion.toString());
            }
            return Preferences.userNodeForPackage(klass);
        }
        catch (BackingStoreException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    protected static Preferences getExactVersionedNode(Class<?> klass, String key) {
        try {
            return ConfigurationStore.getExactVersionedNode(klass, key, StudioConfiguration.getCurrentVersionInfo());
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
    }

    protected static Preferences getExactVersionedNode(Class<?> klass, String key, VersionInfo version) {
        Preferences p = ConfigurationStore.getRootVersionedNode(klass, key);
        return p.node(version.toString());
    }
}

