/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.runtime.data.dialect.MySQLDialect;
import com.wavemaker.runtime.data.util.JDBCUtils;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.DataServiceLoggers;
import com.wavemaker.tools.data.HibernateSpringConfigExporter;
import com.wavemaker.tools.data.WMHibernateToolTask;
import com.wavemaker.tools.data.reveng.DefaultRevengNamingStrategy;
import com.wavemaker.tools.data.reveng.MSSQLRevengNamingStrategy;
import com.wavemaker.tools.data.util.DataServiceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.GenericExporterTask;
import org.hibernate.tool.hbm2x.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDataModelSetup {
    private static final String JDBC_URL_SCHEME = "jdbc:";
    private static final String HSQL_DB_TYPE = "hsql";
    private static final String MYSQL_DB_TYPE = "mysql";
    private static final String ORACLE_DB_TYPE = "oracle";
    private static final String SQL_SERVER_DB_TYPE = "sqlserver";
    private static final String SQL_SERVER_URL_SCHEME = "jtds:";
    private static final String DB2_DB_TYPE = "db2";
    private static final String POSTGRESQL_DB_TYPE = "postgresql";
    private static final String DEFAULT_DB_TYPE = "mysql";
    private static final String DEFAULT_HOST_PORT = "://localhost:3306";
    private static final String TABLE_FILTER_SEP = ",";
    private static final String SCHEMA_FILTER_SEP = ",";
    protected static final Map<String, Class<?>> DB_TYPES_TO_DIALECTS = new HashMap(6);
    protected static final Map<String, String> DB_TYPES_TO_DRIVER_CLASSES = new HashMap<String, String>(6);
    protected static final String SYSTEM_PROPERTY_PREFIX = "wm.importdb.";
    protected static final String USER_SYSTEM_PROPERTY;
    protected static final String PASS_SYSTEM_PROPERTY;
    protected static final String CONNECTION_URL_SYSTEM_PROPERTY;
    protected static final String DRIVER_CLASS_NAME_SYSTEM_PROPERTY;
    protected static final String DBTYPE_SYSTEM_PROPERTY = "wm.importdb.dbtype";
    protected static final String HIBERNATE_DIALECT_SYSTEM_PROPERTY = "hibernate.dialect";
    protected static final String NAME_SYSTEM_PROPERTY = "wm.importdb.serviceName";
    protected static final String PACKAGE_SYSTEM_PROPERTY = "wm.importdb.package";
    protected static final String DATA_PACKAGE_SYSTEM_PROPERTY = "wm.importdb.dataPackage";
    protected static final String DESTDIR_SYSTEM_PROPERTY = "wm.importdb.outputDir";
    protected static final String TABLE_FILTER_SYSTEM_PROPERTY = "wm.importdb.tableFilter";
    protected static final String SCHEMA_FILTER_SYSTEM_PROPERTY = "wm.importdb.schemaFilter";
    private static final String REVENG_NAMING_STRATEGY_SYSTEM_PROPERTY = "wm.importdb.revengNamingStrategy";
    private String DEFAULT_FILTER = ".*";
    private final WMHibernateToolTask parentTask = new WMHibernateToolTask();
    private final Project project;
    protected String serviceName = null;
    protected String driverClassName = null;
    protected String connectionUrl = null;
    protected String username = null;
    protected String password = null;
    protected String catalogName = null;
    protected String dbtype = null;
    protected String dialect = null;
    protected String className = null;
    protected List<String> tableFilters = new ArrayList<String>();
    protected List<String> schemaFilters = new ArrayList<String>();
    protected String revengNamingStrategy = null;
    protected String packageName = null;
    protected String dataPackage = null;
    protected File destdir = null;
    protected File javadir = null;
    protected Properties properties = new Properties();
    protected boolean initialized = false;
    private List<File> tmpFiles = new ArrayList<File>();

    private static String strip(String s) {
        return StringUtils.fromFirstOccurrence((String)s, (String)".");
    }

    public static String getDriverClassForDBType(String dbtype) {
        return DB_TYPES_TO_DRIVER_CLASSES.get(dbtype);
    }

    public static String getDialectForDBType(String dbtype) {
        return DB_TYPES_TO_DIALECTS.get(dbtype).getName();
    }

    public static String getDBTypeFromURL(String url) {
        if (!url.startsWith(JDBC_URL_SCHEME)) {
            throw new IllegalArgumentException("jdbc url must start with jdbc:");
        }
        String dbtype = url.substring(JDBC_URL_SCHEME.length()).toLowerCase();
        if (dbtype.startsWith(SQL_SERVER_URL_SCHEME)) {
            return SQL_SERVER_DB_TYPE;
        }
        for (String t : DB_TYPES_TO_DIALECTS.keySet()) {
            if (!dbtype.startsWith(t.toLowerCase())) continue;
            return t;
        }
        return null;
    }

    public BaseDataModelSetup() {
        this(new Project());
    }

    public BaseDataModelSetup(Project project) {
        this.project = project;
    }

    public void setDestDir(File destdir) {
        this.destdir = destdir;
        this.getParentTask().setDestDir(destdir);
    }

    public void setJavaDir(File javadir) {
        this.javadir = javadir;
    }

    public void setDefaultDBType() {
        this.setDBType("mysql");
        this.setConnectionUrl("jdbc:mysql://localhost:3306");
        this.setDriverClassName(BaseDataModelSetup.getDriverClassForDBType("mysql"));
        this.setDialect(BaseDataModelSetup.getDialectForDBType("mysql"));
    }

    public void addSchemaFilter(String schemaFilter) {
        this.schemaFilters.add(schemaFilter);
    }

    public void setSchemaFilters(List<String> schemaFilters) {
        this.schemaFilters = schemaFilters;
    }

    public void addTableFilter(String tableFilter) {
        this.tableFilters.add(tableFilter);
    }

    public void setTableFilters(List<String> tableFilter) {
        this.tableFilters = tableFilter;
    }

    public void setTableFilter(String tableFilter) {
        this.tableFilters = new ArrayList<String>(1);
        this.tableFilters.add(tableFilter);
    }

    public void setTableFilterSplit(String tableFilter) {
        if (tableFilter != null) {
            for (String s : tableFilter.split(",")) {
                this.addTableFilter(s.trim());
            }
        }
    }

    public void setSchemaFilterSplit(String schemaFilter) {
        if (schemaFilter != null) {
            for (String s : schemaFilter.split(",")) {
                this.addSchemaFilter(s.trim());
            }
        }
    }

    public String getTableFilter() {
        return ObjectUtils.toString(this.tableFilters, (String)",");
    }

    public String getSchemaFilter() {
        return ObjectUtils.toString(this.schemaFilters, (String)",");
    }

    public void setRevengNamingStrategy(Class<?> revengNamingStrategy) {
        this.revengNamingStrategy = revengNamingStrategy.getName();
    }

    public void setRevengNamingStrategy(String revengNamingStrategy) {
        this.revengNamingStrategy = revengNamingStrategy;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setPassword(String password) {
        if (SystemUtils.isEncrypted((String)password)) {
            password = SystemUtils.decrypt((String)password);
        }
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setDBType(String dbtype) {
        this.dbtype = dbtype;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public String getPackage() {
        return this.packageName;
    }

    public void setDataPackage(String dataPackage) {
        this.dataPackage = dataPackage;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    protected Project getProject() {
        return this.project;
    }

    public void setProperties(Properties additionalProperties) {
        this.properties.putAll((Map<?, ?>)additionalProperties);
    }

    protected void registerTmpFileForCleanup(File f) {
        f.deleteOnExit();
        this.tmpFiles.add(f);
    }

    protected abstract boolean customInit(Collection<String> var1);

    protected abstract void customRun();

    protected abstract void customDispose();

    public boolean init() {
        HashSet<String> requiredProperties = new HashSet<String>();
        boolean rtn = this.customInit(requiredProperties);
        this.checkProperties(requiredProperties);
        this.initialized = true;
        return rtn;
    }

    public void run() {
        boolean ok;
        if (!this.initialized && !(ok = this.init())) {
            return;
        }
        this.parentTask.setConfiguration(new Configuration());
        this.parentTask.setProject(this.project);
        this.customRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.customDispose();
        }
        finally {
            for (File f : this.tmpFiles) {
                try {
                    f.delete();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void runDDL(String sql) {
        this.runDDL(sql, this.connectionUrl);
    }

    protected void runDDL(String sql, String url) {
        JDBCUtils.runSql(new String[]{sql}, url, this.username, this.password, this.driverClassName, DataServiceLoggers.importLogger, true);
    }

    public Properties getProperties() {
        return this.getProperties(true);
    }

    private Properties getProperties(boolean strip) {
        Properties p = new Properties();
        p.put(".username", this.username);
        p.put(".password", this.password);
        p.put(".connectionUrl", this.connectionUrl);
        p.put(".driverClassName", this.driverClassName);
        p.put(".dialect", this.dialect);
        String s = this.getTableFilter();
        if (ObjectUtils.isNullOrEmpty((String)s)) {
            s = this.DEFAULT_FILTER;
        }
        p.setProperty(".tableFilter", s);
        s = this.getSchemaFilter();
        if (ObjectUtils.isNullOrEmpty((String)s)) {
            s = this.DEFAULT_FILTER;
        }
        p.setProperty(".schemaFilter", s);
        p.setProperty(".reverseNamingStrategy", this.revengNamingStrategy == null ? "" : this.revengNamingStrategy);
        Properties rtn = null;
        if (strip) {
            rtn = new Properties();
            for (String string : p.keySet()) {
                String value = p.getProperty(string);
                rtn.setProperty(BaseDataModelSetup.strip(string), value);
            }
        } else {
            rtn = p;
        }
        return rtn;
    }

    protected Properties getHibernateConnectionProperties() {
        Properties rtn = com.wavemaker.runtime.data.util.DataServiceUtils.toHibernateConnectionProperties(this.getProperties(false));
        if (DataServiceLoggers.importLogger.isInfoEnabled()) {
            DataServiceLoggers.importLogger.info((Object)("Connection properties: " + rtn));
        }
        return rtn;
    }

    protected void checkDialectAndDBType(Collection<String> requiredProperties) {
        if (this.dbtype == null && this.dialect == null) {
            return;
        }
        if (this.dbtype != null && this.dialect == null) {
            Class<?> c = DB_TYPES_TO_DIALECTS.get(this.dbtype);
            if (c == null) {
                throw new ConfigurationException("Unknown dbtype \"" + this.dbtype + "\", cannot determine dialect");
            }
            this.dialect = c.getName();
        } else if (this.dbtype == null && this.dialect != null) {
            String s = this.dialect.toLowerCase();
            s = StringUtils.fromLastOccurrence((String)s, (String)"dialect", (int)-1);
            this.dbtype = StringUtils.fromLastOccurrence((String)s, (String)".");
        }
    }

    protected void checkTableFilter() {
        String s;
        if (this.tableFilters.isEmpty() && (s = this.properties.getProperty(TABLE_FILTER_SYSTEM_PROPERTY)) != null) {
            this.setTableFilterSplit(s);
        }
    }

    protected void checkSchemaFilter() {
        String s;
        if (this.schemaFilters.isEmpty() && (s = this.properties.getProperty(SCHEMA_FILTER_SYSTEM_PROPERTY)) != null) {
            this.setSchemaFilterSplit(s);
        }
    }

    protected void checkRevengNamingStrategy() {
        if (this.revengNamingStrategy == null) {
            this.revengNamingStrategy = this.properties.getProperty(REVENG_NAMING_STRATEGY_SYSTEM_PROPERTY);
            if (this.revengNamingStrategy == null) {
                if (this.dialect != null && this.dialect.contains("SQLServer")) {
                    this.setRevengNamingStrategy(this.getMSSQLRevengNamingStrategy());
                } else {
                    this.setRevengNamingStrategy(this.getDefaultRevengNamingStrategy());
                }
            }
        }
    }

    private Class<?> getDefaultRevengNamingStrategy() {
        return DefaultRevengNamingStrategy.class;
    }

    private Class<?> getMSSQLRevengNamingStrategy() {
        return MSSQLRevengNamingStrategy.class;
    }

    protected void checkTables(Configuration cfg) {
        Iterator iter = cfg.getClassMappings();
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            iter.next();
        }
        if (i == 0) {
            throw new ConfigurationException("No matching tables found for table filter \"" + this.tableFilters + "\" and schema filter \"" + this.schemaFilters + "\"");
        }
    }

    protected void checkDialect(Collection<String> requiredProperties, boolean isFatal) {
        String s;
        if (this.dialect == null && (s = this.properties.getProperty(HIBERNATE_DIALECT_SYSTEM_PROPERTY)) != null) {
            this.setDialect(s);
        }
        if (this.dialect == null && isFatal) {
            requiredProperties.add(HIBERNATE_DIALECT_SYSTEM_PROPERTY);
        }
    }

    protected void checkDBType() {
        if (this.dbtype == null) {
            String s = this.properties.getProperty(DBTYPE_SYSTEM_PROPERTY);
            if (s == null && this.connectionUrl != null) {
                s = BaseDataModelSetup.getDBTypeFromURL(this.connectionUrl);
            }
            if (s != null) {
                this.setDBType(s);
            }
        }
    }

    protected void checkUser(Collection<String> requiredProperties) {
        if (this.username == null) {
            String s = this.properties.getProperty(USER_SYSTEM_PROPERTY);
            if (s == null) {
                s = this.properties.getProperty("hibernate.connection.username");
            }
            if (s == null) {
                s = "";
            }
            this.setUsername(s);
        }
    }

    protected void checkPass(Collection<String> requiredProperties) {
        if (this.password == null) {
            String s = this.properties.getProperty(PASS_SYSTEM_PROPERTY);
            if (s == null) {
                s = this.properties.getProperty("hibernate.connection.password");
            }
            if (s == null) {
                s = "";
            }
            this.setPassword(s);
        }
    }

    protected void checkDriverClass(Collection<String> requiredProperties) {
        if (this.driverClassName == null) {
            String s = this.properties.getProperty(DRIVER_CLASS_NAME_SYSTEM_PROPERTY);
            if (s == null) {
                s = this.properties.getProperty("hibernate.connection.driver_class");
            }
            if (s != null) {
                this.setDriverClassName(s);
            }
        }
        if (this.driverClassName == null) {
            this.setDriverClassName(DB_TYPES_TO_DRIVER_CLASSES.get(this.dbtype));
        }
        if (this.driverClassName == null) {
            requiredProperties.add(DRIVER_CLASS_NAME_SYSTEM_PROPERTY);
        }
    }

    protected void checkAlternateConnectionProperties() {
        if (!SystemUtils.allPropertiesAreSet((Properties)this.properties, (String[])new String[]{USER_SYSTEM_PROPERTY, CONNECTION_URL_SYSTEM_PROPERTY, DRIVER_CLASS_NAME_SYSTEM_PROPERTY})) {
            Properties p = com.wavemaker.runtime.data.util.DataServiceUtils.toHibernateConnectionProperties(this.properties);
            this.properties.putAll((Map<?, ?>)p);
        }
    }

    protected void checkUrl(Collection<String> requiredProperties) {
        if (this.connectionUrl == null) {
            String s = this.properties.getProperty(CONNECTION_URL_SYSTEM_PROPERTY);
            if (s == null) {
                s = this.properties.getProperty("hibernate.connection.url");
            }
            if (s != null) {
                this.setConnectionUrl(s);
            }
        }
        if (this.connectionUrl == null) {
            requiredProperties.add(CONNECTION_URL_SYSTEM_PROPERTY);
        }
    }

    protected void checkCatalogName() {
        int i;
        if (this.catalogName != null && this.dbtype == "mysql" && (i = this.connectionUrl.indexOf(this.catalogName)) == -1) {
            int l;
            int k;
            String newUrl = this.connectionUrl;
            String props = "";
            int j = this.connectionUrl.indexOf(";");
            if (j > -1) {
                props = this.connectionUrl.substring(j);
                newUrl = this.connectionUrl.substring(0, j);
            }
            if ((k = this.connectionUrl.lastIndexOf("//")) != (l = this.connectionUrl.lastIndexOf("/")) - 1) {
                newUrl = newUrl.substring(0, l);
            }
            this.connectionUrl = newUrl = newUrl + "/" + this.catalogName + props;
            if (DataServiceLoggers.importLogger.isInfoEnabled()) {
                DataServiceLoggers.importLogger.info((Object)("Added catalog to connection url: " + this.connectionUrl));
            }
        }
    }

    protected void checkServiceName(boolean fatal, Collection<String> requiredProperties) {
        String s;
        if (this.serviceName == null && (s = this.properties.getProperty(NAME_SYSTEM_PROPERTY)) != null) {
            this.setServiceName(s);
        }
        if (this.serviceName == null && this.className != null) {
            this.setServiceName(StringUtils.lowerCaseFirstLetter((String)this.className));
        }
        if (this.serviceName == null) {
            if (fatal) {
                requiredProperties.add(NAME_SYSTEM_PROPERTY);
            }
        } else {
            if (this.serviceName.indexOf(".") > -1) {
                throw new ConfigurationException("servicename cannot contain '.': " + this.serviceName);
            }
            if (this.serviceName.indexOf(" ") > -1) {
                throw new ConfigurationException("servicename cannot contain spaces");
            }
        }
    }

    protected void checkDestdir(Collection<String> requiredProperties) {
        String s;
        if (this.destdir == null && (s = this.properties.getProperty(DESTDIR_SYSTEM_PROPERTY)) != null) {
            this.setDestDir(new File(s));
        }
        if (this.destdir == null) {
            requiredProperties.add(DESTDIR_SYSTEM_PROPERTY);
        } else if (this.destdir.exists() && this.destdir.isFile()) {
            throw new ConfigurationException(Resource.PROPERTY_MUST_BE_DIR, DESTDIR_SYSTEM_PROPERTY, this.destdir.getAbsolutePath());
        }
    }

    protected void checkPackage() {
        String s;
        if (this.packageName == null && (s = this.properties.getProperty(PACKAGE_SYSTEM_PROPERTY)) != null) {
            this.setPackage(s);
        }
    }

    protected void checkDataPackage() {
        String s;
        if (this.dataPackage == null && (s = this.properties.getProperty(DATA_PACKAGE_SYSTEM_PROPERTY)) != null) {
            this.setDataPackage(s);
        }
        if (this.dataPackage == null) {
            this.setDataPackage(this.packageName);
        }
    }

    protected void checkClassName(Collection<String> requiredProperties) {
        if (this.className == null && this.serviceName != null) {
            String s = DataServiceUtils.getServiceClassName(this.serviceName);
            this.setClassName(s);
        }
    }

    protected WMHibernateToolTask getParentTask() {
        return this.parentTask;
    }

    protected ExporterTask getConfigurationExporter() {
        return new GenericExporterTask(this.getParentTask()){

            public Exporter createExporter() {
                return new HibernateSpringConfigExporter(BaseDataModelSetup.this.serviceName, BaseDataModelSetup.this.packageName, BaseDataModelSetup.this.dataPackage, BaseDataModelSetup.this.className, BaseDataModelSetup.this.getUseIndividualCRUDOperations());
            }
        };
    }

    protected boolean getUseIndividualCRUDOperations() {
        return false;
    }

    protected boolean initConnection(Collection<String> requiredProperties, boolean dialectIsRequired) {
        if (this.initialized) {
            return true;
        }
        this.checkAlternateConnectionProperties();
        this.checkUser(requiredProperties);
        this.checkPass(requiredProperties);
        this.checkUrl(requiredProperties);
        this.checkDBType();
        this.checkDialect(requiredProperties, false);
        this.checkDialectAndDBType(requiredProperties);
        this.checkDialect(requiredProperties, dialectIsRequired);
        this.checkDriverClass(requiredProperties);
        return true;
    }

    public boolean isMySQL() {
        if (this.dbtype == null) {
            return false;
        }
        return this.dbtype == "mysql";
    }

    public boolean isSQLServer() {
        if (this.dbtype == null) {
            return false;
        }
        return this.dbtype == SQL_SERVER_DB_TYPE;
    }

    public boolean isOracle() {
        if (this.dbtype == null) {
            return false;
        }
        return this.dbtype == ORACLE_DB_TYPE;
    }

    public boolean isHSQLDB() {
        if (this.dbtype == null) {
            return false;
        }
        return this.dbtype == HSQL_DB_TYPE;
    }

    public boolean isDB2() {
        if (this.dbtype == null) {
            return false;
        }
        return this.dbtype == DB2_DB_TYPE;
    }

    public boolean isPostgres() {
        if (this.dbtype == null) {
            return false;
        }
        return this.dbtype == POSTGRESQL_DB_TYPE;
    }

    public void testConnection() {
        HashSet<String> requiredProperties = new HashSet<String>();
        this.initConnection(requiredProperties, false);
        this.checkProperties(requiredProperties);
        if (this.dbtype == HSQL_DB_TYPE) {
            JDBCUtils.testHSQLConnection(this.connectionUrl, this.username, this.password, this.driverClassName);
        } else if (this.dbtype == "mysql") {
            JDBCUtils.testMySQLConnection(this.connectionUrl, this.username, this.password, this.driverClassName);
        } else if (this.dbtype == ORACLE_DB_TYPE) {
            JDBCUtils.testOracleConnection(this.connectionUrl, this.username, this.password, this.driverClassName);
        } else if (this.dbtype == SQL_SERVER_DB_TYPE) {
            JDBCUtils.testSQLServerConnection(this.connectionUrl, this.username, this.password, this.driverClassName);
        } else {
            if (DataServiceLoggers.importLogger.isInfoEnabled()) {
                DataServiceLoggers.importLogger.info((Object)("Generic connection test for: " + this.connectionUrl));
            }
            JDBCUtils.getConnection(this.connectionUrl, this.username, this.password, this.driverClassName);
        }
    }

    private void checkProperties(Collection<String> requiredProperties) {
        if (!requiredProperties.isEmpty()) {
            throw new ConfigurationException(Resource.MISSING_SYS_PROPERTIES.getMessage(new Object[]{ObjectUtils.toString(requiredProperties, (String)", ")}));
        }
    }

    static {
        DB_TYPES_TO_DIALECTS.put(HSQL_DB_TYPE, HSQLDialect.class);
        DB_TYPES_TO_DRIVER_CLASSES.put(HSQL_DB_TYPE, "org.hsqldb.jdbcDriver");
        DB_TYPES_TO_DIALECTS.put("mysql", MySQLDialect.class);
        DB_TYPES_TO_DRIVER_CLASSES.put("mysql", "com.mysql.jdbc.Driver");
        DB_TYPES_TO_DIALECTS.put(ORACLE_DB_TYPE, OracleDialect.class);
        DB_TYPES_TO_DRIVER_CLASSES.put(ORACLE_DB_TYPE, "oracle.jdbc.driver.OracleDriver");
        DB_TYPES_TO_DIALECTS.put(SQL_SERVER_DB_TYPE, SQLServerDialect.class);
        DB_TYPES_TO_DRIVER_CLASSES.put(SQL_SERVER_DB_TYPE, "net.sourceforge.jtds.jdbc.Driver");
        DB_TYPES_TO_DIALECTS.put(DB2_DB_TYPE, DB2Dialect.class);
        DB_TYPES_TO_DRIVER_CLASSES.put(DB2_DB_TYPE, "com.ibm.db2.jcc.DB2Driver");
        DB_TYPES_TO_DIALECTS.put(POSTGRESQL_DB_TYPE, PostgreSQLDialect.class);
        DB_TYPES_TO_DRIVER_CLASSES.put(POSTGRESQL_DB_TYPE, "org.postgresql.Driver");
        USER_SYSTEM_PROPERTY = SYSTEM_PROPERTY_PREFIX + BaseDataModelSetup.strip(".username");
        PASS_SYSTEM_PROPERTY = SYSTEM_PROPERTY_PREFIX + BaseDataModelSetup.strip(".password");
        CONNECTION_URL_SYSTEM_PROPERTY = SYSTEM_PROPERTY_PREFIX + BaseDataModelSetup.strip(".connectionUrl");
        DRIVER_CLASS_NAME_SYSTEM_PROPERTY = SYSTEM_PROPERTY_PREFIX + BaseDataModelSetup.strip(".driverClassName");
    }
}

