/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.parser.HbmConstants;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnInfo
implements Cloneable {
    private String name = null;
    private String sqlType = null;
    private String generator = null;
    private String sequenceName = null;
    private Integer length = null;
    private Integer precision = null;
    private boolean notNull = false;
    private boolean isPk = false;
    private boolean isFk = false;
    private boolean persistType = true;

    public static ColumnInfo newColumnInfo(PropertyInfo parentProperty) {
        return ColumnInfo.newColumnInfo(parentProperty, Collections.<String, String>emptyMap());
    }

    public static ColumnInfo newColumnInfo(PropertyInfo parentProperty, Map<String, String> attributes) {
        String precision;
        String length;
        ColumnInfo rtn = new ColumnInfo();
        rtn.setNotNull(Boolean.parseBoolean(attributes.get(HbmConstants.FQ_COL_NOT_NULL_ATTR)));
        String name = attributes.get(HbmConstants.FQ_COL_NAME_ATTR);
        if (ObjectUtils.isNullOrEmpty((String)name)) {
            rtn.setName(parentProperty.getName());
        } else {
            rtn.setName(name);
        }
        String type = attributes.get(HbmConstants.FQ_COL_TYPE_ATTR);
        if (type == null && !parentProperty.getIsRelated() && parentProperty.getType() != null) {
            type = parentProperty.getType();
            rtn.persistType(false);
        }
        if (type != null) {
            rtn.setSqlType(type);
        }
        if ((length = attributes.get(HbmConstants.FQ_COL_LENGTH_ATTR)) != null) {
            rtn.setLength(Integer.valueOf(length));
        }
        if ((precision = attributes.get(HbmConstants.FQ_COL_PRECISION_ATTR)) != null) {
            rtn.setPrecision(Integer.valueOf(precision));
        }
        if (parentProperty.getIsId()) {
            rtn.setIsPk(true);
            rtn.setNotNull(true);
            String generator = attributes.get(HbmConstants.FQ_GEN_TYPE_ATTR);
            if (!ObjectUtils.isNullOrEmpty((String)generator)) {
                rtn.setGenerator(generator);
                if (generator.equals("sequence")) {
                    String prefix = "param.";
                    Collection c = ObjectUtils.getKeysStartingWith((String)prefix, attributes);
                    for (String s : c) {
                        String paramName = s.substring(prefix.length());
                        if (!paramName.equals("sequence")) continue;
                        rtn.sequenceName = attributes.get(s);
                    }
                }
            }
        }
        if (parentProperty.getIsRelated()) {
            rtn.setIsFk(true);
        }
        return rtn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public boolean getNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean b) {
        this.notNull = b;
    }

    public boolean generated() {
        return this.generator != null && !this.generator.equals("assigned");
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String s) {
        this.generator = s;
    }

    public boolean getIsPk() {
        return this.isPk;
    }

    public void setIsPk(boolean b) {
        this.isPk = b;
    }

    public boolean getIsFk() {
        return this.isFk;
    }

    public void setGeneratorParam(String s) {
        this.sequenceName = s;
    }

    public String getGeneratorParam() {
        return this.sequenceName;
    }

    public void setIsFk(boolean b) {
        this.isFk = b;
    }

    public void persistType(boolean b) {
        this.persistType = b;
    }

    public boolean shouldPersistType() {
        return this.persistType;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public boolean onlyGeneratorHasChanged(ColumnInfo o) {
        return this.isEqualTo(o, true);
    }

    public boolean isEqualTo(ColumnInfo o) {
        return this.isEqualTo(o, false);
    }

    private boolean isEqualTo(ColumnInfo o, boolean ignoreGenerator) {
        if (o == null) {
            return false;
        }
        boolean rtn = true;
        if (!ignoreGenerator) {
            rtn &= String.valueOf(this.generator).equals(String.valueOf(o.generator));
            rtn &= String.valueOf(this.sequenceName).equals(String.valueOf(o.sequenceName));
        }
        rtn &= String.valueOf(this.isPk).equals(String.valueOf(o.isPk));
        rtn &= String.valueOf(this.length).equals(String.valueOf(o.length));
        rtn &= String.valueOf(this.name).equals(String.valueOf(o.name));
        rtn &= String.valueOf(this.notNull).equals(String.valueOf(o.notNull));
        rtn &= String.valueOf(this.precision).equals(String.valueOf(o.precision));
        return rtn &= String.valueOf(this.sqlType).equals(String.valueOf(o.sqlType));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.generator != null) {
            sb.append(" generator:");
            sb.append(this.generator);
            if (this.sequenceName != null) {
                sb.append(this.sequenceName);
            }
        }
        sb.append(" not-null:" + this.notNull);
        if (this.length != null) {
            sb.append(" length:" + this.length);
        }
        return sb.toString();
    }
}

