/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.NotYetImplementedException;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.RuntimeAccess;
import com.wavemaker.runtime.client.TreeNode;
import com.wavemaker.runtime.data.DataServiceDefinition;
import com.wavemaker.runtime.data.DataServiceOperation;
import com.wavemaker.runtime.data.ExternalDataModelConfig;
import com.wavemaker.runtime.data.util.DataServiceConstants;
import com.wavemaker.runtime.data.util.QueryRunner;
import com.wavemaker.runtime.service.definition.DeprecatedServiceDefinition;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.BeanInfo;
import com.wavemaker.tools.data.ColumnInfo;
import com.wavemaker.tools.data.DataServiceLoggers;
import com.wavemaker.tools.data.DataServiceSpringConfiguration;
import com.wavemaker.tools.data.EntityInfo;
import com.wavemaker.tools.data.Input;
import com.wavemaker.tools.data.OperationWrapperGenerator;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.QueryInfo;
import com.wavemaker.tools.data.RelatedInfo;
import com.wavemaker.tools.data.TypeInfo;
import com.wavemaker.tools.data.parser.BaseHbmParser;
import com.wavemaker.tools.data.parser.HbmParser;
import com.wavemaker.tools.data.parser.HbmQueryParser;
import com.wavemaker.tools.data.parser.HbmQueryWriter;
import com.wavemaker.tools.data.parser.HbmWriter;
import com.wavemaker.tools.data.spring.SpringService;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.project.ProjectManager;
import com.wavemaker.tools.service.AbstractFileService;
import com.wavemaker.tools.service.ClassLoaderFactory;
import com.wavemaker.tools.service.CompileService;
import com.wavemaker.tools.service.DefaultClassLoaderFactory;
import com.wavemaker.tools.service.DefaultCompileService;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.FileService;
import com.wavemaker.tools.service.codegen.ServiceDataObjectGenerator;
import com.wavemaker.tools.service.definitions.Service;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModelConfiguration {
    private static final String BACKUP_SUFFIX = ".bak";
    private final OperationWrapperGenerator generator = new OperationWrapperGenerator();
    private final String name;
    private final FileService fileService;
    private final CompileService compileService;
    private final ClassLoaderFactory classLoaderFactory;
    private final String cfgPath;
    private final String cfgFile;
    private final ExternalDataModelConfig externalConfig;
    private final DataServiceSpringConfiguration springConfiguration;
    private String dataPackage = null;
    private final Map<String, String> entityNameToPath = new HashMap<String, String>();
    private final Map<String, EntityInfo> entityInfos = new HashMap<String, EntityInfo>();
    private final Map<String, HbmParser> entityNameToHbmParser = new HashMap<String, HbmParser>();
    private final Map<String, TypeInfo> valueTypes = new HashMap<String, TypeInfo>();
    private final Map<String, BeanInfo> outputTypes = new HashMap<String, BeanInfo>();
    private final Collection<EntityInfo> modifiedEntityInfos = new HashSet<EntityInfo>();
    private final Collection<String> deletedEntities = new HashSet<String>();
    private final Map<BaseHbmParser, String> parserToPath = new HashMap<BaseHbmParser, String>();
    private final Collection<String> deletedTypes = new HashSet<String>();
    private final List<String> queryFiles = new ArrayList<String>();
    private Map<String, QueryInfo> queryNameToQueryInfo = null;
    private Map<String, HbmQueryParser> queryNameToParser = null;
    private HbmQueryParser defaultQueryParser = null;
    private final Collection<HbmQueryParser> modifiedQueryParsers = new HashSet<HbmQueryParser>();
    private final Collection<String> modifiedQueryNames = new HashSet<String>();
    private final Collection<String> deletedQueries = new HashSet<String>();
    private final Collection<String> writtenBackupFiles = new HashSet<String>();

    public DataModelConfiguration(File cfgFile, FileService fileService, String serviceId, ExternalDataModelConfig externalConfig, ClassLoaderFactory classLoaderFactory, CompileService compileService) throws IOException {
        this.name = serviceId;
        this.cfgFile = cfgFile.getName();
        this.cfgPath = DesignServiceManager.getRuntimeRelativeDir(serviceId);
        this.fileService = fileService;
        this.externalConfig = externalConfig;
        this.classLoaderFactory = classLoaderFactory;
        this.compileService = compileService;
        this.springConfiguration = new DataServiceSpringConfiguration(fileService, this.cfgPath, this.cfgFile, serviceId);
        this.setup();
    }

    public DataModelConfiguration(File springConfig) {
        this(springConfig, DataServiceUtils.getDummyExternalConfig());
    }

    public DataModelConfiguration(File springConfig, ClassLoaderFactory classLoaderFactory, CompileService compileService) {
        this(springConfig, DataServiceUtils.getDummyExternalConfig(), classLoaderFactory, compileService);
    }

    public DataModelConfiguration(File springConfig, ExternalDataModelConfig externalConfig) {
        this(springConfig, externalConfig, new DefaultClassLoaderFactory(springConfig.getParentFile()), new DefaultCompileService(springConfig.getParentFile()));
    }

    private DataModelConfiguration(File springConfig, ExternalDataModelConfig externalConfig, ClassLoaderFactory classLoaderFactory, CompileService compileService) {
        this.name = StringUtils.fromFirstOccurrence((String)springConfig.getName(), (String)".", (int)-1);
        this.cfgPath = ".";
        this.cfgFile = springConfig.getName();
        final File baseDir = springConfig.getParentFile();
        this.classLoaderFactory = classLoaderFactory;
        this.externalConfig = externalConfig;
        this.compileService = compileService;
        this.fileService = new AbstractFileService(){

            public File getFileServiceRoot() {
                return baseDir;
            }
        };
        this.springConfiguration = new DataServiceSpringConfiguration(this.fileService, this.cfgPath, this.cfgFile, this.name);
        this.setup();
    }

    public Collection<String> getEntityNames() {
        return new TreeSet<String>(this.entityInfos.keySet());
    }

    public Collection<EntityInfo> getEntities() {
        return this.entityInfos.values();
    }

    public Collection<TypeInfo> getValueTypes() {
        return this.valueTypes.values();
    }

    public Collection<BeanInfo> getOtherTypes() {
        return this.outputTypes.values();
    }

    public BeanInfo getBean(String beanName) {
        return this.outputTypes.get(beanName);
    }

    public EntityInfo getEntity(String entity) {
        EntityInfo rtn = this.entityInfos.get(entity);
        if (rtn == null) {
            throw new ConfigurationException("Unknown entity: " + entity);
        }
        return rtn;
    }

    public String getEntityName(String javaType) {
        return (String)StringUtils.splitPackageAndClass((String)javaType).v2;
    }

    public boolean isKnownType(String javaType) {
        String s = this.getEntityName(javaType);
        return this.entityInfos.containsKey(s) || this.valueTypes.containsKey(s) || this.outputTypes.containsKey(s);
    }

    public boolean isEntityType(String javaType) {
        String s = this.getEntityName(javaType);
        return this.entityInfos.containsKey(s);
    }

    public boolean isValueType(String javaType) {
        String s = this.getEntityName(javaType);
        return this.valueTypes.containsKey(s);
    }

    public boolean isHelperType(String javaType) {
        String s = this.getEntityName(javaType);
        return this.outputTypes.containsKey(s);
    }

    public Collection<String> getPropertyNames(String entity) {
        return this.getEntity(entity).getPropertyNames();
    }

    public Collection<PropertyInfo> getProperties(String entity) {
        return this.getEntity(entity).getProperties();
    }

    public PropertyInfo getProperty(String entity, String property) {
        return this.getEntity(entity).getProperty(property);
    }

    public Collection<PropertyInfo> getRelatedProperties(String entity) {
        return this.getEntity(entity).getRelatedProperties();
    }

    public Collection<ColumnInfo> getColumns(String entity) {
        return this.getEntity(entity).getColumns();
    }

    public Map<String, ColumnInfo> getColumnsMap(String entity) {
        Collection<ColumnInfo> cols = this.getColumns(entity);
        LinkedHashMap<String, ColumnInfo> rtn = new LinkedHashMap<String, ColumnInfo>(cols.size());
        for (ColumnInfo c : cols) {
            rtn.put(c.getName(), c);
        }
        return rtn;
    }

    public ColumnInfo getColumn(String entity, String property) {
        return this.getProperty(entity, property).getColumn();
    }

    public ColumnInfo getColumn(String entity, String parentProperty, String property) {
        PropertyInfo parent = this.getProperty(entity, parentProperty);
        PropertyInfo p = parent.getCompositeProperty(property);
        if (p == null) {
            throw new ConfigurationException("Unkown property " + property + " on " + parentProperty);
        }
        return p.getColumn();
    }

    public Collection<String> getQueryNames() {
        return new TreeSet<String>(this.getHibernateQueries().keySet());
    }

    public Collection<QueryInfo> getQueries() {
        return this.getHibernateQueries().values();
    }

    public QueryInfo getQuery(String queryName) {
        return this.getHibernateQueries().get(queryName);
    }

    public QueryInfo getQueryByOperationName(String operationName) {
        QueryInfo rtn = this.getQuery(operationName);
        if (rtn == null) {
            operationName = com.wavemaker.runtime.data.util.DataServiceUtils.operationToQueryName(operationName, this.getHibernateQueries().keySet());
        }
        return this.getQuery(operationName);
    }

    public void updateQuery(QueryInfo queryInfo) {
        if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
            DataServiceLoggers.parserLogger.debug((Object)("updateQuery: " + queryInfo.getName() + " " + "inputs: " + ObjectUtils.toString((Object[])queryInfo.getInputs()) + " " + "single result: " + queryInfo.getReturnsSingleResult()));
        }
        if (!queryInfo.getIsHQL()) {
            throw new NotYetImplementedException("Can only add HQL queries for now");
        }
        if (queryInfo.getName() == null) {
            throw new IllegalArgumentException("Query must have a name set");
        }
        if (!StringUtils.isValidJavaIdentifier((String)queryInfo.getName())) {
            throw new ConfigurationException("Query name must be a valid Java identifier");
        }
        this.getHibernateQueries();
        HbmQueryParser parser = this.getParserForQuery(queryInfo);
        if (parser == null) {
            throw new AssertionError((Object)"Parser cannot be null");
        }
        if (com.wavemaker.runtime.data.util.DataServiceUtils.isDML(queryInfo.getQuery()) && !queryInfo.getReturnsSingleResult()) {
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("updateQuery: " + queryInfo.getName() + " is a DML operation, setting " + " returns single result"));
            }
            queryInfo.setReturnsSingleResult(true);
        }
        queryInfo.setIsGenerated(false);
        parser.getQueries().put(queryInfo.getName(), queryInfo);
        this.modifiedQueryParsers.add(parser);
        this.modifiedQueryNames.add(queryInfo.getName());
        this.queryNameToQueryInfo.put(queryInfo.getName(), queryInfo);
        this.queryNameToParser.put(queryInfo.getName(), parser);
    }

    public void addUserQueries(Collection<QueryInfo> queries) {
        for (QueryInfo q : queries) {
            if (q.getIsGenerated()) continue;
            this.updateQuery(q);
        }
    }

    public QueryInfo deleteQuery(String queryName) {
        return this.deleteQuery(queryName, false);
    }

    public QueryInfo deleteQuery(String queryName, boolean skipIfNotExists) {
        if (ObjectUtils.isNullOrEmpty((String)queryName)) {
            throw new IllegalArgumentException("queryName must be set");
        }
        this.getHibernateQueries();
        QueryInfo rtn = this.queryNameToQueryInfo.remove(queryName);
        if (rtn == null) {
            if (skipIfNotExists) {
                return null;
            }
            throw new IllegalArgumentException("Uknown query: " + queryName);
        }
        this.modifiedQueryNames.remove(queryName);
        HbmQueryParser p = this.queryNameToParser.remove(queryName);
        this.modifiedQueryParsers.remove(p);
        p.getQueries().remove(queryName);
        if (p.getQueries().isEmpty() && p != this.defaultQueryParser) {
            p.close();
            String path = this.parserToPath.remove(p);
            this.deletedQueries.add(path);
            this.removeMappingFromSpringFile(path);
        } else {
            this.modifiedQueryParsers.add(p);
        }
        String outputType = rtn.getOutputType();
        if (outputType != null && com.wavemaker.runtime.data.util.DataServiceUtils.isOutputType(outputType)) {
            this.deletedQueries.add(StringUtils.classNameToSrcFilePath((String)outputType));
        }
        return rtn;
    }

    public Collection<RelatedInfo> getRelated(String entity) {
        Collection<PropertyInfo> props = this.getRelatedProperties(entity);
        ArrayList<RelatedInfo> rtn = new ArrayList<RelatedInfo>(props.size());
        for (PropertyInfo p : props) {
            rtn.add(this.getRelated(entity, p.getName()));
        }
        return rtn;
    }

    public RelatedInfo getRelated(String entity, String property) {
        PropertyInfo p = this.getProperty(entity, property);
        String tableName = this.getEntity(entity).getTableName();
        if (p.getIsInverse()) {
            tableName = this.getEntity(p.getType()).getTableName();
        }
        return p.toRelated(tableName);
    }

    public void touchAllEntities() {
        for (EntityInfo e : this.getEntities()) {
            this.touchEntity(e);
        }
    }

    public void touchEntity(EntityInfo entity) {
        this.modifiedEntityInfos.add(entity);
    }

    public void touchEntity(String entityName) {
        this.touchEntity(this.getEntity(entityName));
    }

    public void addValueType(TypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("typeInfo must be set");
        }
        this.valueTypes.put(typeInfo.getName(), typeInfo);
    }

    public void deleteValueType(String valueTypeName) {
        if (ObjectUtils.isNullOrEmpty((String)valueTypeName)) {
            throw new IllegalArgumentException("valueTypeName must be set");
        }
        TypeInfo t = this.valueTypes.remove(valueTypeName);
        if (t == null) {
            throw new IllegalArgumentException("Unknown value type " + valueTypeName);
        }
        String path = this.getRelServicePath(StringUtils.classNameToSrcFilePath((String)t.getFullyQualifiedName()));
        this.deletedTypes.add(path);
    }

    public void deleteEntity(String entityName) {
        if (ObjectUtils.isNullOrEmpty((String)entityName)) {
            throw new IllegalArgumentException("entityName must be set");
        }
        EntityInfo ei = this.entityInfos.remove(entityName);
        if (ei == null) {
            throw new IllegalArgumentException("Unknown entity: " + entityName);
        }
        this.modifiedEntityInfos.remove(ei);
        BaseHbmParser p = this.entityNameToHbmParser.remove(entityName);
        p.close();
        this.parserToPath.remove(p);
        String path = this.entityNameToPath.remove(entityName);
        this.removeMappingFromSpringFile(path);
        this.deletedEntities.add(path);
        String s = this.getRelServicePath(StringUtils.fromLastOccurrence((String)path, (String)".hbm.xml", (int)-1));
        this.deletedTypes.add(s);
        this.deleteReferences(entityName, ei.getRelatedProperties());
    }

    private void replaceEntity(String entityName, String newEntityName) {
        if (ObjectUtils.isNullOrEmpty((String)entityName)) {
            throw new IllegalArgumentException("entityName must be set");
        }
        EntityInfo ei = this.entityInfos.remove(entityName);
        this.modifiedEntityInfos.remove(ei);
        ei.setEntityName(newEntityName);
        this.entityInfos.put(newEntityName, ei);
        String oldPkgName = StringUtils.packageToSrcFilePath((String)ei.getPackageName()) + "/" + entityName + ".hbm.xml";
        String oldPath = this.getProjectRoot() + "/" + this.getRelServicePath(oldPkgName);
        String newPkgName = StringUtils.packageToSrcFilePath((String)ei.getPackageName()) + "/" + newEntityName + ".hbm.xml";
        String newPath = this.getProjectRoot() + "/" + this.getRelServicePath(newPkgName);
        File oldf = new File(oldPath);
        File newf = new File(newPath);
        oldf.renameTo(newf);
        try {
            String content = FileUtils.readFileToString((File)newf, (String)"UTF-8");
            content = content.replace(entityName, newEntityName);
            FileUtils.writeStringToFile((File)newf, (String)content, (String)"UTF-8");
            this.removeMappingFromSpringFile(oldPkgName);
            this.addEntityToSpringFile(newPkgName);
        }
        catch (IOException e) {
            throw new WMRuntimeException((Throwable)e);
        }
        this.modifiedEntityInfos.add(ei);
        BaseHbmParser p = this.entityNameToHbmParser.remove(entityName);
        this.entityNameToHbmParser.put(newEntityName, (HbmParser)p);
        this.parserToPath.remove(p);
        this.parserToPath.put(p, newPkgName);
        this.entityNameToPath.remove(entityName);
        this.entityNameToPath.put(newEntityName, newPkgName);
        this.deletedEntities.add(oldPkgName);
        String s = this.getRelServicePath(StringUtils.fromLastOccurrence((String)oldPkgName, (String)".hbm.xml", (int)-1));
        this.deletedTypes.add(s);
        String qryName = "get" + entityName + "ById";
        this.deleteQuery(qryName, true);
        this.updateReferences(entityName, newEntityName, ei.getRelatedProperties());
    }

    private String getProjectRoot() {
        ProjectManager projMgr = (ProjectManager)RuntimeAccess.getInstance().getSession().getAttribute("currentProjectManager");
        String projRoot = projMgr.getCurrentProject().getProjectRoot().getAbsolutePath();
        return projRoot;
    }

    public void updateEntity(String entityName, EntityInfo entity) {
        if (ObjectUtils.isNullOrEmpty((String)entityName)) {
            throw new IllegalArgumentException("entityName must be set");
        }
        EntityInfo org = null;
        if (this.getEntityNames().contains(entityName)) {
            if (!entityName.equals(entity.getEntityName())) {
                this.validateName(entity.getEntityName());
                if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                    DataServiceLoggers.parserLogger.debug((Object)(entityName + " Processing entity rename from " + entityName + " to " + entity.getEntityName()));
                }
                this.replaceEntity(entityName, entity.getEntityName());
                this.updateEntity(entity.getEntityName(), entity);
                return;
            }
            org = this.getEntity(entityName);
            if (org.isEqualTo(entity)) {
                if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                    DataServiceLoggers.parserLogger.debug((Object)(entityName + " has not changed"));
                }
                return;
            }
            if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                DataServiceLoggers.parserLogger.debug((Object)("Processing entity update for " + entityName));
            }
        } else {
            this.validateName(entityName);
            org = new EntityInfo();
            this.entityInfos.put(entityName, org);
            String path = StringUtils.packageToSrcFilePath((String)entity.getPackageName()) + "/" + entityName + ".hbm.xml";
            this.entityNameToPath.put(entityName, path);
            if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                DataServiceLoggers.parserLogger.debug((Object)("Processing entity add for " + entityName + " at " + path));
            }
            this.addEntityToSpringFile(path);
            this.entityNameToHbmParser.put(entityName, new HbmParser());
            if (this.dataPackage == null) {
                this.dataPackage = entity.getPackageName();
            }
        }
        org.update(entity);
        this.modifiedEntityInfos.add(org);
        this.propagateSchemaChange(org);
        this.propagateCatalogChange(org);
        this.propagatePackageChange(org);
        this.setProperties(org);
    }

    public void updateColumns(String entityName, List<ColumnInfo> columns) {
        this.updateColumns(entityName, columns, Collections.<PropertyInfo>emptyList());
    }

    public void updateColumns(String entityName, List<ColumnInfo> columns, List<PropertyInfo> properties) {
        EntityInfo ei = this.getEntity(entityName);
        if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
            DataServiceLoggers.parserLogger.info((Object)("Updating columns for " + entityName));
        }
        for (ColumnInfo ci : columns) {
            if (Integer.valueOf(0).equals(ci.getLength())) {
                ci.setLength(null);
            }
            if (!Integer.valueOf(0).equals(ci.getPrecision())) continue;
            ci.setPrecision(null);
        }
        ei.updateColumns(columns, properties, this);
        this.modifiedEntityInfos.add(ei);
    }

    public void updateRelated(String entityName, List<RelatedInfo> related) {
        EntityInfo ei = this.getEntity(entityName);
        ArrayList<PropertyInfo> rels = new ArrayList<PropertyInfo>(related.size());
        for (RelatedInfo ri : related) {
            this.validateName(ri.getName());
            PropertyInfo p = PropertyInfo.newCompositeProperty();
            p.fromRelated(ri, ei, this);
            rels.add(p);
        }
        Collection<EntityInfo> modifiedMany = ei.updateRelated(rels, this);
        this.modifiedEntityInfos.add(ei);
        this.modifiedEntityInfos.addAll(modifiedMany);
        ei.initFkColumnTypes(this);
        ei.setColumns(this.initColumns(entityName));
    }

    public boolean useIndividualCRUDOperations() {
        return this.springConfiguration.useIndividualCRUDperations();
    }

    public void setRefreshEntities(List<String> refreshEntities) {
        this.springConfiguration.setRefreshEntities(refreshEntities);
    }

    public List<String> getRefreshEntities() {
        return this.springConfiguration.getRefreshEntities();
    }

    public synchronized Properties readConnectionProperties() {
        return this.readConnectionProperties(true);
    }

    public synchronized Properties readConnectionProperties(boolean removePrefix) {
        return this.springConfiguration.readProperties(removePrefix);
    }

    public synchronized void writeConnectionProperties(Properties props) {
        String connUrl = props.getProperty(DataServiceConstants.DB_URL_KEY);
        ProjectManager projMgr = (ProjectManager)RuntimeAccess.getInstance().getSession().getAttribute("currentProjectManager");
        String projRoot = projMgr.getCurrentProject().getWebAppRoot().getPath();
        connUrl = StringUtils.replacePlainStr((String)connUrl, (String)projRoot, (String)"{WebAppRoot}");
        props.setProperty(DataServiceConstants.DB_URL_KEY, connUrl);
        this.springConfiguration.writeProperties(props);
    }

    public void checkQuery(final String query, final Input[] inputs, final String values) {
        ClassLoaderUtils.TaskNoRtn task = new ClassLoaderUtils.TaskNoRtn(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                QueryRunner queryRunner = SpringService.initQueryRunner(DataModelConfiguration.this.cfgFile);
                DataModelConfiguration.this.setBindParameters(queryRunner, inputs, values, true);
                try {
                    queryRunner.check(query);
                }
                finally {
                    queryRunner.dispose();
                }
            }
        };
        ClassLoaderUtils.runInClassLoaderContext((ClassLoaderUtils.TaskType)task, (ClassLoader)this.classLoaderFactory.getClassLoader());
    }

    public Object runQuery(final String query, final Input[] inputs, final String values, final Long maxResults) {
        ClassLoaderUtils.TaskRtn task = new ClassLoaderUtils.TaskRtn(){

            public Object run() {
                QueryRunner queryRunner = SpringService.initQueryRunner(DataModelConfiguration.this.cfgFile);
                DataModelConfiguration.this.setBindParameters(queryRunner, inputs, values, false);
                queryRunner.setMaxResults(maxResults);
                Object rtn = null;
                try {
                    rtn = queryRunner.run(query);
                }
                catch (Throwable th) {
                    throw com.wavemaker.runtime.data.util.DataServiceUtils.unwrap(th);
                }
                finally {
                    queryRunner.dispose();
                }
                return rtn;
            }
        };
        return ClassLoaderUtils.runInClassLoaderContext((ClassLoaderUtils.TaskType)task, (ClassLoader)this.classLoaderFactory.getClassLoader());
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean backup) {
        this.save(backup, DataServiceUtils.NOOP_UPDATE_CALLBACK);
    }

    public void save(UpdateCallback updateCallback) {
        this.save(true, updateCallback);
    }

    public synchronized void save(boolean backup, UpdateCallback callback) {
        this.save(backup, callback, false, true);
    }

    public synchronized void save(boolean backup, UpdateCallback callback, boolean forceUpdate, boolean compile) {
        this.writeCfgFile(backup);
        boolean updateService = forceUpdate;
        if (this.modifiedQueryParsers.isEmpty() && this.deletedQueries.isEmpty()) {
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)"No modified query, nothing to save");
            }
        } else {
            this.saveDeletedQueries(backup);
            this.saveModifiedQueries(backup);
            updateService = true;
        }
        if (this.modifiedEntityInfos.isEmpty() && this.deletedEntities.isEmpty()) {
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)"No modified entities, nothing to save");
            }
        } else {
            this.saveModifiedEntities(backup, true);
            this.saveDeletedEntities(backup);
            updateService = true;
        }
        boolean cleanCompile = false;
        if (!this.deletedTypes.isEmpty()) {
            cleanCompile = true;
            this.deleteTypes(true);
            this.removeServiceClass();
        }
        if (updateService) {
            if (compile) {
                this.compileService.compile(cleanCompile);
            }
            this.updateService(callback);
        }
    }

    public synchronized void revert() {
        this.revert(false);
    }

    public synchronized void revert(boolean compile) {
        HashSet<String> s = new HashSet<String>(this.writtenBackupFiles);
        for (String path : s) {
            try {
                String original = this.fileService.readFile(path);
                String originalPath = StringUtils.fromLastOccurrence((String)path, (String)BACKUP_SUFFIX, (int)-1);
                this.fileService.writeFile(originalPath, original);
                this.fileService.deleteFile(path);
                if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                    DataServiceLoggers.parserLogger.info((Object)("Reverted " + originalPath + " from backup file"));
                }
                this.writtenBackupFiles.remove(path);
            }
            catch (IOException ex) {
                throw new ConfigurationException(ex);
            }
        }
        this.springConfiguration.revert();
        if (compile) {
            this.compileService.compile(true);
        }
    }

    public synchronized void removeBackupFiles() {
        HashSet<String> s = new HashSet<String>(this.writtenBackupFiles);
        for (String path : s) {
            this.fileService.deleteFile(path);
            this.writtenBackupFiles.remove(path);
        }
    }

    public List<String> getModifiedFiles() {
        ArrayList<String> rtn = new ArrayList<String>();
        for (EntityInfo ei : this.modifiedEntityInfos) {
            rtn.add(this.entityNameToPath.get(ei.getEntityName()));
        }
        for (HbmQueryParser p : this.modifiedQueryParsers) {
            rtn.add(this.parserToPath.get(p));
        }
        return rtn;
    }

    public void addDataObjectTree(TreeNode root) {
        for (TreeNode n : this.getTypeNodes()) {
            root.addChild(n);
        }
    }

    public void addQueryTree(TreeNode root) {
        for (TreeNode n : this.getQueryNodes()) {
            root.addChild(n);
        }
    }

    public List<TreeNode> getQueryNodes() {
        Collection<String> queryNames = this.getQueryNames();
        ArrayList<TreeNode> rtn = new ArrayList<TreeNode>(queryNames.size());
        for (String queryName : queryNames) {
            TreeNode n = new TreeNode(queryName);
            rtn.add(n);
            n.addData(queryName);
            n.addData(queryName);
        }
        return rtn;
    }

    public List<TreeNode> getTypeNodes() {
        Collection<String> entityNames = this.getEntityNames();
        ArrayList<TreeNode> rtn = new ArrayList<TreeNode>(entityNames.size());
        for (String entityName : entityNames) {
            TreeNode n2 = new TreeNode(entityName);
            EntityInfo ei = this.getEntity(entityName);
            n2.addData("TBL");
            n2.addData(entityName);
            n2.addData(StringUtils.fq((String)ei.getPackageName(), (String)entityName));
            rtn.add(n2);
            for (String propertyName : this.getPropertyNames(entityName)) {
                PropertyInfo p = this.getProperty(entityName, propertyName);
                TreeNode n3 = this.formatTreeNode(new TreeNode(), p);
                n2.addChild(n3);
                this.addCompositeProperties(p, n3);
            }
        }
        return rtn;
    }

    public List<String> getMappings() {
        return this.springConfiguration.getMappings();
    }

    public String getDataPackage() {
        if (this.dataPackage == null) {
            throw new IllegalStateException("Cannot determine package until mapping files have been registered");
        }
        return this.dataPackage;
    }

    public String getOutputPackage() {
        return com.wavemaker.runtime.data.util.DataServiceUtils.getOutputPackage(this.getDataPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRuntime() {
        DeprecatedServiceDefinition def = null;
        try {
            def = this.initRuntimeDataServiceDefinition();
        }
        finally {
            if (def != null) {
                def.dispose();
            }
        }
    }

    public boolean compareTo(DataModelConfiguration other) {
        HashSet<String> c = new HashSet<String>(this.getEntityNames());
        for (String s : other.getEntityNames()) {
            if (c.remove(s)) continue;
            return false;
        }
        return c.isEmpty();
    }

    public boolean isKnownConfiguration() {
        return this.springConfiguration.isKnownConfiguration();
    }

    public void dispose() {
        for (HbmParser p : this.entityNameToHbmParser.values()) {
            p.close();
        }
    }

    public void saveEntities() {
        this.saveModifiedEntities(false, false);
    }

    public void validateName(String name) {
        if (!StringUtils.isValidJavaIdentifier((String)name)) {
            throw new AssertionError((Object)("\"" + name + "\" is not a valid java identifier"));
        }
    }

    public String toString() {
        return "Mappings: " + this.entityNameToPath + "\n\nQueries: " + this.queryFiles;
    }

    private void setProperties(EntityInfo entity) {
        List<String> refreshEntities = this.getRefreshEntities();
        String fq = StringUtils.fq((String)entity.getPackageName(), (String)entity.getEntityName());
        if (entity.isRefreshEntity() && !refreshEntities.contains(fq)) {
            refreshEntities.add(fq);
            this.setRefreshEntities(refreshEntities);
        } else if (!entity.isRefreshEntity() && refreshEntities.contains(fq)) {
            refreshEntities.remove(fq);
            this.setRefreshEntities(refreshEntities);
        }
    }

    private void deleteTypes(boolean backup) {
        for (String s : new HashSet<String>(this.deletedTypes)) {
            String path = s;
            if (!path.endsWith(".java")) {
                path = path + ".java";
            }
            if (backup) {
                this.backup(path);
            }
            this.fileService.deleteFile(path);
            this.deletedTypes.remove(s);
        }
    }

    private void updateReferences(String oldEntityName, String newEntityName, Collection<PropertyInfo> relatedProperties) {
        for (PropertyInfo pi : relatedProperties) {
            EntityInfo relatedEntity = this.getEntity(pi.getType());
            for (PropertyInfo relp : new ArrayList<PropertyInfo>(relatedEntity.getRelatedProperties())) {
                if (!relp.getType().equals(oldEntityName)) continue;
                if (relp.getIsInverse()) {
                    relatedEntity.removeProperty(relp);
                } else {
                    relp.types(StringUtils.fq((String)this.getDataPackage(), (String)newEntityName));
                }
                this.modifiedEntityInfos.add(relatedEntity);
            }
        }
    }

    private void deleteReferences(String entityName, Collection<PropertyInfo> relatedProperties) {
        for (PropertyInfo pi : relatedProperties) {
            EntityInfo relatedEntity = this.getEntity(pi.getType());
            for (PropertyInfo relp : new ArrayList<PropertyInfo>(relatedEntity.getRelatedProperties())) {
                if (!relp.getType().equals(entityName)) continue;
                relatedEntity.removeProperty(relp);
                this.modifiedEntityInfos.add(relatedEntity);
            }
        }
    }

    private void writeCfgFile(boolean backup) {
        if (backup) {
            this.backup(this.springConfiguration.getPath());
        }
        this.springConfiguration.write();
    }

    private void propagateSchemaChange(EntityInfo entity) {
        for (EntityInfo other : this.getEntities()) {
            if (other == entity || String.valueOf(other.getSchemaName()).equals(String.valueOf(entity.getSchemaName()))) continue;
            other.setSchemaName(entity.getSchemaName());
            this.modifiedEntityInfos.add(other);
        }
    }

    private void propagateCatalogChange(EntityInfo entity) {
        for (EntityInfo other : this.getEntities()) {
            if (other == entity || String.valueOf(other.getCatalogName()).equals(String.valueOf(entity.getCatalogName()))) continue;
            other.setCatalogName(entity.getCatalogName());
            this.modifiedEntityInfos.add(other);
        }
    }

    private void propagatePackageChange(EntityInfo entity) {
        this.dataPackage = entity.getPackageName();
        for (EntityInfo other : this.getEntities()) {
            if (other == entity || other.getPackageName().equals(entity.getPackageName())) continue;
            other.setPackageName(entity.getPackageName());
            this.modifiedEntityInfos.add(other);
        }
    }

    private void addQueryDocument(String path) {
        this.queryFiles.add(path);
    }

    private void addMappingDocument(String path) {
        EntityInfo ei = this.initEntityInfo(path);
        if (this.dataPackage == null) {
            this.dataPackage = ei.getPackageName();
        } else if (!this.dataPackage.equals(ei.getPackageName()) && DataServiceLoggers.parserLogger.isWarnEnabled()) {
            DataServiceLoggers.parserLogger.warn((Object)(ei.getEntityName() + ": mapped class must match service class package: " + this.dataPackage + ". Mapped class: " + ei.getPackageName()));
        }
        this.entityNameToPath.put(ei.getEntityName(), path);
        this.entityInfos.put(ei.getEntityName(), ei);
        ei.setColumns(this.initColumns(ei.getEntityName()));
    }

    private synchronized void saveDeletedEntities(boolean backup) {
        for (String path : new HashSet<String>(this.deletedEntities)) {
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("Deleting entity at " + path));
            }
            String relPath = this.getRelServicePath(path);
            if (backup) {
                this.backup(relPath);
            }
            this.fileService.deleteFile(relPath);
            this.deletedEntities.remove(path);
        }
    }

    private synchronized void saveModifiedEntities(boolean backup, boolean generateJavaTypes) {
        for (EntityInfo ei : new HashSet<EntityInfo>(this.modifiedEntityInfos)) {
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("Updating entity " + ei.getEntityName()));
            }
            String path = this.getRelServicePath(this.entityNameToPath.get(ei.getEntityName()));
            this.writeMappingResource(ei, path, backup);
            if (generateJavaTypes) {
                this.writeJavaType(ei, backup);
            }
            this.modifiedEntityInfos.remove(ei);
        }
    }

    private void writeJavaType(EntityInfo entity, boolean backup) {
        ArrayList<EntityInfo> c = new ArrayList<EntityInfo>(1);
        c.add(entity);
        Service s = DataServiceUtils.toService(c);
        s.setId(this.name);
        HashSet<String> serializableTypes = new HashSet<String>();
        for (EntityInfo ei : this.getEntities()) {
            PropertyInfo id = ei.getId();
            if (!id.hasCompositeProperties()) continue;
            serializableTypes.add(id.getFullyQualifiedType());
        }
        ServiceDataObjectGenerator gen = new ServiceDataObjectGenerator(s, DataServiceConstants.DEFAULT_COLLECTION_TYPE);
        gen.setSerializableTypes(serializableTypes);
        gen.setEqualsHashCodeTypes(serializableTypes);
        while (gen.hasNext()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                String relPath = this.getTypePath(gen.getCurrentTypeName());
                if (backup) {
                    this.backup(relPath);
                }
                String path = this.getRelServicePath(relPath);
                gen.generateNext(baos);
                if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                    DataServiceLoggers.parserLogger.info((Object)("Writing java type " + relPath));
                }
                if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                    DataServiceLoggers.parserLogger.debug((Object)("File content==========================\n" + baos.toString() + "\n=========================="));
                }
                this.fileService.writeFile(path, baos.toString());
            }
            catch (IOException ex) {
                throw new ConfigurationException(ex);
            }
        }
    }

    private void writeMappingResource(EntityInfo ei, String path, boolean backup) {
        StringWriter sw = new StringWriter();
        HbmWriter w = new HbmWriter(new PrintWriter(sw));
        w.setEntity(ei);
        w.write();
        try {
            if (backup) {
                this.backup(path);
            }
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("Writing mapping file " + path));
            }
            if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                DataServiceLoggers.parserLogger.debug((Object)("File content==========================\n" + sw.toString() + "\n=========================="));
            }
            this.fileService.writeFile(path, sw.toString());
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
    }

    private synchronized void saveDeletedQueries(boolean backup) {
        for (String path : new HashSet<String>(this.deletedQueries)) {
            String relPath = this.getRelServicePath(path);
            if (backup) {
                this.backup(relPath);
            }
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("Deleting query file at " + path));
            }
            this.fileService.deleteFile(relPath);
            this.deletedQueries.remove(path);
        }
    }

    private synchronized void saveModifiedQueries(boolean backup) {
        HashSet<HbmQueryParser> s = new HashSet<HbmQueryParser>(this.modifiedQueryParsers);
        for (HbmQueryParser p : s) {
            StringWriter sw = new StringWriter();
            HbmQueryWriter w = new HbmQueryWriter(new PrintWriter(sw));
            w.setMeta(p.getMeta());
            w.setQueries(p.getQueries().values());
            w.write();
            String path = this.getRelServicePath(this.parserToPath.get(p));
            if (backup) {
                this.backup(path);
            }
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("Writing query mapping file " + path));
            }
            String fileContent = sw.toString();
            this.modifiedQueryParsers.remove(p);
            try {
                this.fileService.writeFile(path, fileContent);
            }
            catch (IOException ex) {
                throw new ConfigurationException(ex);
            }
            if (!DataServiceLoggers.parserLogger.isDebugEnabled()) continue;
            DataServiceLoggers.parserLogger.debug((Object)("File content==========================\n" + fileContent + "\n=========================="));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateService(UpdateCallback callback) {
        DeprecatedServiceDefinition def = null;
        try {
            DataServiceOperation op;
            def = this.initRuntimeDataServiceDefinition();
            DataServiceDefinition dataDef = DataServiceUtils.unwrapAndCast(def);
            dataDef.getMetaData().setServiceClassName(this.externalConfig.getServiceClass());
            for (String q : this.modifiedQueryNames) {
                op = dataDef.getOperation(q);
                if (op.requiresResultWrapper()) {
                    this.generateWrapperType(op, true);
                }
                String in = dataDef.inputTypesToString(q);
                String out = dataDef.outputTypeToString(q);
                if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                    DataServiceLoggers.parserLogger.debug((Object)("Updated query " + q + " InputTypes: " + in + " OutputType " + out));
                }
                QueryInfo qi = this.queryNameToQueryInfo.get(q);
                qi.setOutputType(out);
            }
            for (String operationName : dataDef.getOperationNames()) {
                op = dataDef.getOperation(operationName);
                if (!op.isQuery() || !op.requiresResultWrapper() || this.modifiedQueryNames.contains(op.getQueryName())) continue;
                this.generateWrapperType(op, false);
            }
            HashSet<String> fqTypeNames = new HashSet<String>(this.outputTypes.size());
            for (BeanInfo bi : this.outputTypes.values()) {
                fqTypeNames.add(bi.getFullyQualifiedName());
            }
            dataDef.getMetaData().setHelperClassNames(fqTypeNames);
            callback.update(dataDef);
        }
        finally {
            if (def != null) {
                def.dispose();
            }
        }
        this.modifiedQueryNames.clear();
    }

    private String getTypePath(String fqName) {
        return StringUtils.packageToSrcFilePath((String)fqName) + ".java";
    }

    private void generateWrapperType(DataServiceOperation op, boolean write) {
        String oldPath = StringUtils.packageToSrcFilePath((String)com.wavemaker.runtime.data.util.DataServiceUtils.getOldOutputType(this.getDataPackage(), op.getName())) + ".java";
        oldPath = this.getRelServicePath(oldPath);
        write = write || !new File(oldPath).exists();
        String fqName = com.wavemaker.runtime.data.util.DataServiceUtils.getOutputType(this.getDataPackage(), op.getName());
        if (write) {
            String outputWrapper = this.generator.generate(fqName, op);
            String path = this.getTypePath(fqName);
            if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                DataServiceLoggers.parserLogger.debug((Object)("Generating return type for " + op.getName() + ": " + path));
            }
            try {
                path = this.getRelServicePath(path);
                this.fileService.writeFile(path, outputWrapper);
            }
            catch (IOException ex) {
                throw new ConfigurationException(ex);
            }
        }
        op.setOutputType(fqName);
        this.outputTypes.put((String)StringUtils.splitPackageAndClass((String)fqName).v2, this.generator.getBeanInfo());
    }

    private void backup(String path) {
        try {
            String original = null;
            try {
                original = this.fileService.readFile(path);
            }
            catch (FileNotFoundException ex) {
                return;
            }
            String backupPath = path + BACKUP_SUFFIX;
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("Writing backup file " + backupPath));
            }
            this.fileService.writeFile(backupPath, original);
            this.writtenBackupFiles.add(backupPath);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
    }

    private Map<String, TypeInfo> initValueTypesForEntity(EntityInfo ei) {
        HashMap<String, TypeInfo> rtn = new HashMap<String, TypeInfo>();
        if (ei.getProperties() == null) {
            return rtn;
        }
        ArrayList<PropertyInfo> props = new ArrayList<PropertyInfo>();
        props.addAll(ei.getProperties());
        while (!props.isEmpty()) {
            PropertyInfo pi = (PropertyInfo)props.remove(0);
            if (pi.getColumn() == null && !this.isEntityType(pi.getFullyQualifiedType())) {
                TypeInfo v = new TypeInfo(pi.getType(), ei.getPackageName());
                rtn.put(v.getName(), v);
            }
            if (pi.getCompositeProperties() == null) continue;
            props.addAll(pi.getCompositeProperties());
        }
        return rtn;
    }

    private void addCompositeProperties(PropertyInfo p, TreeNode n) {
        if (p.getCompositeProperties() == null || p.getCompositeProperties().isEmpty()) {
            return;
        }
        for (PropertyInfo p2 : p.getCompositeProperties()) {
            TreeNode n2 = this.formatTreeNode(new TreeNode(), p2);
            n.addChild(n2);
            this.addCompositeProperties(p2, n2);
        }
    }

    private TreeNode formatTreeNode(TreeNode n, PropertyInfo p) {
        String content = p.getName() + " (" + p.getType() + ")";
        if (p.getIsId()) {
            n.setImage("images/key_16.png");
        }
        if (p.getIsRelated()) {
            n.addData("REL");
            if (p.getIsInverse()) {
                n.setImage("images/to_many_16.png");
            } else {
                n.setImage("images/to_one_16.png");
            }
        } else if (p.getColumn() == null) {
            n.addData("PROP");
        } else {
            n.addData("COL");
        }
        n.addData(p.getName());
        n.addData(p.getFullyQualifiedType());
        if (n.getData().get(0).equals("COL")) {
            n.addData(p.getColumn().getName());
        }
        if (p.getIsId()) {
            n.addData("pk");
        } else if (p.getIsRelated()) {
            if (p.getIsInverse()) {
                n.addData(RelatedInfo.Cardinality.OneToMany.toString());
            } else {
                n.addData(RelatedInfo.Cardinality.OneToOne.toString());
            }
        }
        n.setContent(content);
        return n;
    }

    private Map<String, ColumnInfo> initColumns(String entity) {
        HashMap<String, ColumnInfo> pkCols = new HashMap<String, ColumnInfo>();
        HashMap<String, ColumnInfo> fkCols = new HashMap<String, ColumnInfo>();
        LinkedHashSet<ColumnInfo> allColumns = new LinkedHashSet<ColumnInfo>();
        for (PropertyInfo p : this.getProperties(entity)) {
            if (p.getIsRelated() && p.getIsInverse()) continue;
            for (ColumnInfo ci : p.allColumns()) {
                allColumns.add(ci);
                if (ci.getIsPk()) {
                    pkCols.put(ci.getName(), ci);
                }
                if (!ci.getIsFk()) continue;
                fkCols.put(ci.getName(), ci);
            }
        }
        for (ColumnInfo fk : fkCols.values()) {
            if (!pkCols.containsKey(fk.getName())) continue;
            ColumnInfo pk = (ColumnInfo)pkCols.get(fk.getName());
            pk.setIsFk(true);
            allColumns.remove(fk);
        }
        LinkedHashMap<String, ColumnInfo> rtn = new LinkedHashMap<String, ColumnInfo>(allColumns.size());
        for (ColumnInfo ci : allColumns) {
            rtn.put(ci.getName(), ci);
        }
        return rtn;
    }

    private void setup() {
        this.addRegisteredFiles();
    }

    private HbmQueryParser getParserForQuery(QueryInfo qi) {
        if (this.queryNameToParser.containsKey(qi.getName())) {
            return this.queryNameToParser.get(qi.getName());
        }
        return this.getDefaultQueryParser();
    }

    private HbmQueryParser getDefaultQueryParser() {
        if (this.defaultQueryParser == null) {
            throw new ConfigurationException("No default query store configured");
        }
        return this.defaultQueryParser;
    }

    private void addEntityToSpringFile(String path) {
        this.springConfiguration.addMapping(path);
    }

    private void removeMappingFromSpringFile(String path) {
        this.springConfiguration.removeMapping(path);
    }

    private synchronized Map<String, QueryInfo> getHibernateQueries() {
        if (this.queryNameToQueryInfo != null) {
            return this.queryNameToQueryInfo;
        }
        this.queryNameToQueryInfo = new HashMap<String, QueryInfo>();
        this.queryNameToParser = new HashMap<String, HbmQueryParser>();
        for (String path : this.queryFiles) {
            HbmQueryParser p = this.initHbmQueryParser(path);
            this.parserToPath.put(p, path);
            String meta = p.getMeta();
            if (meta != null && DataServiceUtils.isDefaultQueryStore(meta)) {
                this.defaultQueryParser = p;
            }
            Collection<QueryInfo> queryInfos = p.getQueries().values();
            for (QueryInfo q : queryInfos) {
                if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                    DataServiceLoggers.parserLogger.debug((Object)("Processing HQL query: \"" + q.getName() + "\""));
                }
                this.queryNameToQueryInfo.put(q.getName(), q);
                this.queryNameToParser.put(q.getName(), p);
                String operationName = com.wavemaker.runtime.data.util.DataServiceUtils.queryToOperationName(q.getName());
                q.setReturnsSingleResult(this.externalConfig.returnsSingleResult(operationName));
                q.setOutputType(this.externalConfig.getOutputType(operationName));
            }
        }
        return this.queryNameToQueryInfo;
    }

    private HbmParser initHbmParser(String path) {
        String relpath = this.getRelServicePath(path);
        if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
            DataServiceLoggers.parserLogger.debug((Object)("Parsing mapping " + relpath));
        }
        String s = null;
        try {
            s = this.fileService.readFile(relpath);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        HbmParser rtn = new HbmParser(s);
        rtn.initAll();
        EntityInfo ei = rtn.getEntity();
        this.entityNameToHbmParser.put(ei.getEntityName(), rtn);
        return rtn;
    }

    private HbmQueryParser initHbmQueryParser(String path) {
        String relpath = this.getRelServicePath(path);
        if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
            DataServiceLoggers.parserLogger.debug((Object)("Parsing queries " + relpath));
        }
        String s = null;
        try {
            s = this.fileService.readFile(relpath);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        HbmQueryParser rtn = new HbmQueryParser(s);
        rtn.initAll();
        return rtn;
    }

    private EntityInfo initEntityInfo(String path) {
        HbmParser parser = this.initHbmParser(path);
        this.parserToPath.put(parser, path);
        EntityInfo rtn = parser.getEntity();
        String fq = StringUtils.fq((String)rtn.getPackageName(), (String)rtn.getEntityName());
        rtn.setRefreshEntity(this.getRefreshEntities().contains(fq));
        return rtn;
    }

    private String getRelServicePath(String relPath) {
        StringBuilder sb = new StringBuilder(this.cfgPath.length() + relPath.length() + 1);
        sb.append(this.cfgPath).append("/").append(relPath);
        return sb.toString();
    }

    private void addRegisteredFiles() {
        List<String> mappings = this.springConfiguration.getMappings();
        for (String s : mappings) {
            try {
                if (s.endsWith(".hbm.xml")) {
                    this.addMappingDocument(s);
                    continue;
                }
                if (s.endsWith(".ql.xml")) {
                    this.addQueryDocument(s);
                    continue;
                }
                if (s.endsWith(".hql.xml")) {
                    this.addQueryDocument(s);
                    continue;
                }
                throw new ConfigurationException("Unknown resource type");
            }
            catch (RuntimeException ex) {
                if (!DataServiceLoggers.parserLogger.isWarnEnabled()) continue;
                String msg = "Unable to process mapping resource \"" + s + "\"";
                if (!ObjectUtils.isNullOrEmpty((String)ex.getMessage())) {
                    msg = msg + ": " + ex.getMessage();
                }
                DataServiceLoggers.parserLogger.warn((Object)msg);
                if (!DataServiceLoggers.parserLogger.isDebugEnabled()) continue;
                DataServiceLoggers.parserLogger.debug((Object)StringUtils.toString((Throwable)ex));
            }
        }
        this.initEntityInfos();
    }

    private void initEntityInfos() {
        for (EntityInfo ei : this.getEntities()) {
            ei.initFkColumnTypes(this);
            this.valueTypes.putAll(this.initValueTypesForEntity(ei));
        }
    }

    private void removeServiceClass() {
        String packageName = (String)StringUtils.splitPackageAndClass((String)this.externalConfig.getServiceClass()).v1;
        for (String s : DataServiceUtils.getServiceClassNames(packageName, this.name)) {
            s = StringUtils.classNameToSrcFilePath((String)s);
            String path = this.getRelServicePath(s);
            this.fileService.deleteFile(path);
        }
    }

    private DeprecatedServiceDefinition initRuntimeDataServiceDefinition() {
        DeprecatedServiceDefinition rtn = (DeprecatedServiceDefinition)ClassLoaderUtils.runInClassLoaderContext((ClassLoaderUtils.TaskType)new ClassLoaderUtils.TaskRtn(){

            public Object run() {
                return SpringService.initialize(DataModelConfiguration.this.cfgFile);
            }
        }, (ClassLoader)this.classLoaderFactory.getClassLoader());
        return rtn;
    }

    private void setBindParameters(QueryRunner queryRunner, Input[] inputs, String values, boolean includeNullValues) {
        ArrayList<String> names = new ArrayList<String>(inputs.length);
        ArrayList<String> types = new ArrayList<String>(inputs.length);
        ArrayList<Boolean> isList = new ArrayList<Boolean>(inputs.length);
        for (int i = 0; i < inputs.length; ++i) {
            names.add(inputs[i].getParamName());
            types.add(inputs[i].getParamType());
            isList.add(inputs[i].getList());
        }
        if (includeNullValues || !ObjectUtils.isNullOrEmpty((String)values)) {
            queryRunner.addBindParameters(names, types, values, isList);
        }
    }

    public static interface UpdateCallback {
        public void update(DataServiceDefinition var1);
    }
}

