/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.common.util.XMLWriter;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.DataServiceSpringConfiguration;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.deployment.ServiceDeployment;
import com.wavemaker.tools.project.Project;
import com.wavemaker.tools.service.DesignServiceManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModelDeploymentConfiguration
implements ServiceDeployment {
    public static final String JNDI_NAME_PROPERTY = "jndi.dsname";
    private static final String COMP_ENV = "java:comp/env/";
    public static final String RESOURCE_REF = "resource-ref";
    private static final String RESOURCE_NAME = "res-ref-name";
    private static final String RESOURCE_TYPE = "res-type";
    private static final String DEFAULT_RESOURCE_TYPE = "javax.sql.DataSource";
    private static final String RESOURCE_AUTH = "res-auth";
    private static final String DEFAULT_RESOURCE_AUTH = "Container";
    private static final String RESOURCE_SHARING_SCOPE = "res-sharing-scope";
    private static final String DEFAULT_RESOURCE_SHARING_SCOPE = "Shareable";
    private static final String WEB_XML_INSERT_BEFORE = "</web-app>";

    @Override
    public void prepare(String serviceName, Map<String, String> properties, DesignServiceManager mgr) {
        if (!properties.containsKey(JNDI_NAME_PROPERTY)) {
            return;
        }
        String rootPath = DesignServiceManager.getRuntimeRelativeDir(serviceName);
        String cfgFile = DataServiceUtils.getCfgFileName(serviceName);
        Project fs = mgr.getProjectManager().getCurrentProject();
        DataServiceSpringConfiguration cfg = new DataServiceSpringConfiguration(fs, rootPath, cfgFile, serviceName);
        String jndiName = properties.get(JNDI_NAME_PROPERTY);
        this.configureJNDI(cfg, jndiName);
        this.configureProperties(cfg);
        this.configureResourceRef(mgr, jndiName);
    }

    private void configureJNDI(DataServiceSpringConfiguration cfg, String jndiName) {
        cfg.configureJNDIDataSource(jndiName);
        cfg.write();
    }

    private void configureProperties(DataServiceSpringConfiguration cfg) {
        Properties props = cfg.readProperties();
        Properties newProps = new Properties();
        Iterator iter = CastUtils.cast(props.keySet().iterator());
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.endsWith(".dialect")) continue;
            newProps.setProperty(key, props.getProperty(key));
        }
        cfg.writeProperties(newProps, false);
    }

    private void configureResourceRef(DesignServiceManager mgr, String jndiName) {
        int i = jndiName.indexOf(COMP_ENV);
        if (i == -1) {
            return;
        }
        String appScopedJndiName = jndiName.substring(COMP_ENV.length());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        XMLWriter writer = XMLUtils.newXMLWriter((PrintWriter)pw);
        writer.setStartIndent(4);
        writer.addElement(RESOURCE_REF, new String[]{"id", appScopedJndiName.replace("/", "_")});
        writer.addElement(RESOURCE_NAME, appScopedJndiName);
        writer.addElement(RESOURCE_TYPE, DEFAULT_RESOURCE_TYPE);
        writer.addElement(RESOURCE_AUTH, DEFAULT_RESOURCE_AUTH);
        writer.addElement(RESOURCE_SHARING_SCOPE, DEFAULT_RESOURCE_SHARING_SCOPE);
        writer.finish();
        this.addToWebXml(mgr, writer.getLineSep() + sw.toString() + writer.getLineSep());
        pw.close();
    }

    private void addToWebXml(DesignServiceManager mgr, String xmlSnippet) {
        File webXml = mgr.getProjectManager().getCurrentProject().getWebXml();
        try {
            String s = FileUtils.readFileToString((File)webXml, (String)"UTF-8");
            int i = s.indexOf(WEB_XML_INSERT_BEFORE);
            if (i == -1) {
                throw new AssertionError((Object)"Could not find marker in web.xml: </web-app>");
            }
            s = s.substring(0, i) + xmlSnippet + s.substring(i);
            FileUtils.writeStringToFile((File)webXml, (String)s, (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
    }
}

