/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.IOUtils;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.OneToManyMap;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.runtime.client.TreeNode;
import com.wavemaker.runtime.data.DataServiceInternal;
import com.wavemaker.runtime.data.ExternalDataModelConfig;
import com.wavemaker.runtime.data.util.JDBCUtils;
import com.wavemaker.runtime.service.definition.ServiceDefinition;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.BaseDataModelSetup;
import com.wavemaker.tools.data.ColumnInfo;
import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.DataServiceDefinition;
import com.wavemaker.tools.data.DataServiceLoggers;
import com.wavemaker.tools.data.DesignExternalDataModelConfig;
import com.wavemaker.tools.data.EntityInfo;
import com.wavemaker.tools.data.ExportDB;
import com.wavemaker.tools.data.ImportDB;
import com.wavemaker.tools.data.InitData;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.QueryInfo;
import com.wavemaker.tools.data.RelatedInfo;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.project.DeploymentManager;
import com.wavemaker.tools.project.ProjectManager;
import com.wavemaker.tools.service.ClassLoaderFactory;
import com.wavemaker.tools.service.CompileService;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Service;
import com.wavemaker.tools.util.AntUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModelManager {
    private static final String DATABASES_NODE = "Databases";
    private static final String LIVETABLES_NODE = "LiveTables";
    private static final String QUERIES_NODE = "Queries";
    public static final String HSQL_SAMPLE_DB_SUB_DIR = "data";
    public static final String HSQLDB = ":hsqldb:";
    public static final String HSQLFILE_PROP = "hsqldbFile";
    private final OneToManyMap<String, String> dataModelNames = new OneToManyMap();
    private final Map<DataModelKey, DataModelConfiguration> dataModels = new HashMap<DataModelKey, DataModelConfiguration>();
    private final Collection<String> importedDataModels = new HashSet<String>();
    private ProjectManager projectManager = null;
    private DesignServiceManager serviceManager = null;

    public void setProjectManager(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public void setDesignServiceManager(DesignServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void importDatabase(String username, String password, String connectionUrl, String serviceId, String packageName, String tableFilter, String schemaFilter, String catalogName, String driverClassName, String dialectClassName, String revengNamingStrategyClassName) {
        this.serviceManager.validateServiceId(serviceId);
        File outputDir = this.getServicePath(serviceId);
        File classesDir = this.projectManager.getCurrentProject().getWebInfClasses();
        BaseDataModelSetup importer = null;
        try {
            importer = this.runImporter(username, password, connectionUrl, serviceId, packageName, tableFilter, schemaFilter, catalogName, driverClassName, dialectClassName, revengNamingStrategyClassName, outputDir, classesDir);
            this.registerService(serviceId, (ImportDB)importer);
            String hsqldbFileName = null;
            if (connectionUrl.contains(HSQLDB)) {
                int n = connectionUrl.indexOf("/data") + 6;
                String partialCxn = connectionUrl.substring(n);
                int k = partialCxn.indexOf(59);
                hsqldbFileName = partialCxn.substring(0, k);
                Properties props = importer.getProperties();
                props.setProperty(HSQLFILE_PROP, hsqldbFileName);
                this.getDataModel(serviceId).writeConnectionProperties(props);
            }
        }
        catch (RuntimeException ex) {
            try {
                this.serviceManager.deleteService(serviceId);
            }
            catch (IOException ignore) {
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            if (importer != null) {
                importer.dispose();
            }
        }
    }

    public String getExportDDL(String username, String password, String connectionUrl, String serviceId, String schemaFilter, String driverClassName, String dialectClassName, boolean overrideTable) {
        if (connectionUrl.contains(HSQLDB)) {
            connectionUrl = this.reWriteCxnUrlForHsqlDB(connectionUrl);
        }
        ExportDB exporter = this.getExporter(username, password, connectionUrl, serviceId, schemaFilter, driverClassName, dialectClassName, overrideTable);
        exporter.setExportToDB(false);
        exporter.setVerbose(false);
        try {
            exporter.run();
            String string = exporter.getDDL();
            return string;
        }
        catch (RuntimeException ex) {
            throw com.wavemaker.runtime.data.util.DataServiceUtils.unwrap(ex);
        }
        finally {
            exporter.dispose();
        }
    }

    public String exportDatabase(String username, String password, String connectionUrl, String serviceId, String schemaFilter, String driverClassName, String dialectClassName, String revengNamingStrategyClassName, boolean overrideTable) {
        if (connectionUrl.contains(HSQLDB)) {
            connectionUrl = this.reWriteCxnUrlForHsqlDB(connectionUrl);
        }
        ExportDB exporter = this.getExporter(username, password, connectionUrl, serviceId, schemaFilter, driverClassName, dialectClassName, overrideTable);
        String rtn = "";
        String hsqldbFileName = null;
        if (connectionUrl.contains(HSQLDB)) {
            hsqldbFileName = this.extractHsqlDBFileName(connectionUrl);
        }
        exporter.setExportToDB(true);
        try {
            exporter.run();
            StringBuilder sb = new StringBuilder();
            for (Throwable th : exporter.getErrors()) {
                sb.append(th.getMessage());
                sb.append(SystemUtils.getLineBreak());
                sb.append(SystemUtils.getLineBreak());
            }
            rtn = sb.toString().trim();
            if (connectionUrl.contains(HSQLDB)) {
                Properties props = exporter.getProperties();
                props.setProperty(HSQLFILE_PROP, hsqldbFileName);
                this.getDataModel(serviceId).writeConnectionProperties(props);
            } else {
                this.getDataModel(serviceId).writeConnectionProperties(exporter.getProperties());
            }
        }
        catch (RuntimeException ex) {
            throw com.wavemaker.runtime.data.util.DataServiceUtils.unwrap(ex);
        }
        finally {
            exporter.dispose();
        }
        return rtn;
    }

    public void reImport(String dataModelName, String username, String password, String connectionUrl, String tableFilter, String schemaFilter, String driverClassName, String dialectClassName, String revengNamingStrategyClassName) {
        this.reImport(this.getDataModel(dataModelName), username, password, connectionUrl, dataModelName, tableFilter, schemaFilter, driverClassName, dialectClassName, revengNamingStrategyClassName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reImport(DataModelConfiguration cfg, String username, String password, String connectionUrl, String serviceId, String tableFilter, String schemaFilter, String driverClassName, String dialectClassName, String revengNamingStrategyClassName, String catalogName) {
        BaseDataModelSetup importer = null;
        DataModelConfiguration tmpCfg = null;
        File tmpServiceRoot = null;
        try {
            tmpServiceRoot = IOUtils.createTempDirectory();
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        Collection<QueryInfo> queries = cfg.getQueries();
        try {
            String packageName = cfg.getDataPackage();
            if (packageName.endsWith(".data")) {
                packageName = StringUtils.fromLastOccurrence((String)packageName, (String)HSQL_SAMPLE_DB_SUB_DIR, (int)-1);
            }
            importer = this.runImporter(username, password, connectionUrl, serviceId, packageName, tableFilter, schemaFilter, catalogName, driverClassName, dialectClassName, revengNamingStrategyClassName, tmpServiceRoot, tmpServiceRoot);
            File tmpCfgFile = new File(tmpServiceRoot, serviceId + ".spring.xml");
            tmpCfg = new DataModelConfiguration(tmpCfgFile);
            tmpCfg.addUserQueries(queries);
            tmpCfg.save(true);
            tmpCfg.revert();
            if (tmpCfg.getEntityNames().isEmpty()) {
                throw new ConfigurationException("ReImport didn't create any types");
            }
            cfg.dispose();
            try {
                this.serviceManager.deleteServiceSmd(serviceId);
            }
            catch (IOException ex) {
                throw new ConfigurationException(ex);
            }
            catch (NoSuchMethodException ex) {
                throw new ConfigurationException(ex);
            }
            File serviceRoot = this.getServicePath(serviceId);
            AntUtils.copyDir(tmpServiceRoot, serviceRoot, null, "**/*.class");
            File classesDir = this.projectManager.getCurrentProject().getWebInfClasses();
            AntUtils.copyDir(tmpServiceRoot, classesDir, "**/*.class", null);
            this.registerService(serviceId, (ImportDB)importer);
            DataModelConfiguration dmc = this.getDataModel(serviceId);
            dmc.addUserQueries(queries);
            this.save(serviceId, dmc, false, false);
            String hsqldbFileName = null;
            if (connectionUrl.contains(HSQLDB)) {
                hsqldbFileName = this.extractHsqlDBFileName(connectionUrl);
                Properties props = importer.getProperties();
                props.setProperty(HSQLFILE_PROP, hsqldbFileName);
                this.getDataModel(serviceId).writeConnectionProperties(props);
            }
        }
        finally {
            if (importer != null) {
                importer.dispose();
            }
            if (tmpCfg != null) {
                tmpCfg.dispose();
            }
            try {
                IOUtils.deleteRecursive((File)tmpServiceRoot);
            }
            catch (IOException ignore) {}
        }
    }

    public void dispose(String projectName) {
        Collection c = this.dataModelNames.get((Object)projectName);
        if (c == null) {
            return;
        }
        for (String dataModelName : new HashSet(c)) {
            DataModelKey key = this.getKey(projectName, dataModelName);
            this.remove(key);
        }
    }

    public void removeDataModel(String dataModelName) {
        this.remove(dataModelName);
        try {
            this.serviceManager.deleteService(dataModelName);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public void newDataModel(String dataModelName) {
        this.serviceManager.validateServiceId(dataModelName);
        File destDir = this.getServicePath(dataModelName);
        String serviceClassPackage = DataServiceUtils.getDefaultPackage(dataModelName);
        String dataPackage = DataServiceUtils.getDefaultDataPackage(dataModelName);
        DataServiceUtils.createEmptyDataModel(destDir, dataModelName, serviceClassPackage, dataPackage);
        DataModelConfiguration cfg = this.initialize(dataModelName, true);
        String serviceClass = StringUtils.fq((String)serviceClassPackage, (String)StringUtils.upperCaseFirstLetter((String)dataModelName));
        this.serviceManager.defineService(new DataServiceDefinition(dataModelName, cfg, this.serviceManager, serviceClass));
        this.save(dataModelName, cfg, true, true);
    }

    public void updateEntity(String dataModelName, String entityName, EntityInfo entity, boolean save) {
        DataModelConfiguration mgr = null;
        mgr = this.getDataModel(dataModelName);
        mgr.updateEntity(entityName, entity);
        if (save) {
            this.save(dataModelName, mgr);
        }
    }

    public void deleteEntity(String dataModelName, String entityName) {
        if (ObjectUtils.isNullOrEmpty((String)dataModelName)) {
            throw new IllegalArgumentException("dataModelName must bet set");
        }
        if (ObjectUtils.isNullOrEmpty((String)entityName)) {
            throw new IllegalArgumentException("entityName must be set");
        }
        DataModelConfiguration cfg = this.getDataModel(dataModelName);
        cfg.deleteEntity(entityName);
        this.save(dataModelName, cfg);
    }

    public void deleteQuery(String dataModelName, String queryName) {
        if (ObjectUtils.isNullOrEmpty((String)dataModelName)) {
            throw new IllegalArgumentException("dataModelName must bet set");
        }
        if (ObjectUtils.isNullOrEmpty((String)queryName)) {
            throw new IllegalArgumentException("queryName must be set");
        }
        DataModelConfiguration cfg = this.getDataModel(dataModelName);
        cfg.deleteQuery(queryName);
        this.save(dataModelName, cfg, false, false);
    }

    public void updateColumns(String dataModelName, String entityName, List<ColumnInfo> columns, List<PropertyInfo> properties) {
        DataModelConfiguration mgr = this.getDataModel(dataModelName);
        mgr.updateColumns(entityName, columns, properties);
    }

    public void updateRelated(String dataModelName, String entityName, RelatedInfo[] related) {
        DataModelConfiguration mgr = this.getDataModel(dataModelName);
        mgr.updateRelated(entityName, Arrays.asList(related));
        this.save(dataModelName, mgr);
    }

    public void updateQuery(String dataModelName, QueryInfo query) {
        this.initialize(false);
        DataModelConfiguration mgr = this.getDataModel(dataModelName);
        mgr.updateQuery(query);
        this.save(dataModelName, mgr, false, false);
    }

    private void save(String dataModelName, DataModelConfiguration cfg) {
        this.save(dataModelName, cfg, false, true);
    }

    private void save(final String dataModelName, final DataModelConfiguration mgr, boolean forceUpdate, boolean compile) {
        final ExternalDataModelConfig extCfg = new ExternalDataModelConfig(){

            public boolean returnsSingleResult(String operationName) {
                return mgr.getQueryByOperationName(operationName).getReturnsSingleResult();
            }

            public String getOutputType(String operationName) {
                return mgr.getQueryByOperationName(operationName).getOutputType();
            }

            public String getServiceClass() {
                return DataModelManager.this.serviceManager.getService(dataModelName).getClazz();
            }
        };
        try {
            mgr.save(true, new DataModelConfiguration.UpdateCallback(){

                public void update(com.wavemaker.runtime.data.DataServiceDefinition def) {
                    def.setExternalConfig(extCfg);
                    DataModelManager.this.setupElementTypeFactory(def.getServiceId(), def);
                    DataModelManager.this.serviceManager.defineService(def);
                }
            }, forceUpdate, compile);
            mgr.removeBackupFiles();
        }
        catch (RuntimeException ex) {
            mgr.revert();
            mgr.dispose();
            this.initialize(dataModelName, true);
            throw com.wavemaker.runtime.data.util.DataServiceUtils.unwrap(ex);
        }
    }

    public void validate(String dataModelName) {
        this.validate(this.getDataModel(dataModelName));
    }

    public InitData getTypeRefTree() {
        InitData rtn = new InitData(this.getDatabaseObjectsTree(DATABASES_NODE, true));
        for (String dataModelName : this.getDataModelNames()) {
            DataModelConfiguration mgr = this.getDataModel(dataModelName);
            rtn.addValueTypes(dataModelName, mgr.getValueTypes());
        }
        return rtn;
    }

    public InitData getQueriesTree() {
        InitData rtn = new InitData(this.getDatabaseObjectsTree(DATABASES_NODE, false));
        for (String dataModelName : this.getDataModelNames()) {
            DataModelConfiguration mgr = this.getDataModel(dataModelName);
            rtn.addValueTypes(dataModelName, mgr.getValueTypes());
        }
        return rtn;
    }

    public Collection<String> getDataModelNames() {
        this.initialize(false);
        if (this.dataModelNames.containsKey((Object)this.getProjectName())) {
            return new TreeSet<String>(this.dataModelNames.get((Object)this.getProjectName()));
        }
        return Collections.emptySet();
    }

    public DataModelConfiguration getDataModel(String name) {
        this.initialize(false);
        DataModelKey k = this.getKey(name);
        if (!this.dataModels.containsKey(k)) {
            throw new ConfigurationException("Unknown data model " + name + ".  Known ones are " + this.getDataModelNames());
        }
        return this.dataModels.get(k);
    }

    public void reload() {
        this.initialize(true);
    }

    private ExportDB getExporter(String username, String password, String connectionUrl, String serviceId, String schemaFilter, String driverClassName, String dialectClassName, boolean overrideTable) {
        if (connectionUrl.contains(HSQLDB)) {
            connectionUrl = this.reWriteCxnUrlForHsqlDB(connectionUrl);
        }
        this.compile();
        DataModelConfiguration mgr = this.getDataModel(serviceId);
        File serviceDir = this.getServicePath(serviceId);
        List<String> mappingPaths = mgr.getMappings();
        if (mappingPaths == null || mappingPaths.isEmpty()) {
            throw new ConfigurationException("No entities to export");
        }
        String path = mappingPaths.iterator().next();
        File hbmFiles = new File(serviceDir, new File(path).getParent());
        File classesDir = this.projectManager.getCurrentProject().getWebInfClasses();
        ExportDB exporter = new ExportDB();
        exporter.setHbmFilesDir(hbmFiles);
        exporter.setClassesDir(classesDir);
        exporter.setUsername(username);
        exporter.setPassword(password);
        exporter.setConnectionUrl(connectionUrl);
        exporter.setVerbose(true);
        exporter.setOverrideTable(overrideTable);
        if (!ObjectUtils.isNullOrEmpty((String)driverClassName)) {
            exporter.setDriverClassName(driverClassName);
        }
        if (!ObjectUtils.isNullOrEmpty((String)dialectClassName)) {
            exporter.setDialect(dialectClassName);
        }
        exporter.init();
        if (ObjectUtils.isNullOrEmpty((String)schemaFilter)) {
            schemaFilter = ".*";
            if (exporter.isOracle()) {
                schemaFilter = username.toUpperCase();
            } else if (exporter.isSQLServer()) {
                schemaFilter = "dbo";
            }
        }
        return exporter;
    }

    public void compile() {
        this.serviceManager.getDeploymentManager().build();
    }

    private void registerService(String serviceId, ImportDB importer) {
        this.initialize(serviceId, true);
        ServiceDefinition def = DataServiceUtils.unwrap(importer.getServiceDefinition());
        this.setupElementTypeFactory(serviceId, (DataServiceInternal)((Object)def));
        this.serviceManager.defineService(def);
    }

    private void validate(DataModelConfiguration mgr) {
        mgr.initRuntime();
    }

    private void setupElementTypeFactory(String serviceId, DataServiceInternal di) {
        DataModelConfiguration mgr = this.getDataModel(serviceId);
        DataServiceUtils.setupElementTypeFactory(mgr, di);
    }

    private List<TreeNode> getDatabaseObjectsTree(String rootNodeName, boolean getTypes) {
        TreeNode rtn = new TreeNode(rootNodeName);
        rtn.setClosed(false);
        rtn.addData("DBOBJS");
        rtn.addData(rtn.getContent());
        for (String dataModelName : this.getDataModelNames()) {
            DataModelConfiguration mgr = this.getDataModel(dataModelName);
            TreeNode dataModelNode = new TreeNode(dataModelName);
            dataModelNode.setClosed(false);
            dataModelNode.addData("DB");
            dataModelNode.addData(dataModelNode.getContent());
            rtn.addChild(dataModelNode);
            if (getTypes) {
                TreeNode dataObjectsNode = new TreeNode(LIVETABLES_NODE);
                dataObjectsNode.setClosed(false);
                dataObjectsNode.addData("TPS");
                dataObjectsNode.addData(dataObjectsNode.getContent());
                dataModelNode.addChild(dataObjectsNode);
                mgr.addDataObjectTree(dataObjectsNode);
                continue;
            }
            TreeNode queriesNode = new TreeNode(QUERIES_NODE);
            queriesNode.setClosed(false);
            queriesNode.addData("QRS");
            queriesNode.addData(queriesNode.getContent());
            dataModelNode.addChild(queriesNode);
            mgr.addQueryTree(queriesNode);
        }
        ArrayList<TreeNode> a = new ArrayList<TreeNode>(1);
        a.add(rtn);
        return a;
    }

    public File getServicePath(String serviceId) {
        return this.serviceManager.getServiceRuntimeDirectory(serviceId);
    }

    private String getProjectName() {
        return this.projectManager.getCurrentProject().getProjectName();
    }

    private DataModelKey getKey(String dataModelName) {
        return this.getKey(this.getProjectName(), dataModelName);
    }

    private DataModelKey getKey(String projectName, String dataModelName) {
        return new DataModelKey(projectName, dataModelName);
    }

    private void initialize(boolean force) {
        SortedSet<Service> services = this.serviceManager.getServicesByType("DataService");
        for (Service service : services) {
            this.initialize(service.getId(), force);
        }
    }

    private void remove(String serviceId) {
        this.remove(this.getKey(serviceId));
    }

    private void remove(DataModelKey key) {
        this.importedDataModels.remove(key.dataModelName);
        DataModelConfiguration cfg = this.dataModels.remove(key);
        cfg.dispose();
        this.dataModelNames.removeValue((Object)this.getProjectName(), (Object)key.dataModelName);
    }

    private DataModelConfiguration initialize(final String serviceId, boolean force) {
        DataModelKey key = this.getKey(serviceId);
        if (this.dataModels.containsKey(key)) {
            if (force) {
                this.remove(serviceId);
            } else {
                return null;
            }
        }
        File cfg = new File(this.getServicePath(serviceId), DataServiceUtils.getCfgFileName(serviceId));
        DataModelConfiguration rtn = null;
        try {
            DesignExternalDataModelConfig externalConfig = new DesignExternalDataModelConfig(serviceId, this.serviceManager);
            ClassLoaderFactory clf = new ClassLoaderFactory(){

                public ClassLoader getClassLoader() {
                    return DataModelManager.this.serviceManager.getServiceRuntimeClassLoader(serviceId);
                }
            };
            CompileService cs = new CompileService(){

                public void compile(boolean clean) {
                    DeploymentManager mgr = DataModelManager.this.serviceManager.getDeploymentManager();
                    if (clean) {
                        mgr.cleanCompile();
                    } else {
                        mgr.compile();
                    }
                }
            };
            rtn = new DataModelConfiguration(cfg, this.projectManager.getCurrentProject(), serviceId, externalConfig, clf, cs);
            this.dataModels.put(this.getKey(serviceId), rtn);
            this.dataModelNames.put((Object)this.getProjectName(), (Object)serviceId);
            if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("Initialized datamodel: " + cfg));
            }
        }
        catch (IOException ex) {
            DataServiceLoggers.parserLogger.error((Object)("Unable to initialize datamodel at " + cfg + ".  Does it exist?"), (Throwable)ex);
        }
        return rtn;
    }

    private ImportDB runImporter(String username, String password, String connectionUrl, String serviceId, String packageName, String tableFilter, String schemaFilter, String catalogName, String driverClassName, String dialectClassName, String revengNamingStrategyClassName, File outputDir, File classesDir) {
        if (connectionUrl.contains(HSQLDB)) {
            connectionUrl = this.reWriteCxnUrlForHsqlDB(connectionUrl);
        }
        if (ObjectUtils.isNullOrEmpty((String)packageName)) {
            throw new IllegalArgumentException("package must be set");
        }
        if ((packageName = packageName.toLowerCase()).endsWith(".")) {
            if (packageName.length() == 1) {
                throw new IllegalArgumentException("illegal package name " + packageName);
            }
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        File javaDir = DataModelManager.getJavaDir(outputDir, packageName);
        ImportDB importer = new ImportDB();
        importer.setDestDir(outputDir);
        importer.setUsername(username);
        importer.setPassword(password);
        importer.setClassesDir(classesDir);
        importer.setConnectionUrl(connectionUrl);
        importer.setServiceName(serviceId);
        importer.setCatalogName(catalogName);
        importer.setPackage(packageName);
        importer.setJavaDir(javaDir);
        String dataPackage = packageName;
        if (!dataPackage.endsWith(".data")) {
            String s = StringUtils.getUniqueName((String)HSQL_SAMPLE_DB_SUB_DIR, (String)serviceId.toLowerCase());
            dataPackage = StringUtils.fq((String)packageName, (String)s);
        }
        importer.setDataPackage(dataPackage);
        importer.setGenerateServiceClass(false);
        if (!ObjectUtils.isNullOrEmpty((String)tableFilter)) {
            importer.setTableFilterSplit(tableFilter);
        }
        if (!ObjectUtils.isNullOrEmpty((String)schemaFilter)) {
            importer.setSchemaFilterSplit(schemaFilter);
        }
        if (!ObjectUtils.isNullOrEmpty((String)driverClassName)) {
            importer.setDriverClassName(driverClassName);
        }
        if (!ObjectUtils.isNullOrEmpty((String)dialectClassName)) {
            importer.setDialect(dialectClassName);
        }
        if (!ObjectUtils.isNullOrEmpty((String)revengNamingStrategyClassName)) {
            importer.setRevengNamingStrategy(revengNamingStrategyClassName);
        }
        importer.init();
        try {
            importer.testConnection();
        }
        catch (RuntimeException ex) {
            throw com.wavemaker.runtime.data.util.DataServiceUtils.unwrap(ex);
        }
        try {
            importer.run();
            this.importedDataModels.add(serviceId);
        }
        catch (RuntimeException ex) {
            try {
                importer.dispose();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw ex;
        }
        return importer;
    }

    public String getWebAppRoot() {
        return this.projectManager.getCurrentProject().getWebAppRoot().getPath();
    }

    private String reWriteCxnUrlForHsqlDB(String connectionUrl) {
        return JDBCUtils.reWriteConnectionUrl(connectionUrl, this.getWebAppRoot());
    }

    private String extractHsqlDBFileName(String connectionUrl) {
        int n = connectionUrl.indexOf("/data") + 6;
        String partialCxn = connectionUrl.substring(n);
        int k = partialCxn.indexOf(59);
        return partialCxn.substring(0, k);
    }

    public static File getJavaDir(File dir, String pathname) {
        return new File(dir, pathname.replace(".", "/") + "/data");
    }

    private class DataModelKey {
        private final String projectName;
        private final String dataModelName;

        DataModelKey(String projectName, String dataModelName) {
            if (projectName == null) {
                throw new IllegalArgumentException("projectName cannot be null");
            }
            if (dataModelName == null) {
                throw new IllegalArgumentException("dataModelName cannot be null");
            }
            this.projectName = projectName;
            this.dataModelName = dataModelName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataModelKey)) {
                return false;
            }
            DataModelKey other = (DataModelKey)o;
            return this.projectName.equals(other.projectName) && this.dataModelName.equals(other.dataModelName);
        }

        public int hashCode() {
            return this.projectName.hashCode() ^ this.dataModelName.hashCode();
        }

        public String toString() {
            return this.projectName + "|" + this.dataModelName;
        }
    }
}

