/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.data.DataOperationFactory;
import com.wavemaker.runtime.data.DataServiceInternal;
import com.wavemaker.runtime.data.DataServiceOperation;
import com.wavemaker.runtime.data.DataServiceOperationManager;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.data.DataServiceType;
import com.wavemaker.runtime.data.ExternalDataModelConfig;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.runtime.service.ElementType;
import com.wavemaker.runtime.service.ServiceType;
import com.wavemaker.runtime.service.definition.AbstractDeprecatedServiceDefinition;
import com.wavemaker.runtime.service.definition.ReflectServiceDefinition;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.Input;
import com.wavemaker.tools.data.QueryInfo;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Operation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceDefinition
extends AbstractDeprecatedServiceDefinition
implements DataServiceInternal,
ReflectServiceDefinition {
    private final String serviceId;
    private final DataModelConfiguration dataCfg;
    private final DesignServiceManager serviceManager;
    private final String serviceClass;
    private final String packageName;
    private DataServiceOperationManager operationManager;
    private final boolean owner;
    private DataServiceInternal.ElementTypeFactory elementTypeFactory = DEFAULT_ELEMENT_TYPE_FACTORY;

    public DataServiceDefinition(String serviceId, ExternalDataModelConfig externalConfig, DesignServiceManager serviceManager, File serviceDir) throws IOException {
        this.owner = true;
        this.serviceId = serviceId;
        this.serviceManager = serviceManager;
        this.dataCfg = new DataModelConfiguration(serviceDir, serviceManager.getProjectManager().getCurrentProject(), serviceId, externalConfig, null, null);
        this.serviceClass = serviceManager.getService(serviceId).getClazz();
        this.packageName = (String)StringUtils.splitPackageAndClass((String)this.serviceClass).v1;
        this.initOperationManager();
    }

    public DataServiceDefinition(String serviceId, DataModelConfiguration dataCfg, DesignServiceManager serviceManager) {
        this(serviceId, dataCfg, serviceManager, serviceManager.getService(serviceId).getClazz());
    }

    public DataServiceDefinition(String serviceId, DataModelConfiguration dataCfg, DesignServiceManager serviceManager, String serviceClass) {
        this.owner = false;
        this.serviceId = serviceId;
        this.dataCfg = dataCfg;
        this.serviceManager = serviceManager;
        this.serviceClass = serviceClass;
        this.packageName = (String)StringUtils.splitPackageAndClass((String)serviceClass).v1;
        this.initOperationManager();
    }

    @Override
    public void setElementTypeFactory(DataServiceInternal.ElementTypeFactory elementTypeFactory) {
        this.elementTypeFactory = elementTypeFactory;
    }

    @Override
    public String getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getDataPackage() {
        return this.dataCfg.getDataPackage();
    }

    public DataModelConfiguration getDataModelConfiguration() {
        return this.dataCfg;
    }

    @Override
    public ServiceType getServiceType() {
        return new DataServiceType();
    }

    @Override
    public List<String> getOperationNames() {
        return this.serviceManager.getOperationNames(this.serviceId);
    }

    @Override
    public List<ElementType> getInputTypes(String operationName) {
        Operation op = this.serviceManager.getOperation(this.serviceId, operationName);
        List<Operation.Parameter> params = op.getParameter();
        ArrayList<ElementType> rtn = new ArrayList<ElementType>(params.size());
        for (Operation.Parameter p : params) {
            rtn.add(new ElementType(p.getName(), p.getTypeRef(), p.isIsList()));
        }
        return rtn;
    }

    @Override
    public ElementType getOutputType(String operationName) {
        Operation op = this.serviceManager.getOperation(this.serviceId, operationName);
        if (op.getReturn() == null) {
            return null;
        }
        Operation.Return opRtn = op.getReturn();
        ElementType rtn = new ElementType("rtn", opRtn.getTypeRef(), opRtn.isIsList());
        return rtn;
    }

    @Override
    public List<ElementType> getTypes() {
        Collection<String> entities = this.getEntityClassNames();
        Collection<String> otherTypes = this.getHelperTypes();
        return DataServiceUtils.getTypes(entities, otherTypes, this.elementTypeFactory);
    }

    @Override
    public String getRuntimeConfiguration() {
        return this.serviceId + ".spring.xml";
    }

    @Override
    public void dispose() {
        if (this.owner) {
            this.dataCfg.dispose();
        }
    }

    @Override
    public List<String> getEventNotifiers() {
        return Collections.emptyList();
    }

    @Override
    public DataServiceOperation getOperation(String operationName) {
        DataServiceOperation rtn = this.operationManager.getOperation(operationName);
        if (rtn == null) {
            throw new DataServiceRuntimeException(Resource.OPERATION_NOT_FOUND, this.serviceId, operationName, this.operationManager.getOperationNames());
        }
        return rtn;
    }

    @Override
    public void setExternalConfig(ExternalDataModelConfig externalConfig) {
    }

    @Override
    public boolean isLiveDataService() {
        return true;
    }

    private Collection<String> getEntityClassNames() {
        TreeSet<String> rtn = new TreeSet<String>();
        for (String s : this.dataCfg.getEntityNames()) {
            rtn.add(StringUtils.fq((String)this.dataCfg.getDataPackage(), (String)s));
        }
        return rtn;
    }

    private Collection<String> getHelperTypes() {
        return Collections.emptySet();
    }

    private void initOperationManager() {
        this.operationManager = new DataServiceOperationManager(this.initFactory(), this.dataCfg.useIndividualCRUDOperations());
    }

    private DataOperationFactory initFactory() {
        return new DataOperationFactory(){

            @Override
            public Collection<String> getEntityClassNames() {
                return DataServiceDefinition.this.getEntityClassNames();
            }

            @Override
            public Collection<Tuple.Three<String, String, Boolean>> getQueryInputs(String queryName) {
                ArrayList<Tuple.Three<String, String, Boolean>> rtn = new ArrayList<Tuple.Three<String, String, Boolean>>();
                QueryInfo qi = DataServiceDefinition.this.dataCfg.getQuery(queryName);
                for (Input in : qi.getInputs()) {
                    rtn.add((Tuple.Three<String, String, Boolean>)Tuple.tuple((Object)in.getParamName(), (Object)in.getParamType(), (Object)in.getList()));
                }
                return rtn;
            }

            @Override
            public Collection<String> getQueryNames() {
                return DataServiceDefinition.this.dataCfg.getQueryNames();
            }

            @Override
            public List<String> getQueryReturnTypes(String operationName, String queryName) {
                ArrayList<String> rtn = new ArrayList<String>();
                Operation op = DataServiceDefinition.this.serviceManager.getOperation(DataServiceDefinition.this.serviceId, operationName);
                if (op == null) {
                    throw new ConfigurationException(Resource.OPERATION_NOT_FOUND, DataServiceDefinition.this.serviceId, operationName, DataServiceDefinition.this.getOperationNames());
                }
                if (op.getReturn() != null) {
                    String type = op.getReturn().getTypeRef();
                    String shortName = StringUtils.getClassName((String)type);
                    if (DataServiceDefinition.this.dataCfg.isEntityType(shortName) || !DataServiceDefinition.this.dataCfg.isValueType(shortName)) {
                        // empty if block
                    }
                    rtn.add(type);
                }
                return rtn;
            }

            @Override
            public boolean requiresResultWrapper(String operationName, String queryName) {
                QueryInfo query = DataServiceDefinition.this.dataCfg.getQuery(queryName);
                return DataServiceUtils.requiresResultWrapper(query.getQuery());
            }

            @Override
            public List<String> getQueryReturnNames(String operationName, String queryName) {
                return Collections.emptyList();
            }

            @Override
            public boolean queryReturnsSingleResult(String operationName, String queryName) {
                Operation op = DataServiceDefinition.this.serviceManager.getOperation(DataServiceDefinition.this.serviceId, operationName);
                if (op == null) {
                    throw new ConfigurationException(Resource.OPERATION_NOT_FOUND, DataServiceDefinition.this.serviceId, operationName, DataServiceDefinition.this.getOperationNames());
                }
                if (op.getReturn() == null) {
                    return false;
                }
                return !op.getReturn().isIsList();
            }
        };
    }
}

