/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.runtime.service.definition.DeprecatedServiceDefinition;
import com.wavemaker.runtime.service.definition.ServiceDefinition;
import com.wavemaker.tools.data.DataServiceDefinition;
import com.wavemaker.tools.data.DataServiceGenerator;
import com.wavemaker.tools.data.DesignExternalDataModelConfig;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.ServiceDefinitionFactory;
import com.wavemaker.tools.service.ServiceGeneratorFactory;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.ServiceGenerator;
import java.io.File;
import java.io.FilenameFilter;

public class DataServiceDefinitionFactory
implements ServiceDefinitionFactory,
ServiceGeneratorFactory {
    public ServiceDefinition getServiceDefinition(File f, String serviceId, DesignServiceManager serviceMgr) {
        if (f.isDirectory()) {
            for (String s : f.list(new FilenameFilter(){

                public boolean accept(File dir, String file) {
                    return file.endsWith(".xml");
                }
            })) {
                File potential = new File(f, s);
                ServiceDefinition rtn = this.initServiceDefinition(potential, serviceId, serviceMgr);
                if (rtn == null) continue;
                return rtn;
            }
        } else {
            return this.initServiceDefinition(f, serviceId, serviceMgr);
        }
        return null;
    }

    public ServiceGenerator getServiceGenerator(GenerationConfiguration cfg) {
        DeprecatedServiceDefinition def = cfg.getServiceDefinition();
        if (def instanceof DataServiceDefinition) {
            return new DataServiceGenerator(cfg);
        }
        return null;
    }

    private ServiceDefinition initServiceDefinition(File f, String serviceId, DesignServiceManager serviceMgr) {
        DataServiceDefinition rtn;
        block4: {
            if (!f.getName().endsWith(".xml")) {
                return null;
            }
            rtn = null;
            try {
                DesignExternalDataModelConfig externalConfig = new DesignExternalDataModelConfig(serviceId, serviceMgr);
                rtn = new DataServiceDefinition(serviceId, externalConfig, serviceMgr, f);
                if (!rtn.getDataModelConfiguration().isKnownConfiguration()) {
                    rtn.dispose();
                    return null;
                }
            }
            catch (Exception ex) {
                if (rtn == null) break block4;
                rtn.dispose();
                return null;
            }
        }
        return rtn;
    }
}

