/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.SpringUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.json.type.TypeDefinition;
import com.wavemaker.runtime.data.DataServiceInternal;
import com.wavemaker.runtime.data.DataServiceManager;
import com.wavemaker.runtime.data.DataServiceManagerAccess;
import com.wavemaker.runtime.data.DataServiceOperation;
import com.wavemaker.runtime.data.TaskManager;
import com.wavemaker.runtime.service.ElementType;
import com.wavemaker.runtime.service.LiveDataService;
import com.wavemaker.runtime.service.PagingOptions;
import com.wavemaker.runtime.service.PropertyOptions;
import com.wavemaker.runtime.service.TypedServiceReturn;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.service.codegen.BeanGenerator;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.ServiceGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.NDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceGenerator
extends ServiceGenerator {
    private static final String CREATE_CRUD_OP = "insert";
    private static final String READ_CRUD_OP = "read";
    private static final String UPDATE_CRUD_OP = "update";
    private static final String DELETE_CRUD_OP = "delete";
    private static final String QUERY_NAME_CONSTANT_SUFFIX = "QueryName";
    private static final String BEGIN_OP = "begin";
    private static final String COMMIT_OP = "commit";
    private static final String ROLLBACK_OP = "rollback";
    private static final String DATA_SERVICE_VAR_NAME = "dsMgr";
    private static final String TASK_MANAGER_VAR_NAME = "taskMgr";
    private static final String INVOKE_METHOD_NAME = "invoke";
    private static final String GET_BEAN_METHOD_NAME = "getBean";
    private static final String IS_EMPTY_METHOD_NAME = "isEmpty";
    private static final String GET_METHOD_NAME = "get";
    private final DataServiceInternal ds;
    private final String serviceClass;
    private final String serviceId;
    private final BeanGenerator constantsClass;
    private JVar dataServiceVar = null;
    private JVar taskMgrVar = null;
    private boolean generateMain = false;
    private DataServiceOperation firstCountOperation = null;

    public DataServiceGenerator(GenerationConfiguration configuration) {
        this(configuration, configuration.getServiceDefinition().getServiceClass());
    }

    public DataServiceGenerator(GenerationConfiguration configuration, String serviceClass) {
        super(configuration);
        this.serviceClass = serviceClass;
        this.ds = (DataServiceInternal)((Object)DataServiceUtils.unwrap(configuration.getServiceDefinition()));
        this.serviceId = configuration.getServiceDefinition().getServiceId();
        this.constantsClass = new BeanGenerator(DataServiceUtils.getConstantsClassName(serviceClass));
        this.useNDCLogging = false;
    }

    public void setGenerateMain(boolean generateMain) {
        this.generateMain = generateMain;
    }

    @Override
    protected boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    public String getClassName() {
        return this.serviceClass;
    }

    @Override
    protected void preGenerateClassBody(JDefinedClass cls) {
        cls.annotate(SuppressWarnings.class).param("value", "unchecked");
        cls._implements(DataServiceManagerAccess.class);
        this.dataServiceVar = cls.field(4, DataServiceManager.class, DATA_SERVICE_VAR_NAME);
        this.taskMgrVar = cls.field(4, TaskManager.class, TASK_MANAGER_VAR_NAME);
    }

    @Override
    protected List<List<ElementType>> getOverloadedVersions(String operationName) {
        DataServiceOperation op = this.ds.getOperation(operationName);
        ArrayList<List<ElementType>> rtn = new ArrayList<List<ElementType>>();
        for (DataServiceOperation overop : op.getOverloadedOperations()) {
            ArrayList<ElementType> inputs = new ArrayList<ElementType>();
            rtn.add(inputs);
            for (int i = 0; i < overop.getInputNames().size(); ++i) {
                ElementType et = new ElementType(overop.getInputTypes().get(i));
                inputs.add(et);
                et.setName(overop.getInputNames().get(i));
            }
        }
        return rtn;
    }

    @Override
    protected void generateOperationMethodBody(JMethod method, JBlock body, String operationName, Map<String, JType> inputJTypeMap, JType outputJType, Integer overloadCount) {
        DataServiceOperation op = this.ds.getOperation(operationName);
        if (overloadCount != null) {
            op = op.getOverloadedOperations().get(overloadCount);
        }
        if (this.firstCountOperation == null && op.getName().endsWith("Count")) {
            this.firstCountOperation = op;
        }
        this.addOperation(op, inputJTypeMap, outputJType, body);
    }

    @Override
    protected void postGenerateClassBody(JDefinedClass cls) {
        cls._implements(LiveDataService.class);
        this.implementCRUDInterface(cls);
        this.delegate(cls, BEGIN_OP);
        this.delegate(cls, COMMIT_OP);
        this.delegate(cls, ROLLBACK_OP);
        this.addGetterAndSetter(cls, DataServiceManager.class, DATA_SERVICE_VAR_NAME, this.dataServiceVar);
        this.addGetterAndSetter(cls, TaskManager.class, TASK_MANAGER_VAR_NAME, this.taskMgrVar);
        this.writeConstantsClass();
        if (this.generateMain) {
            JMethod main = cls.method(25, (JType)this.codeModel.VOID, "main");
            main.param(String[].class, "args");
            JClass t = this.codeModel.ref(this.getClassName());
            JBlock b = main.body();
            if (this.firstCountOperation == null) {
                JFieldRef sysout = this.codeModel.ref(System.class).staticRef("out");
                b.add((JStatement)sysout.invoke("print").arg(JExpr.lit((String)"Don't know what to do")));
                return;
            }
            JVar springConfig = b.decl((JType)this.codeModel.ref(String.class), "cfg", JExpr.lit((String)(this.serviceId + ".spring.xml")));
            JVar beanName = b.decl((JType)this.codeModel.ref(String.class), "beanName", JExpr.lit((String)this.serviceId));
            JVar v = b.decl((JType)t, "s", (JExpression)JExpr.cast((JType)t, (JExpression)this.codeModel.ref(SpringUtils.class).staticInvoke(GET_BEAN_METHOD_NAME).arg((JExpression)springConfig).arg((JExpression)beanName)));
            String name = this.firstCountOperation.getName();
            JInvocation i = v.invoke(name);
            JFieldRef sysout = this.codeModel.ref(System.class).staticRef("out");
            b.add((JStatement)sysout.invoke("print").arg(JExpr.lit((String)(name + ": "))));
            b.add((JStatement)sysout.invoke("println").arg((JExpression)i));
        }
    }

    private void implementCRUDInterface(JDefinedClass cls) {
        this.addCreate(cls);
        this.addRead(cls);
        this.addUpdate(cls);
        this.addDelete(cls);
    }

    private void addCreate(JDefinedClass cls) {
        JMethod method = cls.method(1, Object.class, CREATE_CRUD_OP);
        JVar p1 = method.param(Object.class, "o");
        JInvocation exp = this.dataServiceVar.invoke(INVOKE_METHOD_NAME);
        exp.arg((JExpression)this.taskMgrVar.invoke("getInsertTask")).arg((JExpression)p1);
        method.body()._return((JExpression)exp);
    }

    private void addRead(JDefinedClass cls) {
        JMethod method = cls.method(1, TypedServiceReturn.class, READ_CRUD_OP);
        JVar rootTypeParam = method.param(TypeDefinition.class, "rootType");
        JVar instanceParam = method.param(Object.class, "o");
        JVar propertyOptionsParam = method.param(PropertyOptions.class, "propertyOptions");
        JVar pagingOptionsParam = method.param(PagingOptions.class, "pagingOptions");
        JInvocation exp = this.dataServiceVar.invoke(INVOKE_METHOD_NAME);
        exp.arg((JExpression)this.taskMgrVar.invoke("getReadTask")).arg((JExpression)rootTypeParam).arg((JExpression)instanceParam).arg((JExpression)propertyOptionsParam).arg((JExpression)pagingOptionsParam);
        method.body()._return((JExpression)JExpr.cast((JType)this.codeModel.ref(TypedServiceReturn.class), (JExpression)exp));
    }

    private void addUpdate(JDefinedClass cls) {
        JMethod method = cls.method(1, Object.class, UPDATE_CRUD_OP);
        JVar p1 = method.param(Object.class, "o");
        JInvocation exp = this.dataServiceVar.invoke(INVOKE_METHOD_NAME);
        exp.arg((JExpression)this.taskMgrVar.invoke("getUpdateTask")).arg((JExpression)p1);
        method.body()._return((JExpression)exp);
    }

    private void addDelete(JDefinedClass cls) {
        JMethod method = cls.method(1, Void.TYPE, DELETE_CRUD_OP);
        JVar p1 = method.param(Object.class, "o");
        JInvocation exp = this.dataServiceVar.invoke(INVOKE_METHOD_NAME);
        exp.arg((JExpression)this.taskMgrVar.invoke("getDeleteTask")).arg((JExpression)p1);
        method.body().add((JStatement)exp);
    }

    private void addOperation(DataServiceOperation op, Map<String, JType> inputJTypeMap, JType outputJType, JBlock body) {
        JInvocation exp = this.dataServiceVar.invoke(INVOKE_METHOD_NAME);
        exp.arg((JExpression)this.taskMgrVar.invoke(op.getTaskGetter()));
        if (op.isQuery()) {
            String queryName = op.getQueryName();
            String constantName = queryName + QUERY_NAME_CONSTANT_SUFFIX;
            this.constantsClass.addStringConstant(constantName, queryName);
            exp.arg(JExpr.direct((String)(this.constantsClass.getClassName() + "." + constantName)));
        }
        for (Map.Entry<String, JType> e : inputJTypeMap.entrySet()) {
            exp.arg((JExpression)JExpr.ref((String)e.getKey()));
        }
        for (ElementType el : op.getTaskInputs()) {
            if (el.getJavaType().equals(String.class.getName())) {
                exp.arg(JExpr.lit((String)el.getName()));
                continue;
            }
            if (el.getJavaType().equals(Class.class.getName())) {
                JClass jc = this.codeModel.ref(el.getName());
                exp.arg(jc.dotclass());
                continue;
            }
            if (el.getJavaType().equals(Boolean.class.getName())) {
                exp.arg(JExpr.lit((boolean)Boolean.parseBoolean(el.getName())));
                continue;
            }
            throw new AssertionError((Object)("Unknown input type " + el.getJavaType()));
        }
        if (op.getCode() != null) {
            body.directStatement(op.getCode());
        }
        if (op.isQuery() && op.getReturnsSingleResult()) {
            JType jt = null;
            try {
                jt = this.getGenericListType(outputJType.fullName());
            }
            catch (ClassNotFoundException ex) {
                throw new AssertionError((Object)ex);
            }
            JVar rtn = body.decl(jt, "rtn", (JExpression)JExpr.cast((JType)jt, (JExpression)exp));
            JConditional ifstmt = body._if((JExpression)rtn.invoke(IS_EMPTY_METHOD_NAME));
            ifstmt._then()._return(JExpr._null());
            ifstmt._else()._return((JExpression)rtn.invoke(GET_METHOD_NAME).arg(JExpr.lit((int)0)));
        } else if (outputJType == this.codeModel.VOID) {
            body.add((JStatement)exp);
        } else {
            body._return((JExpression)JExpr.cast((JType)outputJType, (JExpression)exp));
        }
    }

    private void addGetterAndSetter(JDefinedClass cls, Class<?> c, String paramName, JVar var) {
        Tuple.Two t = StringUtils.splitPackageAndClass(c);
        cls.method(1, c, GET_METHOD_NAME + (String)t.v2).body()._return((JExpression)var);
        JMethod m = cls.method(1, (JType)this.codeModel.VOID, "set" + (String)t.v2);
        JVar p = m.param(c, paramName);
        m.body().assign((JAssignmentTarget)JExpr._this().ref(var), (JExpression)p);
    }

    private void delegate(JDefinedClass cls, String name) {
        this.delegate(cls, name, new Class[0], new String[0], null);
    }

    private void delegate(JDefinedClass cls, String name, Class<?>[] params, String[] paramNames, Class<?> rtn) {
        JMethod m = null;
        m = rtn == null ? cls.method(1, (JType)this.codeModel.VOID, name) : cls.method(1, rtn, name);
        for (int i = 0; i < params.length; ++i) {
            m.param(params[i], paramNames[i]);
        }
        JBlock body = m.body();
        JTryBlock tryBlock = null;
        if (this.useNDCLogging) {
            tryBlock = body._try();
            body = tryBlock.body();
            body.staticInvoke(this.codeModel.ref(NDC.class), "push").arg(this.getClassName() + "." + name);
        }
        JInvocation invocation = this.dataServiceVar.invoke(name);
        for (String s : paramNames) {
            invocation.arg((JExpression)JExpr.ref((String)s));
        }
        if (rtn == null) {
            body.add((JStatement)invocation);
        } else {
            body._return((JExpression)invocation);
        }
        if (this.useNDCLogging) {
            tryBlock._finally().block().staticInvoke(this.codeModel.ref(NDC.class), "pop");
        }
    }

    private void writeConstantsClass() {
        this.constantsClass.addClassJavadoc(" Query names for service \"" + this.serviceDefinition.getServiceId() + "\"\n" + StringUtils.getFormattedDate());
        String relPath = StringUtils.classNameToSrcFilePath((String)this.constantsClass.getFullyQualifiedClassName());
        File f = new File(this.configuration.getOutputDirectory(), relPath);
        f.getParentFile().mkdirs();
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(f));
            this.constantsClass.generate(bos);
            bos.close();
        }
        catch (IOException ex) {
            throw new WMRuntimeException((Throwable)ex);
        }
        finally {
            try {
                bos.close();
            }
            catch (Exception ignore) {}
        }
    }
}

