/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.SystemUtils;
import com.wavemaker.runtime.data.spring.ConfigurationAndSessionFactoryBean;
import com.wavemaker.runtime.data.spring.SpringDataServiceManager;
import com.wavemaker.runtime.data.spring.WMPropertyPlaceholderConfigurer;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.BaseDataModelSetup;
import com.wavemaker.tools.data.DataServiceLoggers;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.service.FileService;
import com.wavemaker.tools.spring.beans.Bean;
import com.wavemaker.tools.spring.beans.Beans;
import com.wavemaker.tools.spring.beans.ConstructorArg;
import com.wavemaker.tools.spring.beans.Entry;
import com.wavemaker.tools.spring.beans.Map;
import com.wavemaker.tools.spring.beans.Property;
import com.wavemaker.tools.spring.beans.Value;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.jndi.JndiObjectFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataServiceSpringConfiguration {
    public static final String JNDI_NAME_PROPERTY = "jndiName";
    private final String rootPath;
    private final String path;
    private final FileService fileService;
    private final String propertiesFile;
    private final String serviceId;
    private Beans beans;
    private boolean isDirty = false;

    public DataServiceSpringConfiguration(FileService fileService, String rootPath, String configFile, String serviceName) {
        this.rootPath = rootPath;
        this.path = rootPath + "/" + configFile;
        this.fileService = fileService;
        this.beans = DataServiceUtils.readBeans(fileService, this.path);
        this.serviceId = serviceName;
        this.propertiesFile = this.getConnectionPropertiesFileName();
    }

    void revert() {
        this.beans = DataServiceUtils.readBeans(this.fileService, this.path);
        this.isDirty = false;
    }

    void write() {
        if (!this.isDirty) {
            if (DataServiceLoggers.parserLogger.isDebugEnabled()) {
                DataServiceLoggers.parserLogger.info((Object)("No changes to write to Spring Configuration at " + this.path));
            }
            return;
        }
        DataServiceUtils.writeBeans(this.beans, this.fileService, this.path);
        if (DataServiceLoggers.parserLogger.isInfoEnabled()) {
            DataServiceLoggers.parserLogger.info((Object)("Wrote Spring Configuration at " + this.path));
        }
        this.isDirty = false;
    }

    String getPath() {
        return this.path;
    }

    Properties readProperties() {
        return this.readProperties(false);
    }

    Properties readProperties(boolean removePrefix) {
        try {
            String s = this.fileService.readFile(this.propertiesFile);
            ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
            Properties rtn = DataServiceUtils.readProperties(bais);
            if (removePrefix) {
                DataServiceUtils.removePrefix(rtn);
            }
            return rtn;
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
    }

    boolean useIndividualCRUDperations() {
        String s = this.getPropertyValue("useIndividualCRUDOperations");
        return Boolean.valueOf(s);
    }

    void setRefreshEntities(List<String> refreshEntities) {
        this.setPropertyValue("refreshEntities", ObjectUtils.toString(refreshEntities));
    }

    List<String> getRefreshEntities() {
        String s = this.getPropertyValue("refreshEntities");
        if (s == null) {
            return new ArrayList<String>();
        }
        return StringUtils.split((String)s);
    }

    public void writeProperties(Properties props) {
        this.writeProperties(props, true);
    }

    public void writeProperties(Properties props, boolean validate) {
        String dialect;
        if (!validate) {
            this.writeProps(props);
            return;
        }
        DataServiceUtils.removePrefix(props);
        String key = StringUtils.removeIfStartsWith((String)".connectionUrl", (String)".");
        String connectionUrl = props.getProperty(key);
        if (connectionUrl == null) {
            throw new IllegalArgumentException(key + " must be set");
        }
        key = StringUtils.removeIfStartsWith((String)".driverClassName", (String)".");
        String driverClassName = props.getProperty(key);
        if (ObjectUtils.isNullOrEmpty((String)driverClassName)) {
            String dbtype = BaseDataModelSetup.getDBTypeFromURL(connectionUrl);
            if (dbtype == null) {
                throw new IllegalArgumentException(key + " must bet set");
            }
            String value = BaseDataModelSetup.getDriverClassForDBType(dbtype);
            props.setProperty(key, value);
        }
        if (ObjectUtils.isNullOrEmpty((String)(dialect = props.getProperty(key = StringUtils.removeIfStartsWith((String)".dialect", (String)"."))))) {
            String dbtype = BaseDataModelSetup.getDBTypeFromURL(connectionUrl);
            if (dbtype == null) {
                throw new IllegalArgumentException(key + " must bet set");
            }
            String value = BaseDataModelSetup.getDialectForDBType(dbtype);
            props.setProperty(key, value);
        }
        Properties org = this.readProperties(false);
        DataServiceUtils.removePrefix(org);
        SystemUtils.addAllUnlessSet((Properties)props, (Properties)org);
        if (props.equals(org)) {
            return;
        }
        this.writeProps(DataServiceUtils.addPrefix(this.serviceId, props));
    }

    void addMapping(String path) {
        Property p = this.getMappingFilesProperty();
        ArrayList<String> l = new ArrayList<String>(p.getListValue());
        l.add(path);
        this.setMappings(l);
    }

    void removeMapping(String path) {
        Property p = this.getMappingFilesProperty();
        ArrayList<String> l = new ArrayList<String>(p.getListValue());
        l.remove(path);
        this.setMappings(l);
    }

    List<String> getMappings() {
        return this.getMappingFilesProperty().getListValue();
    }

    public boolean isKnownConfiguration() {
        try {
            this.getSpringDataServiceManager();
            return true;
        }
        catch (SpringDataServiceManagerNotFound ex) {
            return false;
        }
    }

    public List<Bean> getBeansByType(Class<?> type) {
        return this.beans.getBeansByType(type.getName());
    }

    void configureJNDIDataSource(String jndiName) {
        List<Bean> l = this.beans.getBeansByType(DriverManagerDataSource.class.getName());
        if (l.size() != 1) {
            throw new AssertionError((Object)"Expected one datasource bean");
        }
        Bean ds = l.iterator().next();
        ds.setClazz(JndiObjectFactoryBean.class.getName());
        ds.removeProperties();
        ds.addProperty(JNDI_NAME_PROPERTY, jndiName);
        this.isDirty = true;
    }

    private void setPropertyValue(String key, String value) {
        Map m = this.getOrCreatePropertiesMap();
        Entry e = this.getEntry(m, key, true);
        e.setValue(value);
        this.isDirty = true;
    }

    private String getPropertyValue(String key) {
        Map m = this.getOrCreatePropertiesMap();
        Entry e = this.getEntry(m, key, false);
        if (e == null) {
            return null;
        }
        return e.getValue();
    }

    private Entry getEntry(Map m, String key, boolean create) {
        for (Entry e : m.getEntries()) {
            if (!e.getKey().equals(key)) continue;
            return e;
        }
        if (create) {
            Entry e = new Entry();
            e.setKey(key);
            m.getEntries().add(e);
            return e;
        }
        return null;
    }

    private Map getOrCreatePropertiesMap() {
        Bean b = this.getSpringDataServiceManager();
        List<ConstructorArg> l = b.getConstructorArgs();
        Map rtn = null;
        if (l.size() < 4) {
            rtn = new Map();
            ConstructorArg a = new ConstructorArg();
            a.setMap(rtn);
            b.getMetasAndConstructorArgsAndProperties().add(a);
        } else {
            ConstructorArg a = l.get(4);
            rtn = a.getMap();
        }
        return rtn;
    }

    private void setMappings(List<String> l) {
        Property p = this.getMappingFilesProperty();
        Collections.sort(l);
        ArrayList<Object> l2 = new ArrayList<Object>();
        for (String s2 : l) {
            Value v = new Value();
            ArrayList<String> temp = new ArrayList<String>(1);
            temp.add(s2);
            v.setContent(temp);
            l2.add(v);
        }
        p.getList().setRefElement(l2);
        this.isDirty = true;
    }

    private void writeProps(Properties props) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataServiceUtils.writeProperties(props, bos, this.serviceId);
            this.fileService.writeFile(this.propertiesFile, bos.toString());
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
    }

    private Property getMappingFilesProperty() {
        return this.getSessionFactoryBean().getProperty("mappingResources");
    }

    private Bean getSessionFactoryBean() {
        List<Bean> sessionFactoryBean = this.beans.getBeansByType(ConfigurationAndSessionFactoryBean.class.getName());
        if (sessionFactoryBean.isEmpty()) {
            sessionFactoryBean = this.beans.getBeansByType("com.activegrid.runtime.data.spring.AGLocalSessionFactoryBean");
        }
        if (sessionFactoryBean.isEmpty()) {
            throw new ConfigurationException(this.path + ": unable to find SessionFactory class \"" + ConfigurationAndSessionFactoryBean.class.getName() + "\"");
        }
        return sessionFactoryBean.get(0);
    }

    private String getConnectionPropertiesFileName() {
        List<Bean> propertyPlaceholders = this.beans.getBeansByType(WMPropertyPlaceholderConfigurer.class.getName());
        propertyPlaceholders.addAll(this.beans.getBeansByType(PropertyPlaceholderConfigurer.class.getName()));
        String rtn = null;
        for (Bean b : propertyPlaceholders) {
            List<String> l = b.getProperty("locations").getListValue();
            for (String s : l) {
                rtn = this.rootPath + "/" + StringUtils.fromFirstOccurrence((String)s, (String)"classpath:");
            }
        }
        return rtn;
    }

    private Bean getSpringDataServiceManager() {
        List<Bean> l = this.beans.getBeansByType(SpringDataServiceManager.class.getName());
        if (l.isEmpty()) {
            l = this.beans.getBeansByType("com.activegrid.runtime.data.spring.SpringDataServiceManager");
        }
        if (l.size() != 1) {
            throw new SpringDataServiceManagerNotFound();
        }
        return l.get(0);
    }

    private class SpringDataServiceManagerNotFound
    extends RuntimeException {
        SpringDataServiceManagerNotFound() {
            super("Could not find SpringDataServiceManager bean");
        }
    }
}

