/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.StringUtils;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeMapper {
    private static final Collection<Type> HB_TYPES = new LinkedHashSet<Type>(31);
    private static final Map<String, Type> JAVA_TYPE_TO_HB_TYPE;
    private static final Map<Type, Class<?>> HB_TYPE_TO_JAVA_TYPE;
    private static final Map<String, Class<?>> HB_STR_TYPE_TO_JAVA_TYPE;

    public static Class<?> getJavaType(Type type) {
        return HB_TYPE_TO_JAVA_TYPE.get(type);
    }

    public static Class<?> getJavaType(String type) {
        return HB_STR_TYPE_TO_JAVA_TYPE.get(type);
    }

    public static String getHibernateType(String type) {
        Type t = JAVA_TYPE_TO_HB_TYPE.get(type);
        if (t == null) {
            return StringUtils.fromLastOccurrence((String)type, (String)".");
        }
        return t.getName();
    }

    public static String getFQHibernateType(String type) {
        Type t = JAVA_TYPE_TO_HB_TYPE.get(type);
        if (t == null) {
            return type;
        }
        return t.getName();
    }

    private DataTypeMapper() {
        throw new UnsupportedOperationException();
    }

    static {
        HB_TYPES.add((Type)Hibernate.BIG_DECIMAL);
        HB_TYPES.add((Type)Hibernate.BIG_INTEGER);
        HB_TYPES.add((Type)Hibernate.BINARY);
        HB_TYPES.add(Hibernate.BLOB);
        HB_TYPES.add((Type)Hibernate.BOOLEAN);
        HB_TYPES.add((Type)Hibernate.BYTE);
        HB_TYPES.add((Type)Hibernate.CALENDAR);
        HB_TYPES.add((Type)Hibernate.CALENDAR_DATE);
        HB_TYPES.add((Type)Hibernate.CHARACTER);
        HB_TYPES.add((Type)Hibernate.CHARACTER_ARRAY);
        HB_TYPES.add((Type)Hibernate.CHAR_ARRAY);
        HB_TYPES.add((Type)Hibernate.CLASS);
        HB_TYPES.add(Hibernate.CLOB);
        HB_TYPES.add((Type)Hibernate.CURRENCY);
        HB_TYPES.add((Type)Hibernate.DATE);
        HB_TYPES.add((Type)Hibernate.DOUBLE);
        HB_TYPES.add((Type)Hibernate.FLOAT);
        HB_TYPES.add((Type)Hibernate.INTEGER);
        HB_TYPES.add((Type)Hibernate.LOCALE);
        HB_TYPES.add((Type)Hibernate.LONG);
        HB_TYPES.add(Hibernate.OBJECT);
        HB_TYPES.add((Type)Hibernate.SERIALIZABLE);
        HB_TYPES.add((Type)Hibernate.SHORT);
        HB_TYPES.add((Type)Hibernate.STRING);
        HB_TYPES.add((Type)Hibernate.TEXT);
        HB_TYPES.add((Type)Hibernate.TIME);
        HB_TYPES.add((Type)Hibernate.TIMESTAMP);
        HB_TYPES.add((Type)Hibernate.TIMEZONE);
        HB_TYPES.add((Type)Hibernate.TRUE_FALSE);
        HB_TYPES.add((Type)Hibernate.WRAPPER_BINARY);
        HB_TYPES.add((Type)Hibernate.YES_NO);
        JAVA_TYPE_TO_HB_TYPE = new HashMap<String, Type>(HB_TYPES.size() + 2);
        for (Type type : HB_TYPES) {
            if (type == Hibernate.TRUE_FALSE || type == Hibernate.YES_NO) continue;
            JAVA_TYPE_TO_HB_TYPE.put(type.getReturnedClass().getName(), type);
        }
        JAVA_TYPE_TO_HB_TYPE.put("java.lang.String", (Type)Hibernate.STRING);
        JAVA_TYPE_TO_HB_TYPE.put("int", (Type)Hibernate.INTEGER);
        JAVA_TYPE_TO_HB_TYPE.put(Date.class.getName(), (Type)Hibernate.DATE);
        HB_TYPE_TO_JAVA_TYPE = new HashMap(HB_TYPES.size());
        for (Type type : HB_TYPES) {
            HB_TYPE_TO_JAVA_TYPE.put(type, type.getReturnedClass());
        }
        HB_STR_TYPE_TO_JAVA_TYPE = new HashMap(HB_TYPE_TO_JAVA_TYPE.size());
        for (Map.Entry entry : HB_TYPE_TO_JAVA_TYPE.entrySet()) {
            HB_STR_TYPE_TO_JAVA_TYPE.put(((Type)entry.getKey()).getName(), (Class<?>)entry.getValue());
        }
    }
}

