/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.ObjectAccess;
import com.wavemaker.common.util.OneToManyMap;
import com.wavemaker.json.PropertyFilter;
import com.wavemaker.runtime.data.DataPropertyFilter;
import com.wavemaker.tools.data.ColumnInfo;
import com.wavemaker.tools.data.EntityInfo;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignDataPropertyFilter
extends DataPropertyFilter
implements PropertyFilter {
    private static final DesignDataPropertyFilter instance = new DesignDataPropertyFilter();
    private final OneToManyMap<Class<?>, String> filterProps = new OneToManyMap();
    private final OneToManyMap<Class<?>, String> nullFilterProps = new OneToManyMap();
    private final ObjectAccess objectAccess = ObjectAccess.getInstance();

    public static DesignDataPropertyFilter getInstance() {
        return instance;
    }

    private DesignDataPropertyFilter() {
        this.addFilteredProperty(EntityInfo.class, "columnsMap", this.filterProps);
        this.addFilteredProperty(EntityInfo.class, "id", this.filterProps);
        this.addFilteredProperty(EntityInfo.class, "properties", this.filterProps);
        this.addFilteredProperty(EntityInfo.class, "propertiesMap", this.filterProps);
        this.addFilteredProperty(EntityInfo.class, "propertyNames", this.filterProps);
        this.addFilteredProperty(EntityInfo.class, "relatedProperties", this.filterProps);
        this.addFilteredProperty(ColumnInfo.class, "length", this.nullFilterProps);
        this.addFilteredProperty(ColumnInfo.class, "precision", this.nullFilterProps);
    }

    @Override
    public boolean filter(Object source, String name, Object value) {
        if (this.checkFilterProps(source, name)) {
            return true;
        }
        if (value == null && this.checkNullFilterProps(source, name)) {
            return true;
        }
        return super.filter(source, name, value);
    }

    private boolean checkFilterProps(Object source, String name) {
        Collection c = this.filterProps.get(source.getClass());
        return c != null && c.contains(name);
    }

    private boolean checkNullFilterProps(Object source, String name) {
        Collection c = this.nullFilterProps.get(source.getClass());
        return c != null && c.contains(name);
    }

    private void addFilteredProperty(Class<?> clazz, String propertyName, OneToManyMap<Class<?>, String> m) {
        if (!this.objectAccess.hasProperty(clazz, propertyName)) {
            throw new AssertionError((Object)("property " + propertyName + " doesn't exist on " + clazz.getName()));
        }
        m.put(clazz, (Object)propertyName);
    }
}

