/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.Resource;
import com.wavemaker.runtime.data.ExternalDataModelConfig;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.service.DesignServiceManager;
import com.wavemaker.tools.service.definitions.Operation;

public class DesignExternalDataModelConfig
implements ExternalDataModelConfig {
    private final String serviceId;
    private final DesignServiceManager serviceMgr;

    public DesignExternalDataModelConfig(String serviceId, DesignServiceManager serviceMgr) {
        this.serviceId = serviceId;
        this.serviceMgr = serviceMgr;
    }

    public boolean returnsSingleResult(String operationName) {
        Operation.Return rtn = this.getReturn(operationName);
        if (rtn == null) {
            return false;
        }
        return !rtn.isIsList();
    }

    public String getServiceClass() {
        return this.serviceMgr.getService(this.serviceId).getClazz();
    }

    public String getOutputType(String operationName) {
        Operation.Return rtn = this.getReturn(operationName);
        if (rtn == null) {
            return null;
        }
        return rtn.getTypeRef();
    }

    private Operation.Return getReturn(String operationName) {
        Operation o = this.serviceMgr.getOperation(this.serviceId, operationName);
        if (o == null) {
            throw new ConfigurationException(Resource.OPERATION_NOT_FOUND, this.serviceId, operationName, this.serviceMgr.getOperationNames(this.serviceId));
        }
        return o.getReturn();
    }
}

