/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.OneToManyMap;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.ColumnInfo;
import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.PropertyInfo;
import com.wavemaker.tools.data.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInfo
implements Cloneable {
    private static final String DEFAULT_ID_NAME = "Id";
    private String packageName = null;
    private String entity = null;
    private String table = null;
    private String catalog = null;
    private String schema = null;
    private boolean dynamicInsert = false;
    private boolean dynamicUpdate = false;
    private boolean refreshEntity = false;
    private PropertyInfo id = null;
    private Map<String, PropertyInfo> properties = new LinkedHashMap<String, PropertyInfo>();
    private Map<String, PropertyInfo> relatedProperties = new LinkedHashMap<String, PropertyInfo>();
    private Map<String, ColumnInfo> columns = new LinkedHashMap<String, ColumnInfo>();

    public EntityInfo() {
    }

    public EntityInfo(String packageName, String entity, String table, String schema, String catalog) {
        this.entity = entity;
        this.table = table;
        this.schema = schema;
        this.catalog = catalog;
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getEntityName() {
        return this.entity;
    }

    public void setEntityName(String entity) {
        this.entity = entity;
    }

    public String getTableName() {
        return this.table;
    }

    public void setTableName(String table) {
        this.table = table;
    }

    public String getCatalogName() {
        return this.catalog;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public void setSchemaName(String schema) {
        this.schema = schema;
    }

    public void setCatalogName(String catalog) {
        this.catalog = catalog;
    }

    public PropertyInfo getId() {
        return this.id;
    }

    public void setId(PropertyInfo id) {
        this.id = id;
    }

    public boolean isDynamicInsert() {
        return this.dynamicInsert;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public boolean isDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public boolean isRefreshEntity() {
        return this.refreshEntity;
    }

    public void setRefreshEntity(boolean refreshEntity) {
        this.refreshEntity = refreshEntity;
    }

    public PropertyInfo getProperty(String property) {
        return this.properties.get(property);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<PropertyInfo> getProperties() {
        return this.properties.values();
    }

    public Map<String, PropertyInfo> getPropertiesMap() {
        return this.properties;
    }

    public void setProperties(List<PropertyInfo> properties) {
        for (PropertyInfo p : properties) {
            this.properties.put(p.getName(), p);
        }
    }

    public void addProperty(PropertyInfo property) {
        this.properties.put(property.getName(), property);
    }

    public void removeProperty(PropertyInfo property) {
        this.relatedProperties.remove(property.getName());
        this.properties.remove(property.getName());
    }

    public void initFkColumnTypes(DataModelConfiguration cfg) {
        for (PropertyInfo p : this.properties.values()) {
            if (!p.getIsRelated() || p.getIsInverse()) continue;
            int i = 0;
            for (ColumnInfo ci : p.allColumns()) {
                ci.setSqlType(this.getReferencedPkType(p, cfg, i));
                ci.persistType(false);
                ++i;
            }
        }
    }

    public Collection<PropertyInfo> getRelatedProperties() {
        return this.relatedProperties.values();
    }

    public void setRelatedProperties(List<PropertyInfo> relatedProperties) {
        for (PropertyInfo p : relatedProperties) {
            this.relatedProperties.put(p.getName(), p);
        }
    }

    public void addRelatedProperty(PropertyInfo property) {
        this.addProperty(property);
        this.relatedProperties.put(property.getName(), property);
    }

    public Collection<ColumnInfo> getColumns() {
        return this.columns.values();
    }

    public ColumnInfo getColumn(String name) {
        return this.columns.get(name);
    }

    public void setColumns(Map<String, ColumnInfo> columns) {
        this.columns = columns;
    }

    public Map<String, ColumnInfo> getColumnsMap() {
        return this.columns;
    }

    public void addColumn(ColumnInfo column) {
        this.columns.put(column.getName(), column);
    }

    public void removeColumn(ColumnInfo column) {
        this.columns.remove(column.getName());
    }

    public Collection<EntityInfo> updateRelated(List<PropertyInfo> rels, DataModelConfiguration mgr) {
        for (PropertyInfo p : rels) {
            mgr.getEntity(p.getType());
        }
        HashSet<EntityInfo> rtn = new HashSet<EntityInfo>();
        OneToManyMap<EntityInfo, PropertyInfo> removedProperties = this.removeAllOwnedRelated(mgr, rels);
        rtn.addAll(removedProperties.keySet());
        for (PropertyInfo rel : rels) {
            if (rel.getIsInverse()) {
                boolean found = false;
                for (PropertyInfo currentRelated : new HashSet<PropertyInfo>(this.relatedProperties.values())) {
                    if (!currentRelated.getIsInverse() || !this.matches(rel, currentRelated)) continue;
                    this.removeProperty(currentRelated);
                    currentRelated.setName(rel.getName());
                    currentRelated.setCascadeOptions(rel.getCascadeOptions());
                    this.addRelatedProperty(currentRelated);
                    found = true;
                    break;
                }
                if (found) continue;
                this.addRelatedProperty(rel);
                continue;
            }
            this.movePropertyToRelated(rel);
            PropertyInfo toMany = PropertyInfo.newToManyProperty(this, rel);
            EntityInfo relatedEntity = mgr.getEntity(rel.getType());
            String toManyName = null;
            if (removedProperties.containsKey((Object)relatedEntity)) {
                for (PropertyInfo p : removedProperties.get((Object)relatedEntity)) {
                    if (!p.getColumn().getName().equals(rel.getColumn().getName())) continue;
                    toManyName = p.getName();
                    toMany.setCascadeOptions(p.getCascadeOptions());
                }
            }
            if (toManyName == null && (toManyName = relatedEntity.getUniquePropertyName(toMany.getType() + "s").toLowerCase()).endsWith("ys")) {
                toManyName = toManyName.substring(0, toManyName.length() - 2) + "ies";
            }
            toMany.setName(toManyName);
            relatedEntity.addRelatedProperty(toMany);
            List<ColumnInfo> allColumns = rel.allColumns();
            if (allColumns.size() == 1) {
                ColumnInfo ci = allColumns.iterator().next();
                toMany.setColumn((ColumnInfo)ci.clone());
            } else {
                for (ColumnInfo ci : allColumns) {
                    ColumnInfo clone = (ColumnInfo)ci.clone();
                    PropertyInfo p = PropertyInfo.newProperty();
                    p.fromColumn(clone);
                    toMany.addCompositeProperty(p);
                }
            }
            rtn.add(relatedEntity);
        }
        return rtn;
    }

    public String getUniquePropertyName(String name) {
        return StringUtils.getUniqueName((String)name, this.properties.keySet());
    }

    public void updateColumnGenerator(List<ColumnInfo> columns) {
        for (ColumnInfo ci : columns) {
            ColumnInfo org = this.getColumn(ci.getName());
            org.setGenerator(ci.getGenerator());
            org.setGeneratorParam(ci.getGeneratorParam());
        }
    }

    public void updateColumns(List<ColumnInfo> columns, List<PropertyInfo> properties, DataModelConfiguration config) {
        this.ensureIdColumnExists(columns);
        String compIdType = null;
        if (this.getId() != null && this.getId().hasCompositeProperties()) {
            compIdType = this.getId().getType();
        }
        this.removeSimpleProperties();
        columns = new ArrayList<ColumnInfo>(columns);
        ArrayList<ColumnInfo> primaryKeyColumns = new ArrayList<ColumnInfo>();
        for (ColumnInfo ci : new ArrayList<ColumnInfo>(columns)) {
            if (!ci.getIsPk()) continue;
            primaryKeyColumns.add(ci);
            columns.remove(ci);
        }
        this.addIdColumns(primaryKeyColumns, properties, compIdType, config);
        for (ColumnInfo ci : columns) {
            if (ci.getIsFk()) continue;
            PropertyInfo p = this.getPropertyForColumn(ci, properties);
            this.namesToJavaIdentifiers(p);
            this.addProperty(p);
            this.addColumn(ci);
        }
    }

    public void update(EntityInfo o) {
        this.entity = o.entity;
        this.packageName = o.packageName;
        this.table = o.table;
        this.schema = o.schema;
        this.catalog = o.catalog;
        this.dynamicInsert = o.dynamicInsert;
        this.dynamicUpdate = o.dynamicUpdate;
        this.refreshEntity = o.refreshEntity;
    }

    public boolean isEqualTo(EntityInfo o) {
        if (o == null) {
            return false;
        }
        boolean rtn = String.valueOf(this.entity).equals(String.valueOf(o.entity));
        rtn &= String.valueOf(this.packageName).equals(String.valueOf(o.packageName));
        rtn &= String.valueOf(this.table).equals(String.valueOf(o.table));
        rtn &= String.valueOf(this.schema).equals(String.valueOf(o.schema));
        rtn &= String.valueOf(this.catalog).equals(String.valueOf(o.catalog));
        rtn &= String.valueOf(this.entity).equals(String.valueOf(o.entity));
        rtn &= this.dynamicInsert == o.dynamicInsert;
        rtn &= this.dynamicUpdate == o.dynamicUpdate;
        return rtn &= this.refreshEntity == o.refreshEntity;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public String toString() {
        return "entity: " + this.entity + ", package: " + this.packageName + ", table: " + this.table + ", catalog: " + this.catalog;
    }

    private void ensureIdColumnExists(Collection<ColumnInfo> columns) {
        boolean foundId = false;
        for (ColumnInfo ci : columns) {
            if (!ci.getIsPk()) continue;
            foundId = true;
            break;
        }
        if (!foundId) {
            throw new ConfigurationException(Resource.NO_PRIMARY_KEY);
        }
    }

    private boolean matches(PropertyInfo p1, PropertyInfo p2) {
        return p1.getType().equals(p2.getType()) && p1.getColumn().getName().equals(p2.getColumn().getName());
    }

    private String getReferencedPkType(PropertyInfo p, DataModelConfiguration cfg, int fkColIndex) {
        EntityInfo other = cfg.getEntity(p.getType());
        PropertyInfo id = other.getId();
        if (id.hasCompositeProperties()) {
            int i = 0;
            for (PropertyInfo cp : id.getCompositeProperties()) {
                if (i == fkColIndex) {
                    return cp.getFullyQualifiedType();
                }
                ++i;
            }
        }
        return other.getId().getFullyQualifiedType();
    }

    private void moveRelatedToProperty(PropertyInfo property, DataModelConfiguration cfg) {
        this.removeProperty(property);
        List<PropertyInfo> l = this.getPropertiesMatchingColumnNames(property);
        if (!l.isEmpty()) {
            return;
        }
        property.setName(property.getColumn().getName());
        property.setIsRelated(false);
        property.setIsInverse(false);
        property.getColumn().setIsFk(false);
        this.addProperty(property);
        property.types(this.getReferencedPkType(property, cfg, -1));
        property.getColumn().persistType(false);
    }

    private void movePropertyToRelated(PropertyInfo related) {
        List<PropertyInfo> propsToMove = this.getPropertiesMatchingColumnNames(related);
        for (PropertyInfo p : propsToMove) {
            this.removeProperty(p);
            this.removeColumn(p.getColumn());
        }
        this.addRelatedProperty(related);
        for (ColumnInfo ci : related.allColumns()) {
            this.addColumn(ci);
            ci.setIsFk(true);
        }
    }

    private void removeSimpleProperties() {
        for (PropertyInfo p : new HashSet<PropertyInfo>(this.properties.values())) {
            if (p.getIsRelated()) continue;
            this.removeProperty(p);
            for (ColumnInfo ci : p.allColumns()) {
                this.removeColumn(ci);
            }
        }
    }

    private OneToManyMap<EntityInfo, PropertyInfo> removeAllOwnedRelated(DataModelConfiguration mgr, List<PropertyInfo> rels) {
        OneToManyMap rtn = new OneToManyMap();
        for (PropertyInfo p : new HashSet<PropertyInfo>(this.relatedProperties.values())) {
            if (p.getIsInverse() && this.existsInRels(p, rels)) continue;
            EntityInfo other = mgr.getEntity(p.getType());
            for (PropertyInfo op : new HashSet<PropertyInfo>(other.getRelatedProperties())) {
                if (!op.getType().equals(this.entity) || !op.getColumn().getName().equals(p.getColumn().getName())) continue;
                other.removeProperty(op);
                rtn.put((Object)other, (Object)op);
            }
            this.moveRelatedToProperty(p, mgr);
        }
        return rtn;
    }

    private boolean existsInRels(PropertyInfo propInfo, List<PropertyInfo> rels) {
        boolean rtn = false;
        for (PropertyInfo p : rels) {
            if (!propInfo.getType().equals(p.getType()) || !propInfo.getColumn().getName().equals(p.getColumn().getName())) continue;
            rtn = true;
            break;
        }
        return rtn;
    }

    private String getPropertyNameForColumn(ColumnInfo column, List<PropertyInfo> properties) {
        for (PropertyInfo p : properties) {
            for (PropertyInfo p2 : p.allProperties()) {
                ColumnInfo ci = p2.getColumn();
                if (ci == null || !ci.getName().equals(column.getName())) continue;
                return p2.getName();
            }
        }
        return null;
    }

    private PropertyInfo getPropertyForColumn(ColumnInfo column, List<PropertyInfo> properties) {
        PropertyInfo rtn = PropertyInfo.newProperty();
        rtn.fromColumn(column);
        String propertyName = this.getPropertyNameForColumn(column, properties);
        if (propertyName != null) {
            rtn.setName(propertyName);
        }
        return rtn;
    }

    private Tuple.Two<String, Boolean> getCompositeIdType(List<PropertyInfo> properties) {
        String typeName = null;
        Boolean isNewKey = Boolean.FALSE;
        for (PropertyInfo p : properties) {
            if (!p.getIsId() || !p.hasCompositeProperties()) continue;
            typeName = p.getFullyQualifiedType();
            break;
        }
        if (typeName == null) {
            isNewKey = Boolean.TRUE;
            typeName = StringUtils.fq((String)this.getPackageName(), (String)this.getEntityName()) + DEFAULT_ID_NAME;
        }
        return Tuple.tuple(typeName, (Object)isNewKey);
    }

    private void addIdColumns(List<ColumnInfo> primaryKeyColumns, List<PropertyInfo> properties, String prevCompIdType, DataModelConfiguration config) {
        PropertyInfo id = null;
        if (primaryKeyColumns.size() > 1) {
            Tuple.Two<String, Boolean> t = this.getCompositeIdType(properties);
            String compositeIdType = (String)t.v1;
            Boolean isNewType = (Boolean)t.v2;
            id = PropertyInfo.newCompositeIdProperty(Collections.<String, String>emptyMap());
            id.types(compositeIdType);
            for (ColumnInfo ci : primaryKeyColumns) {
                ci.setGenerator(null);
                PropertyInfo p = this.getPropertyForColumn(ci, properties);
                id.addCompositeProperty(p);
                this.addColumn(ci);
                String name = DEFAULT_ID_NAME.toLowerCase();
                if (isNewType.booleanValue()) {
                    config.addValueType(new TypeInfo(compositeIdType));
                } else {
                    for (PropertyInfo prop : properties) {
                        if (!prop.getIsId()) continue;
                        name = prop.getName();
                        break;
                    }
                }
                id.setName(name);
            }
        } else if (primaryKeyColumns.size() == 1) {
            ColumnInfo ci = primaryKeyColumns.iterator().next();
            id = PropertyInfo.newIdProperty();
            id.fromColumn(ci);
            this.addColumn(ci);
            id.setName(this.getPropertyNameForColumn(ci, properties));
            if (id.getName() == null) {
                id.setName(ci.getName());
            }
            if (prevCompIdType != null) {
                config.deleteValueType(prevCompIdType);
            }
            if (ObjectUtils.isNullOrEmpty((String)ci.getGenerator())) {
                ci.setGenerator("assigned");
            }
        }
        if (id != null) {
            this.id = id;
            this.namesToJavaIdentifiers(id);
            this.addProperty(id);
        }
    }

    private void namesToJavaIdentifiers(PropertyInfo property) {
        for (PropertyInfo p : property.allProperties()) {
            p.setName(StringUtils.toJavaIdentifier((String)p.getName()));
        }
    }

    private List<PropertyInfo> getPropertiesMatchingColumnNames(PropertyInfo property) {
        List<String> colNamesToFind = property.allColumnNames();
        ArrayList<PropertyInfo> rtn = new ArrayList<PropertyInfo>();
        for (PropertyInfo p : this.properties.values()) {
            if (p.hasCompositeProperties() || !colNamesToFind.contains(p.getColumn().getName())) continue;
            rtn.add(p);
            if (rtn.size() != colNamesToFind.size()) continue;
            return rtn;
        }
        return rtn;
    }
}

