/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.Resource;
import com.wavemaker.common.util.CastUtils;
import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.Tuple;
import com.wavemaker.runtime.data.DataServiceRuntimeException;
import com.wavemaker.runtime.data.util.JDBCUtils;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.BaseDataModelSetup;
import com.wavemaker.tools.data.parser.HbmParser;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportDB
extends BaseDataModelSetup {
    private static final String HBM_FILES_DIR_SYSTEM_PROPERTY = "wm.importdb.hbmFilesDir";
    private File hbmFilesDir = null;
    private boolean exportToDatabase = false;
    private List<Throwable> errors = null;
    private boolean verbose = false;
    private boolean overrideTable = false;
    private String ddl = null;
    private File classesDir = null;

    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setOverrideTable(boolean val) {
        this.overrideTable = val;
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public void setHbmFilesDir(File hbmFilesDir) {
        this.hbmFilesDir = hbmFilesDir;
    }

    public void addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void setExportToDB(boolean exportToDatabase) {
        this.exportToDatabase = exportToDatabase;
    }

    public String getDDL() {
        return this.ddl;
    }

    @Override
    protected void customRun() {
        this.init();
        final Configuration cfg = new Configuration();
        cfg.addDirectory(this.hbmFilesDir);
        Properties connectionProperties = this.getHibernateConnectionProperties();
        cfg.addProperties(connectionProperties);
        SchemaExport export = null;
        SchemaUpdate update = null;
        File ddlFile = null;
        try {
            if (this.overrideTable) {
                ClassLoaderUtils.TaskRtn t = new ClassLoaderUtils.TaskRtn(){

                    public SchemaExport run() {
                        return new SchemaExport(cfg);
                    }
                };
                export = this.classesDir == null ? (SchemaExport)t.run() : (SchemaExport)ClassLoaderUtils.runInClassLoaderContext((ClassLoaderUtils.TaskType)t, (File[])new File[]{this.classesDir});
                ddlFile = File.createTempFile("ddl", ".sql");
                ddlFile.deleteOnExit();
                export.setOutputFile(ddlFile.getAbsolutePath());
                export.setDelimiter(";");
                export.setFormat(true);
                String extraddl = this.prepareForExport(this.exportToDatabase);
                export.create(this.verbose, this.exportToDatabase);
                this.errors = CastUtils.cast((List)export.getExceptions());
                this.errors = this.filterError(this.errors, connectionProperties);
                this.ddl = IOUtils.read((File)ddlFile);
                if (!ObjectUtils.isNullOrEmpty((String)extraddl)) {
                    this.ddl = extraddl + "\n" + this.ddl;
                }
            } else {
                ClassLoaderUtils.TaskRtn t = new ClassLoaderUtils.TaskRtn(){

                    public SchemaUpdate run() {
                        return new SchemaUpdate(cfg);
                    }
                };
                update = this.classesDir == null ? (SchemaUpdate)t.run() : (SchemaUpdate)ClassLoaderUtils.runInClassLoaderContext((ClassLoaderUtils.TaskType)t, (File[])new File[]{this.classesDir});
                String extraddl = this.prepareForExport(this.exportToDatabase);
                Connection conn = JDBCUtils.getConnection(this.connectionUrl, this.username, this.password, this.driverClassName);
                Dialect dialect = Dialect.getDialect((Properties)connectionProperties);
                DatabaseMetadata meta = new DatabaseMetadata(conn, dialect);
                String[] updateSQL = cfg.generateSchemaUpdateScript(dialect, meta);
                update.execute(this.verbose, this.exportToDatabase);
                this.errors = CastUtils.cast((List)update.getExceptions());
                StringBuilder sb = new StringBuilder();
                for (String line : updateSQL) {
                    sb = sb.append(line);
                    sb = sb.append("\n");
                }
                this.ddl = sb.toString();
            }
        }
        catch (IOException ex) {
            throw new DataServiceRuntimeException(ex);
        }
        catch (SQLException qex) {
            throw new DataServiceRuntimeException(qex);
        }
        finally {
            try {
                ddlFile.delete();
            }
            catch (Exception ignore) {}
        }
    }

    private List<Throwable> filterError(List<Throwable> errors, Properties props) {
        String dbType;
        ArrayList<Throwable> rtn = new ArrayList<Throwable>();
        String dialect = (String)props.get(".dialect");
        if (dialect == null) {
            return rtn;
        }
        if (dialect.contains("MySQL")) {
            dbType = "mysql";
        } else if (dialect.contains("HSQL")) {
            dbType = "hsql";
        } else {
            return rtn;
        }
        for (Throwable t : errors) {
            String msg = t.getMessage();
            if (dbType.equals("mysql") && msg.substring(0, 5).equals("Table") && msg.lastIndexOf("doesn't exist") == msg.length() - 13 || dbType.equals("hsql") && msg.substring(0, 16).equals("Table not found:") && msg.contains("in statement [alter table")) continue;
            rtn.add(t);
        }
        return rtn;
    }

    @Override
    protected boolean customInit(Collection<String> requiredProperties) {
        this.checkHbmFilesDir(requiredProperties);
        this.checkRevengNamingStrategy();
        return this.initConnection(requiredProperties, true);
    }

    @Override
    protected void customDispose() {
    }

    private String prepareForExport(boolean run) {
        if (!this.isMySQL() && !this.isPostgres()) {
            return null;
        }
        Tuple.Two<String, String> t = this.getMappedSchemaAndCatalog();
        String schemaName = (String)t.v1;
        String catalogName = (String)t.v2;
        String urlDBName = this.getDatabaseNameFromConnectionUrl();
        String url = this.connectionUrl;
        if (this.isMySQL() && !ObjectUtils.isNullOrEmpty((String)schemaName)) {
            throw new ConfigurationException(Resource.UNSET_SCHEMA, "MySQL");
        }
        if (ObjectUtils.isNullOrEmpty((String)catalogName)) {
            throw new ConfigurationException(Resource.CATALOG_SHOULD_BE_SET);
        }
        if (!ObjectUtils.isNullOrEmpty((String)urlDBName)) {
            url = this.connectionUrl.substring(0, this.connectionUrl.indexOf(urlDBName));
            if (!catalogName.equals(urlDBName)) {
                throw new ConfigurationException(Resource.MISMATCH_CATALOG_DBNAME, urlDBName, catalogName);
            }
        }
        String ddl = null;
        ddl = this.isMySQL() ? "create database if not exists " : "create database ";
        ddl = ddl + catalogName;
        try {
            if (run) {
                this.runDDL(ddl, url);
            }
        }
        catch (RuntimeException ignore) {
            // empty catch block
        }
        return ddl;
    }

    private void checkHbmFilesDir(Collection<String> requiredProperties) {
        String s;
        if (this.hbmFilesDir == null && (s = this.properties.getProperty(HBM_FILES_DIR_SYSTEM_PROPERTY)) != null) {
            this.setHbmFilesDir(new File(s));
        }
        if (this.hbmFilesDir == null) {
            requiredProperties.add(HBM_FILES_DIR_SYSTEM_PROPERTY);
        }
    }

    private String getDatabaseNameFromConnectionUrl() {
        return JDBCUtils.getMySQLDatabaseName(this.connectionUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple.Two<String, String> getMappedSchemaAndCatalog() {
        for (String s : this.hbmFilesDir.list()) {
            File f = new File(this.hbmFilesDir, s);
            if (f.isDirectory()) continue;
            HbmParser p = null;
            try {
                p = new HbmParser(f);
                Tuple.Two two = Tuple.tuple((Object)p.getEntity().getSchemaName(), (Object)p.getEntity().getCatalogName());
                return two;
            }
            catch (RuntimeException ignore) {
            }
            finally {
                try {
                    p.close();
                }
                catch (RuntimeException ignore) {}
            }
        }
        return null;
    }
}

