/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.IOUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.common.util.XMLWriter;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.GenerationContext;
import com.wavemaker.tools.data.util.DataServiceUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.TemplateProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSpringConfigExporter
extends GenericExporter {
    private static final String TEMPLATE = "/com/wavemaker/tools/data/SpringConfig.ftl";
    private static final String DEFAULT_QUERIES_FILE = "com/wavemaker/tools/data/DefaultQueries.ql.xml";
    private final String serviceName;
    private final String dataPackage;
    private final String serviceClass;
    private final boolean useIndividualCRUDOperations;

    public HibernateSpringConfigExporter(String serviceName, String packageName, String dataPackage, String serviceClass, boolean useIndividualCRUDOperations) {
        this.serviceName = serviceName;
        this.dataPackage = dataPackage;
        this.serviceClass = StringUtils.fq((String)packageName, (String)serviceClass);
        this.useIndividualCRUDOperations = useIndividualCRUDOperations;
        this.setTemplateName(TEMPLATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        File path = new File(this.getOutputDirectory(), DataServiceUtils.getCfgFileName(this.serviceName));
        TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
        HashMap<String, Context> additionalContext = new HashMap<String, Context>(1);
        Context ctx = new Context(this.serviceName, this.serviceClass);
        try {
            additionalContext.put("agcontext", ctx);
            producer.produce(additionalContext, this.getTemplateName(), path, this.getTemplateName());
        }
        finally {
            ctx.dispose();
        }
    }

    public String getName() {
        return "Spring Configuration Exporter";
    }

    private String addDefaultQueriesFile(Collection<String> reservedNames, String relPath) {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = ClassLoaderUtils.getResourceAsStream((String)DEFAULT_QUERIES_FILE);
            String name = DataServiceUtils.getDefaultQueryFileName(reservedNames);
            name = relPath + "/" + name;
            File f = new File(this.getOutputDirectory(), name);
            f.getParentFile().mkdirs();
            os = new FileOutputStream(f);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            String string = name;
            return string;
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignore) {}
            try {
                os.close();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Context
    extends GenerationContext {
        private final String serviceClass;

        Context(String serviceName, String serviceClass) {
            super(serviceName, HibernateSpringConfigExporter.this.getConfiguration(), HibernateSpringConfigExporter.this.useIndividualCRUDOperations);
            this.serviceClass = XMLUtils.escape((String)serviceClass);
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public String getHbmFiles() {
            List<Class<?>> entityClasses = this.def.getMetaData().getEntityClasses();
            return this.getFileList(entityClasses, ".hbm.xml", false);
        }

        public String getQueryFiles() {
            List<Class<?>> entityClasses = DataServiceUtils.getTypesForGeneratedQueries(this.def.getMetaData());
            return this.getFileList(entityClasses, ".ql.xml", true);
        }

        private String getFileList(List<Class<?>> entityClasses, String ext, boolean addDefaultQueryFile) {
            HashSet<String> fileNames = new HashSet<String>(entityClasses.size());
            StringWriter sw = new StringWriter();
            XMLWriter xmlWriter = XMLUtils.newXMLWriter((PrintWriter)new PrintWriter(sw));
            for (Class<?> c : entityClasses) {
                String s = StringUtils.packageToSrcFilePath((String)c.getName());
                fileNames.add(StringUtils.fromLastOccurrence((String)s, (String)"/"));
                xmlWriter.addElement("value", s + ext);
            }
            if (addDefaultQueryFile) {
                String relPath = StringUtils.packageToSrcFilePath((String)HibernateSpringConfigExporter.this.dataPackage);
                relPath = HibernateSpringConfigExporter.this.addDefaultQueriesFile(fileNames, relPath);
                xmlWriter.addElement("value", relPath);
            }
            xmlWriter.finish();
            return sw.toString();
        }
    }
}

