/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.WMRuntimeException;
import com.wavemaker.common.util.ClassLoaderUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.service.definition.DeprecatedServiceDefinition;
import com.wavemaker.runtime.service.definition.ServiceDefinition;
import com.wavemaker.tools.common.Bootstrap;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.BaseDataModelSetup;
import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.DataServiceGenerator;
import com.wavemaker.tools.data.DataServiceLoggers;
import com.wavemaker.tools.data.HibernateConfigExporterTask;
import com.wavemaker.tools.data.QueryExporterTask;
import com.wavemaker.tools.data.Reveng;
import com.wavemaker.tools.data.WMJDBCConfigurationTask;
import com.wavemaker.tools.data.reveng.BasicMetaDataDialect;
import com.wavemaker.tools.data.reveng.MetaDataDialect;
import com.wavemaker.tools.data.spring.SpringService;
import com.wavemaker.tools.data.util.DataServiceUtils;
import com.wavemaker.tools.service.DefaultClassLoaderFactory;
import com.wavemaker.tools.service.DefaultCompileService;
import com.wavemaker.tools.service.codegen.GenerationConfiguration;
import com.wavemaker.tools.service.codegen.GenerationException;
import com.wavemaker.tools.util.AntUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.Hbm2HbmXmlExporterTask;
import org.hibernate.tool.ant.Hbm2JavaExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDB
extends BaseDataModelSetup {
    private static final String REVENG_SYSTEM_PROPERTY = "wm.importdb.reveng";
    private static final String CLASSES_DIR_SYSTEM_PROPERTY = "wm.importdb.classesDir";
    private static final String SERVICE_CLASS_SYSTEM_PROPERTY = "wm.importdb.serviceClass";
    private static final String IMPORT_DATABASE_SYSTEM_PROPERTY = "wm.importdb.genCfg";
    private static final String GENERATE_SERVICE_CLASS_SYSTEM_PROPERTY = "wm.importdb.genServiceClass";
    private static final String CREATE_JAR_SYSTEM_PROPERTY = "wm.importdb.jar";
    private static final String GENERATE_HIBERNATE_CONFIG_SYSTEM_PROPERTY = "wm.importdb.genHibernateCfg";
    private static final String GENERATE_SERVICE_MAIN_SYSTEM_PROPERTY = "wm.importdb.genServiceMain";
    private static final String REGENERATE_SYSTEM_PROPERTY = "wm.importdb.regenerate";
    private static final String GENERATE_OLD_STYLE_OPRS_PROPERTY = "wm.importdb.useIndividualCRUDOperations";
    private static final String REVENG_METADATA_DIALECT_SYSTEM_PROPERTY = "hibernatetool.metadatadialect";
    private boolean generateHibernateCfg = false;
    private boolean importDatabase = true;
    private boolean generateServiceClass = true;
    private boolean useIndividualCRUDOperations = false;
    private boolean valuesFromReveng = false;
    private File classesdir = null;
    private final List<File> revengFiles = new ArrayList<File>();
    private final WMJDBCConfigurationTask jdbcConf = new WMJDBCConfigurationTask();
    private boolean createJar = false;
    private boolean compile;
    private boolean compileServiceClass = this.compile = true;
    private boolean generateServiceMain = false;
    private boolean regenerate = true;
    private String revengMetaDataDialect = null;
    private DeprecatedServiceDefinition serviceDefinition = null;

    public ImportDB() {
        this(ImportDB.bootstrap(), new Project(), true);
    }

    public ImportDB(boolean resolveSystemProperties) {
        this(false, new Project(), resolveSystemProperties);
    }

    public ImportDB(Project project, boolean resolveSystemProperties) {
        this(false, project, resolveSystemProperties);
    }

    private ImportDB(boolean internal, Project project, boolean resolveSystemProperties) {
        super(project);
        if (resolveSystemProperties) {
            this.properties.putAll((Map<?, ?>)System.getProperties());
        }
        this.jdbcConf.setDetectOptimisticLock(false);
        this.jdbcConf.setDetectManyToMany(false);
        this.jdbcConf.setProject(project);
    }

    private static boolean bootstrap() {
        Bootstrap.main(null);
        return true;
    }

    public void setUseIndividualCRUDOperations(boolean useIndividualCRUDOperations) {
        this.useIndividualCRUDOperations = useIndividualCRUDOperations;
    }

    @Override
    public boolean getUseIndividualCRUDOperations() {
        return this.useIndividualCRUDOperations;
    }

    public void setRegenerate(boolean regenerate) {
        this.regenerate = regenerate;
    }

    public void setRevengMetaDataDialect(String revengMetaDataDialect) {
        this.revengMetaDataDialect = revengMetaDataDialect;
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
        this.compileServiceClass = compile;
    }

    public void setGenerateServiceMain(boolean generateServiceMain) {
        this.generateServiceMain = generateServiceMain;
    }

    public void setCompileServiceClass(boolean compileServiceClass) {
        this.compileServiceClass = compileServiceClass;
    }

    public void setGenerateHibernateCfg(boolean generateHibernateCfg) {
        this.generateHibernateCfg = generateHibernateCfg;
    }

    public void setCreateJar(boolean createJar) {
        this.createJar = createJar;
    }

    public void setImportDatabase(boolean importDatabase) {
        this.importDatabase = importDatabase;
    }

    public void setGenerateServiceClass(boolean generateServiceClass) {
        this.generateServiceClass = generateServiceClass;
    }

    public void addRevengFile(File f) {
        this.revengFiles.add(f);
    }

    public void setClassesDir(File classesDir) {
        this.classesdir = classesDir;
    }

    @Override
    protected void customRun() {
        if (this.importDatabase) {
            this.generateBaseConfigFiles();
        }
        ClassLoaderUtils.TaskRtn t = new ClassLoaderUtils.TaskRtn(){

            public ServiceDefinition run() {
                if (ImportDB.this.importDatabase) {
                    ImportDB.this.generateConfigFiles();
                }
                DeprecatedServiceDefinition def = ImportDB.this.loadServiceDefinition();
                if (ImportDB.this.generateServiceClass) {
                    ImportDB.this.generateServiceClass(def);
                }
                if (ImportDB.this.compile && ImportDB.this.compileServiceClass) {
                    ImportDB.this.compile();
                }
                return def;
            }
        };
        this.serviceDefinition = (DeprecatedServiceDefinition)ClassLoaderUtils.runInClassLoaderContext((ClassLoaderUtils.TaskType)t, (File[])new File[]{this.destdir, this.classesdir});
        if (this.importDatabase && this.regenerate) {
            this.regenerate();
        }
        if (this.createJar) {
            AntUtils.jar(new File(this.serviceName + ".jar"), this.destdir);
        }
    }

    @Override
    protected void customDispose() {
        if (this.serviceDefinition != null) {
            this.serviceDefinition.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerate() {
        File springCfg = new File(this.destdir, DataServiceUtils.getCfgFileName(this.serviceName));
        DataModelConfiguration cfg = new DataModelConfiguration(springCfg, new DefaultClassLoaderFactory(this.destdir, this.classesdir), new DefaultCompileService(this.destdir, this.classesdir));
        try {
            cfg.touchAllEntities();
            cfg.save();
        }
        finally {
            cfg.dispose();
        }
    }

    private void generateBaseConfigFiles() {
        Properties connectionProperties = this.getHibernateConnectionProperties();
        this.properties.putAll((Map<?, ?>)connectionProperties);
        this.jdbcConf.setProperties(this.properties);
        this.jdbcConf.setReverseStrategy(this.revengNamingStrategy);
        Configuration cfg = this.jdbcConf.getConfiguration();
        this.getParentTask().setConfiguration(cfg);
        this.checkTables(cfg);
        this.destdir.mkdirs();
        this.writePropertiesFile(cfg);
        this.getJavaExporter().execute();
        this.removeConstructor();
        if (this.compile) {
            this.compile();
        }
    }

    private void removeConstructor() {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                int len = name.length();
                return name.substring(len - 5).equals(".java");
            }
        };
        File[] javafiles = this.javadir.listFiles(filter);
        if (javafiles != null) {
            try {
                for (File file : javafiles) {
                    String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
                    String fileName = file.getName();
                    int len = fileName.length();
                    fileName = fileName.substring(0, len - 5);
                    String regExp = "public\\s+" + fileName + "\\s*\\([^\\)]*\\)\\s*\\{[^\\}]*\\}";
                    Pattern pattern = Pattern.compile(regExp);
                    Matcher matcher = pattern.matcher(content);
                    boolean done = false;
                    while (!done) {
                        if (matcher.find()) {
                            int indx1 = matcher.start();
                            int indx2 = matcher.end();
                            String str = content.substring(indx1, indx2);
                            content = content.replace(str, "");
                            matcher = pattern.matcher(content);
                            continue;
                        }
                        done = true;
                    }
                    FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
                }
            }
            catch (IOException ioe) {
                throw new WMRuntimeException((Throwable)ioe);
            }
        }
    }

    private void generateConfigFiles() {
        for (ExporterTask e : this.getPostCompileExporters()) {
            e.execute();
        }
    }

    private void compile() {
        if (!this.classesdir.exists()) {
            this.classesdir.mkdirs();
        }
        String includes = this.packageName.replace(".", "/") + "/* ";
        if (!this.packageName.equals(this.dataPackage)) {
            includes = includes + this.dataPackage.replace(".", "/") + "/*";
        }
        AntUtils.javac(this.destdir.getAbsolutePath(), this.classesdir, includes);
    }

    protected void writePropertiesFile(Configuration cfg) {
        Properties p = this.getProperties();
        p = DataServiceUtils.addServiceName(p, this.serviceName);
        DataServiceUtils.writeProperties(p, this.destdir, this.serviceName);
    }

    protected void generateServiceClass(DeprecatedServiceDefinition def) {
        GenerationConfiguration genconf = new GenerationConfiguration(def, this.destdir);
        DataServiceGenerator generator = new DataServiceGenerator(genconf);
        generator.setGenerateMain(this.generateServiceMain);
        try {
            generator.generate();
        }
        catch (GenerationException ex) {
            throw new ConfigurationException((Throwable)((Object)ex));
        }
    }

    protected List<ExporterTask> getPostCompileExporters() {
        ArrayList<ExporterTask> rtn = new ArrayList<ExporterTask>();
        rtn.add(this.getMappingExporter());
        rtn.add(this.getConfigurationExporter());
        if (this.importDatabase) {
            rtn.add(this.getHQLExporter());
        }
        if (this.generateHibernateCfg) {
            rtn.add(this.getHibernateCfgExporter());
        }
        return rtn;
    }

    protected ExporterTask getHibernateCfgExporter() {
        return new HibernateConfigExporterTask(this.getParentTask());
    }

    protected ExporterTask getJavaExporter() {
        return new Hbm2JavaExporterTask((HibernateToolTask)this.getParentTask());
    }

    protected ExporterTask getHQLExporter() {
        return new QueryExporterTask(this.getParentTask(), this.serviceName);
    }

    protected ExporterTask getMappingExporter() {
        return new Hbm2HbmXmlExporterTask((HibernateToolTask)this.getParentTask());
    }

    private String getDefaultRevengMetaDataDialect() {
        if (this.isMySQL()) {
            return BasicMetaDataDialect.class.getName();
        }
        if (this.isHSQLDB() || this.isSQLServer() || this.isPostgres()) {
            return MetaDataDialect.class.getName();
        }
        return null;
    }

    private void checkRevengMetaDataDialect() {
        if (this.revengMetaDataDialect == null) {
            this.revengMetaDataDialect = this.properties.getProperty(REVENG_METADATA_DIALECT_SYSTEM_PROPERTY);
            if (this.revengMetaDataDialect == null) {
                this.revengMetaDataDialect = this.getDefaultRevengMetaDataDialect();
            }
        }
        if (this.revengMetaDataDialect != null) {
            if (DataServiceLoggers.importLogger.isInfoEnabled()) {
                DataServiceLoggers.importLogger.info((Object)("Using metadata dialect: " + this.revengMetaDataDialect));
            }
            this.properties.setProperty(REVENG_METADATA_DIALECT_SYSTEM_PROPERTY, this.revengMetaDataDialect);
        }
    }

    private DeprecatedServiceDefinition loadServiceDefinition() {
        File f = new File(this.destdir, this.serviceName + ".spring.xml");
        DeprecatedServiceDefinition rtn = null;
        try {
            rtn = SpringService.initialize(f);
            String s = StringUtils.fq((String)this.packageName, (String)this.className);
            DataServiceUtils.unwrapAndCast(rtn).getMetaData().setServiceClassName(s);
            return rtn;
        }
        catch (RuntimeException ex) {
            try {
                rtn.dispose();
            }
            catch (RuntimeException ignore) {
                // empty catch block
            }
            throw ex;
        }
    }

    private void checkClassesDir() {
        String s;
        if (this.classesdir == null && (s = this.properties.getProperty(CLASSES_DIR_SYSTEM_PROPERTY)) != null) {
            this.setClassesDir(new File(s));
        }
        if (this.classesdir == null) {
            this.classesdir = this.destdir;
        }
    }

    private void checkImportMode() {
        if (this.properties.getProperty(IMPORT_DATABASE_SYSTEM_PROPERTY) != null) {
            this.setImportDatabase(Boolean.getBoolean(IMPORT_DATABASE_SYSTEM_PROPERTY));
        }
        if (this.properties.getProperty(GENERATE_SERVICE_CLASS_SYSTEM_PROPERTY) != null) {
            this.setGenerateServiceClass(Boolean.getBoolean(GENERATE_SERVICE_CLASS_SYSTEM_PROPERTY));
        }
    }

    private void checkServiceClass() {
        String s;
        if ((this.serviceName == null || this.packageName == null) && (s = this.properties.getProperty(SERVICE_CLASS_SYSTEM_PROPERTY)) != null) {
            String p = StringUtils.fromLastOccurrence((String)s, (String)".", (int)-1);
            String n = StringUtils.fromLastOccurrence((String)s, (String)".");
            if (this.packageName == null) {
                this.setPackage(p);
            }
            if (this.serviceName == null) {
                this.setServiceName(n.toLowerCase());
            }
            if (this.className == null) {
                this.setClassName(n);
            }
        }
    }

    private void checkRevengFiles() {
        String s = this.properties.getProperty(REVENG_SYSTEM_PROPERTY);
        if (s != null) {
            String[] paths;
            for (String path : paths = s.split(",")) {
                File f = new File(path);
                if (!f.exists() || f.isDirectory()) {
                    if (!DataServiceLoggers.importLogger.isWarnEnabled()) continue;
                    DataServiceLoggers.importLogger.warn((Object)("reverse engineering file " + f.getAbsolutePath() + " is not valid"));
                    continue;
                }
                this.addRevengFile(f);
            }
        }
    }

    private void registerRevEngFiles() {
        if (!this.revengFiles.isEmpty()) {
            Path revengPaths = new Path(this.getProject());
            for (File f : this.revengFiles) {
                Path p = new Path(this.getProject(), f.getAbsolutePath());
                revengPaths.add(p);
            }
            this.jdbcConf.setRevEngFile(revengPaths);
        }
    }

    private void checkCreateJar() {
        String s = this.properties.getProperty(CREATE_JAR_SYSTEM_PROPERTY);
        if (s != null) {
            this.setCreateJar(Boolean.getBoolean(CREATE_JAR_SYSTEM_PROPERTY));
        }
    }

    private void checkGenerateServiceMain() {
        String s = this.properties.getProperty(GENERATE_SERVICE_MAIN_SYSTEM_PROPERTY);
        if (s != null) {
            this.setGenerateServiceMain(Boolean.getBoolean(GENERATE_SERVICE_MAIN_SYSTEM_PROPERTY));
        }
    }

    private void maybeGenerateRevEng() {
        if (!this.valuesFromReveng) {
            if (!this.revengFiles.isEmpty()) {
                throw new ConfigurationException("Please specify a package name in your reveng file");
            }
            File generatedRevEngFile = null;
            try {
                generatedRevEngFile = File.createTempFile("reveng", ".xml");
            }
            catch (IOException ex) {
                throw new ConfigurationException(ex);
            }
            this.registerTmpFileForCleanup(generatedRevEngFile);
            Reveng r = new Reveng();
            r.setPackageName(this.dataPackage);
            if (this.tableFilters.isEmpty()) {
                this.setTableFilters(r.getTableFilters());
            } else {
                r.setTableFilters(this.tableFilters);
            }
            if (this.schemaFilters.isEmpty()) {
                this.setSchemaFilters(r.getSchemaFilters());
            } else {
                r.setSchemaFilters(this.schemaFilters);
            }
            StringWriter sw = new StringWriter();
            try {
                PrintWriter pw = new PrintWriter(sw);
                r.write(pw);
                pw.close();
                if (DataServiceLoggers.importLogger.isDebugEnabled()) {
                    DataServiceLoggers.importLogger.debug((Object)("Using reveng file:\n" + sw.toString()));
                }
                FileWriter fw = new FileWriter(generatedRevEngFile);
                fw.write(sw.toString());
                try {
                    fw.close();
                }
                catch (IOException ignore) {}
            }
            catch (IOException ex) {
                throw new ConfigurationException(ex);
            }
            this.addRevengFile(generatedRevEngFile);
        }
    }

    private void setValuesFromRevEngFilesIfNotSet() {
        if (this.packageName != null) {
            return;
        }
        boolean packageSet = false;
        boolean tableFilterSet = false;
        boolean schemaFilterSet = false;
        for (File f : this.revengFiles) {
            try {
                FileReader reader = new FileReader(f);
                Reveng r = Reveng.load(reader);
                if (r.getPackage() != null && !packageSet) {
                    this.setPackage(r.getPackage());
                    this.valuesFromReveng = true;
                    packageSet = true;
                }
                if (r.getTableFilters() != null && !tableFilterSet) {
                    this.setTableFilters(r.getTableFilters());
                    this.valuesFromReveng = true;
                    tableFilterSet = true;
                }
                if (r.getSchemaFilters() != null && !schemaFilterSet) {
                    this.setSchemaFilters(r.getSchemaFilters());
                    this.valuesFromReveng = true;
                    schemaFilterSet = true;
                }
                reader.close();
            }
            catch (IOException ignore) {}
        }
    }

    private void checkGenerateHibernateConfig() {
        String s = this.properties.getProperty(GENERATE_HIBERNATE_CONFIG_SYSTEM_PROPERTY);
        if (s != null) {
            this.setGenerateHibernateCfg(Boolean.getBoolean(GENERATE_HIBERNATE_CONFIG_SYSTEM_PROPERTY));
        }
    }

    private void checkRegenerate() {
        String s = this.properties.getProperty(REGENERATE_SYSTEM_PROPERTY);
        if (s != null) {
            this.setRegenerate(Boolean.getBoolean(REGENERATE_SYSTEM_PROPERTY));
        }
    }

    private void checkGenerateOldStyleOps() {
        String s = this.properties.getProperty(GENERATE_OLD_STYLE_OPRS_PROPERTY);
        if (s != null) {
            this.setUseIndividualCRUDOperations(Boolean.getBoolean(GENERATE_OLD_STYLE_OPRS_PROPERTY));
        }
    }

    @Override
    protected boolean customInit(Collection<String> requiredProperties) {
        this.checkImportMode();
        if (this.importDatabase) {
            this.checkAlternateConnectionProperties();
            this.checkUser(requiredProperties);
            this.checkPass(requiredProperties);
            this.checkUrl(requiredProperties);
        }
        this.checkServiceName(false, requiredProperties);
        this.checkDestdir(requiredProperties);
        this.checkPackage();
        this.checkServiceClass();
        this.checkClassName(requiredProperties);
        this.checkServiceName(true, requiredProperties);
        this.checkDataPackage();
        if (this.importDatabase) {
            this.checkDBType();
            this.checkDialect(requiredProperties, false);
            this.checkDialectAndDBType(requiredProperties);
            this.checkDialect(requiredProperties, true);
            this.checkCatalogName();
            this.checkDriverClass(requiredProperties);
            this.checkRevengFiles();
            this.checkTableFilter();
            this.checkSchemaFilter();
            this.setValuesFromRevEngFilesIfNotSet();
            this.maybeGenerateRevEng();
            this.registerRevEngFiles();
            this.checkGenerateHibernateConfig();
            this.checkRegenerate();
            this.checkGenerateOldStyleOps();
        }
        this.checkClassesDir();
        this.checkCreateJar();
        this.checkGenerateServiceMain();
        this.checkRevengMetaDataDialect();
        this.checkRevengNamingStrategy();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Arrays.sort(args);
        if (Arrays.binarySearch(args, "--help") > -1 || Arrays.binarySearch(args, "-h") > -1) {
            System.out.println(ImportDB.getHelp(ImportDB.class));
            return;
        }
        ImportDB importer = new ImportDB();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) continue;
            File f = new File(args[i]);
            Properties p = com.wavemaker.runtime.data.util.DataServiceUtils.loadDBProperties(f);
            importer.setProperties(p);
        }
        boolean ok = importer.init();
        if (!ok) {
            return;
        }
        if (Arrays.binarySearch(args, "--values") > -1 || Arrays.binarySearch(args, "-v") > -1) {
            System.out.println(ImportDB.getValues(importer));
            return;
        }
        try {
            importer.run();
        }
        finally {
            try {
                importer.dispose();
            }
            catch (Exception exception) {}
        }
    }

    private static String getValues(ImportDB db) {
        String s = "Settings:\n\n";
        s = s + "  Connection properties:\n";
        s = s + "  user: " + db.username + "\n";
        s = s + "  password: " + db.password + "\n";
        s = s + "  url: " + db.connectionUrl + "\n";
        s = s + "\n";
        s = s + "  outputdir: " + db.destdir + "\n";
        s = s + "  classesdir: " + db.classesdir + "\n";
        s = s + "  service name: " + db.serviceName + "\n";
        s = s + "  service class " + db.className + "\n";
        s = s + "  java package: " + db.packageName + "\n";
        s = s + "\n";
        s = s + "  dbtype: " + db.dbtype + "\n";
        s = s + "  dialect: " + db.dialect + "\n";
        s = s + "\n";
        s = s + "  import database: " + db.importDatabase + "\n";
        s = s + "  generate service class: " + db.generateServiceClass;
        return s;
    }

    public static String getHelp(Class<?> mainClass) {
        return "\nUsage:\n\nSystem Properties (optional in brackets):\n  -Dwm.importdb.outputDir=<root output dir>\n  -Dwm.importdb.serviceClass=<fully qualified service class name>\n  -D" + USER_SYSTEM_PROPERTY + "=<db user>\n" + "  -D" + CONNECTION_URL_SYSTEM_PROPERTY + "=<jdbc connection url>\n" + "  [-D" + PASS_SYSTEM_PROPERTY + "=<db password>]\n" + "  [-D" + "wm.importdb.tableFilter" + "=<regular expression>]\n" + "  [-D" + "wm.importdb.schemaFilter" + "=<regular expression>]\n" + "  [-D" + CLASSES_DIR_SYSTEM_PROPERTY + "=<directory for generated classes>]\n" + "\n" + "Arguments (all optional):\n\n" + "  path to properties file\n" + "  -v|--values: show runtime values of properties\n" + "  -h|--help: this message\n\n" + "Example:\n\n" + "  java \\\n" + "    -D" + "wm.importdb.outputDir" + "=servicedir \\\n" + "    -D" + SERVICE_CLASS_SYSTEM_PROPERTY + "=com.test.DBService \\\n" + "    -D" + USER_SYSTEM_PROPERTY + "=root \\\n" + "    -D" + CONNECTION_URL_SYSTEM_PROPERTY + "=jdbc:mysql://localhost:3306/sakila \\\n" + "    -D" + DRIVER_CLASS_NAME_SYSTEM_PROPERTY + "=com.mysql.jdbc.Driver \\\n" + "    " + mainClass.getName() + "\n";
    }
}

