/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.runtime.data.DataServiceOperation;
import com.wavemaker.runtime.data.util.DataServiceUtils;
import com.wavemaker.tools.data.BeanInfo;
import com.wavemaker.tools.service.codegen.BeanGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class OperationWrapperGenerator {
    private BeanInfo beanInfo = null;
    private static final String CLOB_TYPE = "java.sql.Clob";
    private static final String BLOB_TYPE = "java.sql.Blob";

    public String generate(String className, DataServiceOperation operation) {
        this.beanInfo = new BeanInfo(className);
        BeanGenerator generator = new BeanGenerator(className);
        generator.addClassJavadoc("Generated for query \"" + operation.getQueryName() + "\" on " + StringUtils.getFormattedDate());
        List<String> outputTypes = operation.getOutputTypes();
        List<String> outputNames = DataServiceUtils.getColumnNames(outputTypes.size(), operation.getOutputNames());
        int i = 0;
        boolean addSerializableMember = false;
        for (String type : operation.getOutputTypes()) {
            String name = outputNames.get(i);
            generator.addProperty(name, type);
            this.beanInfo.addProperty(name, type);
            ++i;
            if (!type.equals(CLOB_TYPE) && !type.equals(BLOB_TYPE)) continue;
            addSerializableMember = true;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            if (!addSerializableMember) {
                generator.generate((OutputStream)os);
            } else {
                generator.generateAux((OutputStream)os);
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return os.toString();
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }
}

