/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.ObjectUtils;
import com.wavemaker.common.util.StringUtils;
import com.wavemaker.tools.common.ConfigurationException;
import com.wavemaker.tools.data.ColumnInfo;
import com.wavemaker.tools.data.DataModelConfiguration;
import com.wavemaker.tools.data.DataTypeMapper;
import com.wavemaker.tools.data.EntityInfo;
import com.wavemaker.tools.data.RelatedInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyInfo {
    public static final String PK_META = "pk";
    private String name = null;
    private String type = null;
    private String fullyQualifiedType = null;
    private boolean isId = false;
    private boolean isRelated = false;
    private boolean isInverse = false;
    private RelatedInfo.Cardinality cardinality = null;
    private List<RelatedInfo.CascadeOption> cascadeOptions = new ArrayList<RelatedInfo.CascadeOption>();
    private List<PropertyInfo> compositeProperties = new ArrayList<PropertyInfo>();
    private ColumnInfo columnInfo = null;

    public static PropertyInfo newToManyProperty(EntityInfo parentEntity, PropertyInfo toOneProperty) {
        PropertyInfo rtn = PropertyInfo.newToManyProperty();
        rtn.types(parentEntity.getPackageName() + "." + parentEntity.getEntityName());
        return rtn;
    }

    public static PropertyInfo fromKind(String kind, Map<String, String> attributes) {
        PropertyInfo rtn = null;
        if (kind.equals("composite-id")) {
            rtn = PropertyInfo.newCompositeIdProperty(attributes);
        } else if (kind.equals("component")) {
            rtn = PropertyInfo.newComponentProperty(attributes);
        } else if (kind.equals("id") || kind.equals("key-property")) {
            rtn = PropertyInfo.newIdProperty();
        } else if (kind.equals("many-to-one")) {
            rtn = PropertyInfo.newToOneProperty(attributes);
        } else if (kind.equals("property")) {
            rtn = PropertyInfo.newProperty();
        } else if (kind.equals("set")) {
            rtn = PropertyInfo.newToManyProperty();
        } else {
            throw new AssertionError((Object)("Unknown property kind: " + kind));
        }
        rtn.setName(attributes.get("name"));
        String type = attributes.get("type");
        if (type != null) {
            rtn.types(type);
        }
        return rtn;
    }

    public static PropertyInfo newIdProperty() {
        return PropertyInfo.newIdProperty(null);
    }

    public static PropertyInfo newIdProperty(String name) {
        PropertyInfo rtn = new PropertyInfo();
        rtn.setName(name);
        rtn.setIsId(true);
        return rtn;
    }

    public static PropertyInfo newCompositeProperty() {
        PropertyInfo rtn = new PropertyInfo();
        rtn.setCompositeProperties(new ArrayList<PropertyInfo>());
        return rtn;
    }

    public static PropertyInfo newComponentProperty(Map<String, String> attributes) {
        PropertyInfo rtn = PropertyInfo.newCompositeProperty();
        rtn.types(attributes.get("class"));
        return rtn;
    }

    public static PropertyInfo newCompositeIdProperty(Map<String, String> attributes) {
        PropertyInfo rtn = PropertyInfo.newCompositeProperty();
        rtn.setIsId(true);
        rtn.types(attributes.get("class"));
        return rtn;
    }

    public static PropertyInfo newProperty() {
        return PropertyInfo.newProperty(null);
    }

    public static PropertyInfo newProperty(String name) {
        PropertyInfo rtn = new PropertyInfo();
        rtn.setName(name);
        return rtn;
    }

    public static PropertyInfo newToManyProperty() {
        return PropertyInfo.newToManyProperty(Collections.<String, String>emptyMap());
    }

    public static PropertyInfo newToManyProperty(Map<String, String> attributes) {
        PropertyInfo rtn = PropertyInfo.newCompositeProperty();
        rtn.setIsRelated(true);
        rtn.setIsInverse(true);
        rtn.cardinality(RelatedInfo.Cardinality.OneToMany);
        rtn.addCascadeOptions(attributes);
        return rtn;
    }

    public static PropertyInfo newToOneProperty(Map<String, String> attributes) {
        PropertyInfo rtn = PropertyInfo.newCompositeProperty();
        rtn.setIsRelated(true);
        rtn.setIsInverse(false);
        rtn.types(attributes.get("class"));
        rtn.cardinality(RelatedInfo.Cardinality.OneToOne);
        rtn.addCascadeOptions(attributes);
        return rtn;
    }

    public void types(String type) {
        if (type == null) {
            this.setFullyQualifiedType(null);
            this.setType(null);
        } else {
            this.setFullyQualifiedType(DataTypeMapper.getFQHibernateType(type));
            this.setType(DataTypeMapper.getHibernateType(DataTypeMapper.getHibernateType(type)));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setIsId(boolean isId) {
        this.isId = isId;
    }

    public boolean getIsId() {
        return this.isId;
    }

    public void setIsRelated(boolean isRelated) {
        this.isRelated = isRelated;
    }

    public boolean getIsRelated() {
        return this.isRelated;
    }

    public void setIsInverse(boolean isInverse) {
        this.isInverse = isInverse;
    }

    public boolean getIsInverse() {
        return this.isInverse;
    }

    public void setCompositeProperties(List<PropertyInfo> compositeProperties) {
        this.compositeProperties = compositeProperties;
    }

    public List<PropertyInfo> getCompositeProperties() {
        return this.compositeProperties;
    }

    public void addCompositeProperty(PropertyInfo property) {
        this.compositeProperties.add(property);
    }

    public void setColumn(ColumnInfo columnInfo) {
        this.columnInfo = columnInfo;
    }

    public ColumnInfo getColumn() {
        return this.columnInfo;
    }

    public void setCardinality(String cardinality) {
        throw new AssertionError((Object)"Not implemented");
    }

    public void cardinality(RelatedInfo.Cardinality cardinality) {
        this.cardinality = cardinality;
    }

    public RelatedInfo.Cardinality getCardinality() {
        return this.cardinality;
    }

    public boolean hasCompositeProperties() {
        return this.compositeProperties.size() > 0;
    }

    public PropertyInfo getCompositeProperty(String name) {
        if (this.compositeProperties == null) {
            throw new AssertionError((Object)"No composite properties");
        }
        for (PropertyInfo p : this.compositeProperties) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public List<PropertyInfo> allProperties() {
        if (!this.hasCompositeProperties()) {
            ArrayList<PropertyInfo> rtn = new ArrayList<PropertyInfo>(1);
            rtn.add(this);
            return rtn;
        }
        ArrayList<PropertyInfo> rtn = new ArrayList<PropertyInfo>();
        this.addPropertiesRecursive(rtn, this);
        return rtn;
    }

    public List<ColumnInfo> allColumns() {
        if (!this.hasCompositeProperties()) {
            ArrayList<ColumnInfo> rtn = new ArrayList<ColumnInfo>(1);
            rtn.add(this.getColumn());
            return rtn;
        }
        ArrayList<ColumnInfo> rtn = new ArrayList<ColumnInfo>();
        this.addColumnsRecursive(rtn, this);
        return rtn;
    }

    public List<String> allColumnNames() {
        if (!this.hasCompositeProperties()) {
            ArrayList<String> rtn = new ArrayList<String>(1);
            rtn.add(this.columnInfo.getName());
            return rtn;
        }
        ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
        this.addColumnsRecursive(cols, this);
        ArrayList<String> rtn = new ArrayList<String>(cols.size());
        for (ColumnInfo ci : cols) {
            rtn.add(ci.getName());
        }
        return rtn;
    }

    public RelatedInfo toRelated(String tableName) {
        List<ColumnInfo> columns = this.allColumns();
        RelatedInfo.Cardinality c = RelatedInfo.Cardinality.OneToZeroOrOne;
        if (this.getIsInverse()) {
            c = RelatedInfo.Cardinality.OneToMany;
        } else if (columns.get(0).getNotNull()) {
            c = RelatedInfo.Cardinality.OneToOne;
        }
        RelatedInfo rtn = new RelatedInfo(this.name, this.type, tableName, c);
        rtn.setFullyQualifiedType(this.fullyQualifiedType);
        rtn.foreignKeyColumns(columns.toArray(new ColumnInfo[columns.size()]));
        if (!this.getCascadeOptions().isEmpty()) {
            rtn.setCascadeOptions(this.getCascadeOptions().get(0));
        }
        return rtn;
    }

    public void setCascadeOptions(List<RelatedInfo.CascadeOption> cascadeOptions) {
        this.cascadeOptions = cascadeOptions;
    }

    public List<RelatedInfo.CascadeOption> getCascadeOptions() {
        return this.cascadeOptions;
    }

    private void typeFromColumn(ColumnInfo column) {
        if (ObjectUtils.isNullOrEmpty((String)column.getSqlType())) {
            throw new AssertionError((Object)"Type must be set");
        }
        this.type = DataTypeMapper.getHibernateType(column.getSqlType());
        this.fullyQualifiedType = DataTypeMapper.getFQHibernateType(column.getSqlType());
        column.persistType(false);
    }

    public void fromColumn(ColumnInfo column) {
        this.name = column.getName();
        this.typeFromColumn(column);
        this.isId = column.getIsPk();
        this.columnInfo = column;
    }

    public void fromRelated(RelatedInfo rel, EntityInfo owningEntity, DataModelConfiguration cfg) {
        this.name = rel.getName();
        this.type = rel.getRelatedType();
        this.fullyQualifiedType = rel.getFullyQualifiedType();
        this.isId = false;
        this.isRelated = true;
        this.cardinality = rel.cardinality();
        this.cascadeOptions = new ArrayList<RelatedInfo.CascadeOption>(0);
        this.cascadeOptions.add(rel.getCascadeOptions());
        if (rel.cardinality() == RelatedInfo.Cardinality.OneToMany) {
            this.isInverse = true;
            owningEntity = cfg.getEntity(rel.getRelatedType());
        }
        ArrayList<ColumnInfo> foreignKeyCols = new ArrayList<ColumnInfo>();
        for (String s : rel.getColumnNames()) {
            ColumnInfo ci = owningEntity.getColumn(s);
            if (ci == null) {
                throw new ConfigurationException("Unable to find foreign key column " + owningEntity.getTableName() + "." + s);
            }
            ColumnInfo clone = (ColumnInfo)ci.clone();
            clone.setIsFk(true);
            clone.setIsPk(false);
            if (this.isInverse) {
                clone.setSqlType(null);
            }
            foreignKeyCols.add(clone);
        }
        if (foreignKeyCols.size() == 1) {
            this.columnInfo = (ColumnInfo)foreignKeyCols.iterator().next();
        } else {
            for (ColumnInfo ci : foreignKeyCols) {
                PropertyInfo p = PropertyInfo.newProperty();
                p.fromColumn(ci);
                this.addCompositeProperty(p);
            }
        }
    }

    public boolean isEqualTo(PropertyInfo o) {
        if (o == null) {
            return false;
        }
        boolean rtn = String.valueOf((Object)this.cardinality).equals(String.valueOf((Object)o.cardinality));
        rtn &= String.valueOf(this.fullyQualifiedType).equals(String.valueOf(o.fullyQualifiedType));
        rtn &= String.valueOf(this.isId).equals(String.valueOf(o.isId));
        rtn &= String.valueOf(this.isInverse).equals(String.valueOf(o.isInverse));
        rtn &= String.valueOf(this.isRelated).equals(String.valueOf(o.isRelated));
        rtn &= String.valueOf(this.name).equals(String.valueOf(o.name));
        rtn &= String.valueOf(this.type).equals(String.valueOf(o.type));
        if (this.columnInfo == null && o.columnInfo != null) {
            return false;
        }
        if (this.columnInfo != null && o.columnInfo == null) {
            return false;
        }
        if (this.columnInfo != null || o.columnInfo != null) {
            rtn &= this.columnInfo.isEqualTo(o.columnInfo);
        }
        if (this.compositeProperties.size() != o.compositeProperties.size()) {
            return false;
        }
        int i = 0;
        for (PropertyInfo p : this.compositeProperties) {
            if (rtn &= p.isEqualTo(o.compositeProperties.get(i++))) continue;
            return false;
        }
        return rtn;
    }

    public String javaType() {
        Class<?> rtn = DataTypeMapper.getJavaType(this.fullyQualifiedType);
        if (rtn == null) {
            return this.fullyQualifiedType;
        }
        return rtn.getName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.propertyToString(sb, this, "");
        for (PropertyInfo p : this.compositeProperties) {
            sb.append("\n");
            this.propertyToString(sb, p, "  ");
        }
        return sb.toString();
    }

    private void propertyToString(StringBuilder sb, PropertyInfo property, String indent) {
        sb.append(indent);
        if (property.getIsId()) {
            sb.append("*");
        } else if (property.getIsRelated()) {
            if (property.getIsInverse()) {
                sb.append("<");
            } else {
                sb.append(">");
            }
        }
        sb.append(property.getName()).append(" ").append(property.getType());
        if (property.getColumn() != null) {
            sb.append(" -> ").append(property.getColumn());
        }
    }

    private void addPropertiesRecursive(List<PropertyInfo> props, PropertyInfo p) {
        props.add(p);
        for (PropertyInfo p2 : p.getCompositeProperties()) {
            this.addPropertiesRecursive(props, p2);
        }
    }

    private void addColumnsRecursive(List<ColumnInfo> col, PropertyInfo p) {
        if (p.getColumn() != null) {
            col.add(p.getColumn());
        }
        for (PropertyInfo p2 : p.getCompositeProperties()) {
            this.addColumnsRecursive(col, p2);
        }
    }

    private void addCascadeOptions(Map<String, String> attributes) {
        if (!attributes.containsKey("cascade")) {
            return;
        }
        String co = attributes.get("cascade");
        if (ObjectUtils.isNullOrEmpty((String)co)) {
            return;
        }
        List t = StringUtils.split((String)co);
        ArrayList<RelatedInfo.CascadeOption> cascadeOptions = new ArrayList<RelatedInfo.CascadeOption>(t.size());
        for (String s : t) {
            cascadeOptions.add(RelatedInfo.CascadeOption.fromString(s));
        }
        this.setCascadeOptions(cascadeOptions);
    }

    private void setFullyQualifiedType(String fullyQualifiedType) {
        this.fullyQualifiedType = fullyQualifiedType;
    }
}

