/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.common.util.StringUtils;
import com.wavemaker.common.util.XMLUtils;
import com.wavemaker.runtime.data.DataServiceMetaData;
import com.wavemaker.tools.data.GenerationContext;
import com.wavemaker.tools.data.util.DataServiceUtils;
import java.io.File;
import java.util.HashMap;
import org.hibernate.mapping.Property;
import org.hibernate.tool.hbm2x.GenericExporter;
import org.hibernate.tool.hbm2x.TemplateProducer;

public class QueryExporter
extends GenericExporter {
    private static final String TEMPLATE = "/com/wavemaker/tools/data/Queries.ftl";
    private final String serviceName;

    public QueryExporter(String serviceName) {
        this.setTemplateName(TEMPLATE);
        this.serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        HashMap<String, Context> additionalContext = new HashMap<String, Context>(1);
        Context ctx = new Context(this.serviceName);
        additionalContext.put("agcontext", ctx);
        try {
            Class<?> entity = ctx.getEntity();
            String s = StringUtils.packageToSrcFilePath((String)entity.getName()) + ".ql.xml";
            TemplateProducer producer = new TemplateProducer(this.getTemplateHelper(), this.getArtifactCollector());
            File path = new File(this.getOutputDirectory(), s);
            producer.produce(additionalContext, this.getTemplateName(), path, this.getTemplateName());
        }
        finally {
            ctx.dispose();
        }
    }

    public String getName() {
        return "query exporter";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Context
    extends GenerationContext {
        private final Class<?> entity;

        Context(String serviceName) {
            super(serviceName, QueryExporter.this.getConfiguration(), false);
            this.entity = DataServiceUtils.getTypesForGeneratedQueries(this.def.getMetaData()).iterator().next();
        }

        public String getEntityName() {
            return XMLUtils.escape((String)this.entity.getSimpleName());
        }

        public String getEntityType() {
            return XMLUtils.escape((String)this.entity.getName());
        }

        public Class<?> getEntity() {
            return this.entity;
        }

        public String getIdType() {
            DataServiceMetaData m = this.getDataServiceDefinition().getMetaData();
            String id = m.getIdPropertyName(this.entity);
            Property p = m.getProperty(this.entity.getName(), id);
            return XMLUtils.escape((String)p.getType().getReturnedClass().getName());
        }
    }
}

