/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.tools.data;

import com.wavemaker.tools.data.ColumnInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RelatedInfo
implements Cloneable {
    private String name = null;
    private String tableName = null;
    private String fullyQualifiedType = null;
    private String relatedType = null;
    private List<ColumnInfo> foreignKeyColumns = new ArrayList<ColumnInfo>();
    private List<String> foreignKeyColumnNames = new ArrayList<String>();
    private Cardinality cardinality = null;
    private List<CascadeOption> cascadeOptions = new ArrayList<CascadeOption>();

    public RelatedInfo() {
    }

    public RelatedInfo(String name, String relatedType, String tableName, Cardinality cardinality) {
        this.name = name;
        this.tableName = tableName;
        this.relatedType = relatedType;
        this.cardinality = cardinality;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRelatedType() {
        return this.relatedType;
    }

    public void setRelatedType(String relatedType) {
        this.relatedType = relatedType;
    }

    public void setFullyQualifiedType(String fullyQualifiedType) {
        this.fullyQualifiedType = fullyQualifiedType;
    }

    public String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    public String getCardinality() {
        return this.cardinality.toString();
    }

    public Cardinality cardinality() {
        return this.cardinality;
    }

    public void setCardinality(String cardinality) {
        if (cardinality.equals(Cardinality.OneToMany.toString())) {
            this.cardinality = Cardinality.OneToMany;
        } else if (cardinality.equals(Cardinality.OneToOne.toString())) {
            this.cardinality = Cardinality.OneToOne;
        } else if (cardinality.equals(Cardinality.OneToZeroOrOne.toString())) {
            this.cardinality = Cardinality.OneToZeroOrOne;
        } else {
            throw new AssertionError((Object)("Unknown cardinality: " + cardinality));
        }
    }

    public void setCascadeOptions(CascadeOption cascadeOption) {
        this.cascadeOptions = new ArrayList<CascadeOption>(1);
        this.cascadeOptions.add(cascadeOption);
    }

    public CascadeOption getCascadeOptions() {
        if (this.cascadeOptions.isEmpty()) {
            return CascadeOption.None;
        }
        return this.cascadeOptions.get(0);
    }

    public ColumnInfo[] foreignKeyColumns() {
        return this.foreignKeyColumns.toArray(new ColumnInfo[this.foreignKeyColumns.size()]);
    }

    public void setColumnNames(String[] names) {
        this.foreignKeyColumnNames = Arrays.asList(names);
    }

    public void foreignKeyColumns(ColumnInfo[] foreignKeyColumns) {
        this.foreignKeyColumns = Arrays.asList(foreignKeyColumns);
        this.foreignKeyColumnNames = new ArrayList<String>(foreignKeyColumns.length);
        for (ColumnInfo i : foreignKeyColumns) {
            this.foreignKeyColumnNames.add(i.getName());
        }
    }

    public String[] getColumnNames() {
        return this.foreignKeyColumnNames.toArray(new String[this.foreignKeyColumnNames.size()]);
    }

    public String toString() {
        return this.name + " fq: " + this.fullyQualifiedType + " related type: " + this.relatedType;
    }

    public Object clone() {
        try {
            RelatedInfo rtn = (RelatedInfo)super.clone();
            rtn.foreignKeyColumns = new ArrayList<ColumnInfo>(this.foreignKeyColumns.size());
            for (ColumnInfo ci : this.foreignKeyColumns) {
                rtn.foreignKeyColumns.add((ColumnInfo)ci.clone());
            }
            return rtn;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CascadeOption {
        None("none"),
        SaveUpdate("save-update"),
        Persist("persist"),
        Merge("merge"),
        Delete("delete"),
        Remove("remove"),
        Lock("lock"),
        Replicate("replicate"),
        Evict("evict"),
        Refresh("refresh"),
        All("all"),
        DeleteOrphan("delete-orphan");

        private String toString;

        private CascadeOption(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }

        public static CascadeOption fromString(String s) {
            if (None.toString().equalsIgnoreCase(s)) {
                return None;
            }
            if (SaveUpdate.toString().equalsIgnoreCase(s)) {
                return SaveUpdate;
            }
            if (Persist.toString().equalsIgnoreCase(s)) {
                return Persist;
            }
            if (Merge.toString().equalsIgnoreCase(s)) {
                return Merge;
            }
            if (Delete.toString().equalsIgnoreCase(s)) {
                return Delete;
            }
            if (Remove.toString().equalsIgnoreCase(s)) {
                return Remove;
            }
            if (Lock.toString().equalsIgnoreCase(s)) {
                return Lock;
            }
            if (Replicate.toString().equalsIgnoreCase(s)) {
                return Replicate;
            }
            if (Evict.toString().equalsIgnoreCase(s)) {
                return Evict;
            }
            if (Refresh.toString().equalsIgnoreCase(s)) {
                return Refresh;
            }
            if (All.toString().equalsIgnoreCase(s)) {
                return All;
            }
            if (DeleteOrphan.toString().equalsIgnoreCase(s)) {
                return DeleteOrphan;
            }
            throw new AssertionError((Object)("Unknown cascade option: " + s));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cardinality {
        OneToZeroOrOne,
        OneToOne,
        OneToMany;


        public String toString() {
            if (this == OneToZeroOrOne) {
                return "to-zero-or-one";
            }
            if (this == OneToOne) {
                return "to-one";
            }
            return "to-many";
        }
    }
}

